/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.GroupChangeEvent;
import net.sourceforge.jocular.objects.GroupListener;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectCombo;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.AxisPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;

public class OpticsObjectGroup
extends AbstractOpticsObject
implements OpticsObject,
OpticsObjectCombo {
    private final PropertyUpdatedListener m_objectListener;
    private final CopyOnWriteArrayList<GroupListener> m_groupListeners = new CopyOnWriteArrayList();
    private final ArrayList<OpticsObject> m_objects = new ArrayList();

    @Override
    public void setProperty(PropertyKey key, String s) {
        super.setProperty(key, s);
        switch (key) {
            default: 
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public void positionerUpdated() {
        super.positionerUpdated();
        for (OpticsObject o : this.getObjects()) {
            o.updatePositioner(this.getPositioner());
        }
    }

    @Override
    public void updatePositioner(ObjectPositioner parentPositioner) {
        super.updatePositioner(parentPositioner);
        for (OpticsObject o : this.getObjects()) {
            o.updatePositioner(this.getPositioner());
        }
    }

    public void addGroupListener(GroupListener listener) {
        this.m_groupListeners.addIfAbsent(listener);
    }

    public void removeGroupListener(GroupListener listener) {
        this.m_groupListeners.remove(listener);
    }

    private void fireGroupChangeEvent(OpticsObject o, GroupChangeEvent.ChangeType t) {
        GroupChangeEvent e = new GroupChangeEvent(this, o, t);
        for (GroupListener gl : this.m_groupListeners) {
            gl.groupChanged(e);
        }
    }

    public OpticsObjectGroup() {
        this.setPositioner(new AxisPositioner());
        this.m_objectListener = new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                for (OpticsObject o : OpticsObjectGroup.this.getObjects()) {
                    o.updatePositioner(OpticsObjectGroup.this.getPositioner());
                }
            }
        };
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        for (OpticsObject o : this.m_objects) {
            o.getPossibleInteraction(pt, is);
        }
    }

    public void add(OpticsObject o, int pos) {
        o.addPropertyUpdatedListener(this.m_objectListener);
        if (pos > this.m_objects.size()) {
            throw new RuntimeException("Index is greater than list size.");
        }
        if (pos < 0) {
            this.m_objects.add(o);
        } else {
            this.m_objects.add(pos, o);
        }
        this.fireGroupChangeEvent(o, GroupChangeEvent.ChangeType.ADD);
    }

    public void addToEnd(OpticsObject o) {
        this.add(o, -1);
    }

    public void remove(OpticsObject o) {
        this.m_objects.remove(o);
        o.removePropertyUpdatedListener(this.m_objectListener);
        this.fireGroupChangeEvent(o, GroupChangeEvent.ChangeType.REMOVE);
    }

    @Override
    public Collection<OpticsObject> getObjects() {
        return this.m_objects;
    }

    public Collection<OpticsObject> getFlattenedOpticsObjects(boolean includeSuppressedObjects) {
        ArrayList<OpticsObject> optics = new ArrayList<OpticsObject>();
        for (OpticsObject optic : this.m_objects) {
            if (!includeSuppressedObjects && optic.isSuppressed()) continue;
            if (optic instanceof OpticsObjectGroup) {
                optics.addAll(((OpticsObjectGroup)optic).getFlattenedOpticsObjects(includeSuppressedObjects));
                continue;
            }
            optics.add(optic);
        }
        return optics;
    }

    public Collection<OpticsObject> getFlattenedObjectsOfType(Class<?> type, boolean includeSuppressedObjects) {
        ArrayList<OpticsObject> optics = new ArrayList<OpticsObject>();
        for (OpticsObject optic : this.m_objects) {
            if (!includeSuppressedObjects && optic.isSuppressed()) continue;
            if (optic instanceof OpticsObjectGroup) {
                optics.addAll(((OpticsObjectGroup)optic).getFlattenedObjectsOfType(type, includeSuppressedObjects));
            }
            if (optic.getClass() != type) continue;
            optics.add(optic);
        }
        return optics;
    }

    @Override
    public OpticsObject makeCopy() {
        OpticsObjectGroup result = new OpticsObjectGroup();
        result.copyEverything(this);
        return result;
    }

    protected void copyEverything(OpticsObjectGroup g) {
        this.setPositioner(g.getPositioner().makeCopy());
        this.copyProperties(g);
        this.setPositioner(g.getPositioner().makeCopy());
        for (OpticsObject o : g.getObjects()) {
            this.add(o.makeCopy(), -1);
        }
    }

    public int getPos(OpticsObject o) {
        return this.m_objects.indexOf(o);
    }

    public Collection<OutputObject> getOutputObjects() {
        ArrayList<OutputObject> os = new ArrayList<OutputObject>();
        for (OpticsObject optics : this.getFlattenedOpticsObjects(false)) {
            if (!(optics instanceof OutputObject)) continue;
            os.add((OutputObject)optics);
        }
        return os;
    }

    @Override
    public void accept(OpticsObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void setSelected(boolean s) {
        super.setSelected(s);
        for (OpticsObject o : this.m_objects) {
            o.setSelected(s);
        }
    }

    @Override
    public void doInternalCalcs() {
        super.doInternalCalcs();
        for (OpticsObject oo : this.getObjects()) {
            oo.doInternalCalcs();
        }
    }
}

