/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.objects;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.OpticalCalcs;
import net.sourceforge.jocular.objects.OpticsID;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.CalculatedProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.properties.StringProperty;

public abstract class AbstractOpticsObject
implements OpticsObject {
    protected ObjectPositioner m_positioner;
    protected MaterialProperty m_insideMaterial;
    private StringProperty m_name;
    private boolean m_selected;
    private BooleanProperty m_suppressed;
    private EquationArrayProperty m_variables = new EquationArrayProperty("", (PropertyOwner)this, PropertyKey.VARIABLES);
    private OpticsID m_id = new OpticsID();
    private Collection<PropertyUpdatedListener> m_propertyUpdatedListeners = new CopyOnWriteArrayList<PropertyUpdatedListener>();
    private PropertyUpdatedListener m_positonerListener;

    public AbstractOpticsObject() {
        this.m_positioner = new OffsetPositioner();
        this.m_insideMaterial = new MaterialProperty(MaterialProperty.MaterialKey.VACUUM.name());
        this.m_suppressed = new BooleanProperty("false");
        this.m_name = new StringProperty("");
        this.m_positonerListener = new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                AbstractOpticsObject.this.firePropertyUpdated(PropertyKey.POSITIONER);
                AbstractOpticsObject.this.positionerUpdated();
            }
        };
    }

    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        OpticalCalcs.calcReflectOrRefractRay(pi, pt);
    }

    public void positionerUpdated() {
    }

    @Override
    public void updatePositioner(ObjectPositioner parentPositioner) {
        this.getPositioner().update(parentPositioner);
    }

    @Override
    public void setPositioner(ObjectPositioner op) {
        this.m_positioner.removePropertyUpdatedListener(this.m_positonerListener);
        this.m_positioner = op;
        this.m_positioner.addPropertyUpdatedListener(this.m_positonerListener);
        this.m_positioner.doInternalCalcs();
        this.firePropertyUpdated(PropertyKey.POSITIONER);
    }

    @Override
    public ObjectPositioner getPositioner() {
        return this.m_positioner;
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case NAME: {
                this.m_name = new StringProperty(s);
                this.firePropertyUpdated(key);
                break;
            }
            case INSIDE_MATERIAL: {
                this.m_insideMaterial = new MaterialProperty(s);
                this.firePropertyUpdated(key);
                break;
            }
            case SUPPRESSED: {
                this.m_suppressed = new BooleanProperty(s);
                this.firePropertyUpdated(key);
                break;
            }
            case VARIABLES: {
                this.m_variables = new EquationArrayProperty(s, (PropertyOwner)this, key);
                break;
            }
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<String> result;
        switch (key) {
            case NAME: {
                result = this.m_name;
                break;
            }
            case INSIDE_MATERIAL: {
                result = this.m_insideMaterial;
                break;
            }
            case SUPPRESSED: {
                result = this.m_suppressed;
                break;
            }
            case VARIABLES: {
                result = this.m_variables;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED));
        return result;
    }

    @Override
    public List<Property<?>> getProperties() {
        ArrayList result = new ArrayList();
        for (PropertyKey pk : this.getPropertyKeys()) {
            result.add(this.getProperty(pk));
        }
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        throw new RuntimeException(this.getClass().getCanonicalName() + ".makeCopy not implemented yet.");
    }

    @Override
    public void copyProperties(PropertyOwner o) {
        for (PropertyKey k : this.getPropertyKeys()) {
            this.copyProperty(o, k);
        }
    }

    @Override
    public void copyProperty(PropertyOwner owner, PropertyKey k) {
        Property<?> p = owner.getProperty(k);
        if (p != null) {
            this.setProperty(k, p.getDefiningString());
        }
    }

    @Override
    public boolean isSelected() {
        return this.m_selected;
    }

    @Override
    public void setSelected(boolean s) {
        this.m_selected = s;
        this.firePropertyUpdated(PropertyKey.SELECTED);
    }

    @Override
    public OpticsID getID() {
        return this.m_id;
    }

    @Override
    public void setID(OpticsID id) {
        this.m_id = id;
    }

    @Override
    public OpticsID getLinkID() {
        return this.m_positioner.getID();
    }

    @Override
    public OpticalMaterial getMaterial() {
        return this.m_insideMaterial.getValue();
    }

    @Override
    public boolean isSuppressed() {
        return this.m_suppressed.getValue();
    }

    @Override
    public void addPropertyUpdatedListener(PropertyUpdatedListener listener) {
        if (!this.m_propertyUpdatedListeners.contains(listener)) {
            this.m_propertyUpdatedListeners.add(listener);
        }
    }

    @Override
    public void removePropertyUpdatedListener(PropertyUpdatedListener listener) {
        this.m_propertyUpdatedListeners.remove(listener);
    }

    @Override
    public void firePropertyUpdated(PropertyKey key) {
        PropertyUpdatedEvent e = new PropertyUpdatedEvent(this, key);
        for (PropertyUpdatedListener listener : this.m_propertyUpdatedListeners) {
            listener.propertyUpdated(e);
        }
    }

    @Override
    public String getName() {
        Property<?> p = this.getProperty(PropertyKey.NAME);
        String result = p == null ? "" : p.getDefiningString();
        return result;
    }

    @Override
    public boolean isSame(OpticsObject o) {
        return o == this;
    }

    @Override
    public void doInternalCalcs() {
        this.getPositioner().doInternalCalcs();
        for (PropertyKey pk : this.getPropertyKeys()) {
            Property<?> p = this.getProperty(pk);
            if (!(p instanceof CalculatedProperty)) continue;
            CalculatedProperty cp = (CalculatedProperty)((Object)p);
            cp.calcValue(this, pk);
        }
    }
}

