/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.mesh;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.mesh.MeshData;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.MeshDataProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;

public class MeshOpticsObject
extends AbstractOpticsObject {
    private static final double EPSILON = 1.0E-16;
    private MeshDataProperty m_meshData = new MeshDataProperty("");
    private EquationProperty m_scale = new EquationProperty("1m", this, PropertyKey.SCALE);

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        boolean inside = true;
        Photon p = pt.getPhoton();
        Vector3D p1 = this.getPositioner().untransform(p.getOrigin());
        Vector3D p2 = this.getPositioner().untransform(p.getOrigin().add(p.getDirection()));
        MeshData data = this.m_meshData.getValue();
        int i = 0;
        while (i < data.getTriangleCount()) {
            Vector3D v = this.calcIntersection(data.getScaledTriangleVertex(i, 0), data.getScaledTriangleVertex(i, 1), data.getScaledTriangleVertex(i, 2), data.getTriangleNormal(i), p1, p2);
            if (v != null) {
                Vector3D loc = this.getPositioner().transform(v);
                Vector3D norm = this.getPositioner().transform(v.add(data.getTriangleNormal(i)).subtract(loc));
                is.add(new PhotonInteraction(p, this, null, loc, norm, "Mesh Object interaction"));
            }
            ++i;
        }
    }

    @Override
    public void accept(OpticsObjectVisitor v) {
        v.visit(this);
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case MESH_DATA: {
                this.m_meshData = new MeshDataProperty(s);
                double d = this.m_meshData.getValue().computeMaxDistance();
                break;
            }
            case SCALE: {
                this.m_scale = new EquationProperty(s, this, key);
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        this.doInternalCalcs();
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<MeshData> result;
        switch (key) {
            case MESH_DATA: {
                result = this.m_meshData;
                break;
            }
            case SCALE: {
                result = this.m_scale;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.INSIDE_MATERIAL, PropertyKey.SCALE, PropertyKey.MESH_DATA));
        return result;
    }

    @Override
    public OpticsObject makeCopy() {
        MeshOpticsObject result = new MeshOpticsObject();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public void doInternalCalcs() {
        this.m_meshData.getValue().setScale(this.m_scale.getValue().getBaseUnitValue());
        super.doInternalCalcs();
    }

    protected MeshData getMeshData() {
        return this.m_meshData.getValue();
    }

    protected Vector3D calcIntersection(Vector3D v1, Vector3D v2, Vector3D v3, Vector3D n, Vector3D p1, Vector3D p2) {
        double d;
        Vector3D u = v2.subtract(v1);
        Vector3D v = v3.subtract(v1);
        Vector3D dir = p2.subtract(p1);
        Vector3D w0 = p1.subtract(v1);
        double a = -n.dot(w0);
        double b = n.dot(dir);
        if (Math.abs(b) < 1.0E-16) {
            return null;
        }
        double r = a / b;
        if (r <= 0.0) {
            return null;
        }
        if (Double.isInfinite(r)) {
            System.out.println("MeshOpticsObject.calcIntersection is infinite.");
        }
        Vector3D i = p1.add(dir.scale(r));
        double uu = u.dot(u);
        double uv = u.dot(v);
        double vv = v.dot(v);
        Vector3D w = i.subtract(v1);
        double wu = w.dot(u);
        double wv = w.dot(v);
        double s = (uv * wv - vv * wu) / (d = uv * uv - uu * vv);
        if (s < 0.0 || s > 1.0) {
            return null;
        }
        double t = (uv * wu - uu * wv) / d;
        if (t < 0.0 || s + t > 1.0) {
            return null;
        }
        return i;
    }

    public boolean isEmpty() {
        return this.m_meshData.getValue().getVertexCount() == 0;
    }
}

