/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.mesh;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.mesh.MeshData;
import net.sourceforge.jocular.properties.MeshDataProperty;
import net.sourceforge.jocular.util.BackgroundRunner;

public class MeshLoader {
    private final byte[] m_bytes = new byte[20];
    private final ByteBuffer m_buffer = ByteBuffer.wrap(this.m_bytes).order(ByteOrder.LITTLE_ENDIAN);
    private double m_bytesLoaded;
    private double m_fileSizeInBytes;
    private double m_lastUpdate = 0.0;
    private MeshDataProperty m_result = null;

    private MeshData readAscii(InputStream is, BackgroundRunner.ProgressListener pl) throws NotAsciiException, IOException {
        MeshData result = new MeshData();
        try (InputStreamReader r = new InputStreamReader(is);
             BufferedReader br = new BufferedReader(r);){
            this.m_bytesLoaded = 0.0;
            boolean notDone = true;
            boolean solidRead = false;
            boolean facetRead = false;
            int vertexCount = 0;
            int lineNumber = -1;
            Vector3D v1 = null;
            Vector3D v2 = null;
            Vector3D v3 = null;
            while (notDone) {
                ++lineNumber;
                String line = br.readLine();
                if (line == null) {
                    if (!solidRead || !facetRead) {
                        throw new NotAsciiException("Never read a \"solid\" keyword, or perhaps a \"facet\" keyword");
                    }
                    result.fileEndedTooSoon();
                    break;
                }
                this.m_bytesLoaded += (double)line.length();
                pl.setProgress(this.m_bytesLoaded / this.m_fileSizeInBytes, "Reading Mesh");
                String[] ss = (line = line.trim()).split("\\s");
                if (ss.length <= 0) continue;
                switch (ss[0]) {
                    case "solid": {
                        solidRead = true;
                        result.setHeaderOrName(line.substring(5));
                        break;
                    }
                    case "facet": {
                        facetRead = true;
                        vertexCount = 0;
                        break;
                    }
                    case "endsolid": {
                        notDone = false;
                        break;
                    }
                    case "outer loop": {
                        break;
                    }
                    case "vertex": {
                        double x = 0.0;
                        double y = 0.0;
                        double z = 0.0;
                        try {
                            x = Double.parseDouble(ss[1]);
                            y = Double.parseDouble(ss[2]);
                            z = Double.parseDouble(ss[3]);
                        }
                        catch (NumberFormatException e) {
                            throw new NotAsciiException("Could not parse numbers on line " + lineNumber + " \"" + line + "\"");
                        }
                        switch (vertexCount) {
                            case 0: {
                                v1 = new Vector3D(x, y, z);
                                break;
                            }
                            case 1: {
                                v2 = new Vector3D(x, y, z);
                                break;
                            }
                            case 2: {
                                v3 = new Vector3D(x, y, z);
                                result.addTriangle(v1, v2, v3);
                                break;
                            }
                        }
                        ++vertexCount;
                        break;
                    }
                }
            }
        }
        return result;
    }

    private MeshData readBinary(InputStream is, BackgroundRunner.ProgressListener pl) throws IOException {
        MeshData result = new MeshData();
        this.m_bytesLoaded = 0.0;
        byte[] bs = is.readNBytes(80);
        result.setHeaderOrName(new String(bs, "UTF-8"));
        this.m_bytesLoaded = 80.0;
        int n = this.readInt(is);
        try {
            for (int i = 0; i < n; ++i) {
                double nx = this.readFloat(is);
                double ny = this.readFloat(is);
                double nz = this.readFloat(is);
                double x1 = this.readFloat(is);
                double y1 = this.readFloat(is);
                double z1 = this.readFloat(is);
                double x2 = this.readFloat(is);
                double y2 = this.readFloat(is);
                double z2 = this.readFloat(is);
                double x3 = this.readFloat(is);
                double y3 = this.readFloat(is);
                double z3 = this.readFloat(is);
                int abc = this.readShort(is);
                result.addTriangle(new Vector3D(x1, y1, z1), new Vector3D(x2, y2, z2), new Vector3D(x3, y3, z3));
                pl.setProgress(this.m_bytesLoaded / this.m_fileSizeInBytes, "Reading Mesh");
            }
        }
        catch (IOException e) {
            result.fileEndedTooSoon();
        }
        return result;
    }

    public static MeshDataProperty load(File f, BackgroundRunner.ProgressListener pl) {
        MeshLoader loader = new MeshLoader();
        loader.localLoad(f, pl);
        return loader.getResult();
    }

    private void localLoad(File file, BackgroundRunner.ProgressListener pl) {
        BufferedInputStream bis;
        FileInputStream fis;
        MeshData result = null;
        boolean notAscii = false;
        this.m_fileSizeInBytes = file.length();
        try {
            fis = new FileInputStream(file);
            try {
                bis = new BufferedInputStream(fis);
                try {
                    result = this.readAscii(bis, pl);
                }
                finally {
                    bis.close();
                }
            }
            finally {
                fis.close();
            }
        }
        catch (NotAsciiException e) {
            notAscii = true;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (notAscii) {
            try {
                fis = new FileInputStream(file);
                try {
                    bis = new BufferedInputStream(fis);
                    try {
                        result = this.readBinary(bis, pl);
                    }
                    finally {
                        bis.close();
                    }
                }
                finally {
                    fis.close();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (result != null) {
            String msg = "Read " + result.getTriangleCount() + " triangles\nLargest point to point distance is " + result.computeMaxDistance();
            msg = result.computeMaxDistance() > 1.0 ? msg + "\nMesh is likely in small units, like millimetres unless it is quite large." : msg + "\nMesh is likely in large units, like metres unless it is quite small.";
            pl.setProgress(1.0, msg);
            this.m_result = new MeshDataProperty(result);
        }
    }

    private double readFloat(InputStream is) throws IOException {
        double result = Double.NaN;
        byte[] bs = is.readNBytes(4);
        this.m_bytesLoaded += 4.0;
        this.m_buffer.put(bs);
        this.m_buffer.rewind();
        result = this.m_buffer.getFloat();
        this.m_buffer.clear();
        return result;
    }

    private int readShort(InputStream is) throws IOException {
        short result = 0;
        byte[] bs = is.readNBytes(2);
        this.m_bytesLoaded += 2.0;
        this.m_buffer.put(bs);
        this.m_buffer.rewind();
        result = this.m_buffer.getShort();
        this.m_buffer.clear();
        return result;
    }

    private int readInt(InputStream is) throws IOException {
        int result = 0;
        byte[] bs = is.readNBytes(4);
        this.m_buffer.put(bs);
        this.m_buffer.rewind();
        result = this.m_buffer.getInt();
        this.m_buffer.clear();
        return result;
    }

    public MeshDataProperty getResult() {
        return this.m_result;
    }

    private class NotAsciiException
    extends Exception {
        NotAsciiException(String message) {
            super(message);
        }
    }
}

