/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.mesh;

import java.util.ArrayList;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.mesh.MeshTriangle;

public class MeshData {
    private static final double EPSILON = 1.0E-15;
    private String m_headerOrName = "";
    private final ArrayList<MeshTriangle> m_triangles = new ArrayList();
    private final ArrayList<Vector3D> m_vertices = new ArrayList();
    private final ArrayList<Vector3D> m_scaledVertices = new ArrayList();
    boolean fileEndedTooSoon = false;
    private double m_scale = 1.0;

    public void addTriangle(Vector3D v1, Vector3D v2, Vector3D v3) {
        this.m_triangles.add(new MeshTriangle(this.m_vertices, this.addVertex(v1), this.addVertex(v2), this.addVertex(v3)));
    }

    private int addVertex(Vector3D v) {
        int result = -1;
        for (int i = 0; i < this.m_vertices.size(); ++i) {
            Vector3D vt = this.m_vertices.get(i);
            if (!(v.distanceTo(vt) <= 1.0E-15 * vt.abs())) continue;
            result = i;
            break;
        }
        if (result < 0) {
            this.m_vertices.add(v);
            this.m_scaledVertices.add(v.scale(this.m_scale));
            result = this.m_vertices.size() - 1;
        }
        return result;
    }

    public int getTriangleCount() {
        return this.m_triangles.size();
    }

    public void setScale(double s) {
        this.m_scale = s;
        for (int i = 0; i < this.m_vertices.size(); ++i) {
            this.m_scaledVertices.set(i, this.m_vertices.get(i).scale(s));
        }
    }

    public int getVertexCount() {
        return this.m_vertices.size();
    }

    public int getTriangleVertexIndex(int ti, int vi) {
        MeshTriangle t = this.m_triangles.get(ti);
        return t.getVertexIndex(vi);
    }

    public Vector3D getScaledTriangleVertex(int ti, int vi) {
        return this.m_scaledVertices.get(this.getTriangleVertexIndex(ti, vi));
    }

    public Vector3D getTriangleVertex(int ti, int vi) {
        return this.m_vertices.get(this.getTriangleVertexIndex(ti, vi));
    }

    public Vector3D getVertex(int i) {
        return this.m_vertices.get(i);
    }

    public Vector3D getScaledVertex(int i) {
        return this.m_scaledVertices.get(i);
    }

    public Vector3D getTriangleNormal(int i) {
        return this.m_triangles.get((int)i).n;
    }

    public void setHeaderOrName(String hn) {
        this.m_headerOrName = hn;
    }

    public void fileEndedTooSoon() {
        this.fileEndedTooSoon = true;
    }

    public double computeMaxDistance() {
        double result = 0.0;
        for (Vector3D v1 : this.m_vertices) {
            for (Vector3D v2 : this.m_vertices) {
                double d;
                if (v1 == v2 || !((d = v1.distanceTo(v2)) > result)) continue;
                result = d;
            }
        }
        return result;
    }
}

