/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.AdditionFunction;
import net.sourceforge.jocular.math.equations.functions.Function;
import net.sourceforge.jocular.math.equations.functions.NegationFunction;

public class SubtractionFunction
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        if (uvs.length != 2) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        if (uvs[0].isError()) {
            return uvs[0];
        }
        if (uvs[1].isError()) {
            return uvs[1];
        }
        UnitedValue uv1 = uvs[0];
        UnitedValue uv2 = uvs[1];
        uv2 = new NegationFunction().perform(uv2);
        if (!uv1.getUnit().isMatchOrUnitless(uv2.getUnit())) {
            return UnitedValue.makeError(EquationParser.CalcState.MISMATCHED_UNITS);
        }
        return new AdditionFunction().perform(uv1, uv2);
    }
}

