/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.Unit;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.Function;

public class SineFunction
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        if (uvs.length != 1) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        UnitedValue uv = uvs[0];
        if (uv.isError()) {
            return uv;
        }
        Unit u = uv.getUnit();
        if (!u.isMatchOrUnitless(BaseUnit.RADIAN)) {
            return UnitedValue.makeError(EquationParser.CalcState.MISMATCHED_UNITS);
        }
        u = BaseUnit.UNITLESS;
        double v = Math.sin(uv.getBaseUnitValue());
        return UnitedValue.makeFunctionResult(u, v);
    }
}

