/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.AbstractUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.Unit;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.Function;

public class MultiplicationFunction
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        if (uvs.length != 2) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        if (uvs[0].isError()) {
            return uvs[0];
        }
        if (uvs[1].isError()) {
            return uvs[1];
        }
        double v = 0.0;
        UnitedValue uv1 = uvs[0];
        UnitedValue uv2 = uvs[1];
        Unit u = AbstractUnit.combineBaseUnits(uv1.getUnit(), uv2.getUnit());
        v = uv1.getValue() * uv2.getValue();
        return UnitedValue.makeFunctionResult(u, v);
    }
}

