/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import java.util.HashMap;
import net.sourceforge.jocular.math.equations.functions.AdditionFunction;
import net.sourceforge.jocular.math.equations.functions.ArcCosineFunction;
import net.sourceforge.jocular.math.equations.functions.ArcSineFunction;
import net.sourceforge.jocular.math.equations.functions.ArcTangent2Function;
import net.sourceforge.jocular.math.equations.functions.ArcTangentFunction;
import net.sourceforge.jocular.math.equations.functions.CFunction;
import net.sourceforge.jocular.math.equations.functions.CosineFunction;
import net.sourceforge.jocular.math.equations.functions.DivisionFunction;
import net.sourceforge.jocular.math.equations.functions.EFunction;
import net.sourceforge.jocular.math.equations.functions.Function;
import net.sourceforge.jocular.math.equations.functions.InvertFunction;
import net.sourceforge.jocular.math.equations.functions.MultiplicationFunction;
import net.sourceforge.jocular.math.equations.functions.NaturalLogFunction;
import net.sourceforge.jocular.math.equations.functions.NegationFunction;
import net.sourceforge.jocular.math.equations.functions.PiFunction;
import net.sourceforge.jocular.math.equations.functions.PlanckConstantFunction;
import net.sourceforge.jocular.math.equations.functions.SineFunction;
import net.sourceforge.jocular.math.equations.functions.SquareRootFunction;
import net.sourceforge.jocular.math.equations.functions.SubtractionFunction;
import net.sourceforge.jocular.math.equations.functions.TangentFunction;

public class FunctionList {
    private HashMap<String, Function> m_functionMap = new HashMap();
    private static final FunctionList FUNCION_LIST = new FunctionList();

    public static FunctionList getFunctionList() {
        return FUNCION_LIST;
    }

    private FunctionList() {
        this.add("addition", new AdditionFunction());
        this.add("negation", new NegationFunction());
        this.add("-", new NegationFunction());
        this.add("subtraction", new SubtractionFunction());
        this.add("multiplication", new MultiplicationFunction());
        this.add("sqrt", new SquareRootFunction());
        this.add("sin", new SineFunction());
        this.add("cos", new CosineFunction());
        this.add("tan", new TangentFunction());
        this.add("invert", new InvertFunction());
        this.add("division", new DivisionFunction());
        this.add("ln", new NaturalLogFunction());
        this.add("k", new PlanckConstantFunction());
        this.add("c", new CFunction());
        this.add("e", new EFunction());
        this.add("pi", new PiFunction());
        this.add("asin", new ArcSineFunction());
        this.add("acos", new ArcCosineFunction());
        this.add("atan", new ArcTangentFunction());
        this.add("atan2", new ArcTangent2Function());
    }

    protected void add(String name, Function f) {
        this.m_functionMap.put(name, f);
    }

    public Function get(String name) {
        String n = name.trim().toLowerCase();
        Function result = this.m_functionMap.get(n);
        if (result == null) {
            throw new RuntimeException("Function \"" + n + "\" cannot be found in list.");
        }
        return result;
    }
}

