/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.AbstractUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.Unit;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.Function;

public class ExponentFunction
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        if (uvs.length != 2) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        double v = 0.0;
        UnitedValue uv1 = uvs[0];
        UnitedValue uv2 = uvs[1];
        if (!uv2.getUnit().isUnitless()) {
            return UnitedValue.makeError(EquationParser.CalcState.MISMATCHED_UNITS);
        }
        Unit u = AbstractUnit.scaleBaseUnitPowers(uv1.getUnit(), uv2.getBaseUnitValue());
        v = Math.pow(uv1.getBaseUnitValue(), uv2.getBaseUnitValue());
        return UnitedValue.makeFunctionResult(u, v);
    }
}

