/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.Function;

public class ArcTangent2Function
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        if (uvs.length != 2) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        UnitedValue uv1 = uvs[0];
        UnitedValue uv2 = uvs[1];
        if (uv1.isError()) {
            return uv1;
        }
        if (uv2.isError()) {
            return uv2;
        }
        if (!uv1.getUnit().isMatchOrUnitless(uv2.getUnit())) {
            return UnitedValue.makeError(EquationParser.CalcState.MISMATCHED_UNITS);
        }
        BaseUnit u = BaseUnit.RADIAN;
        double v = Math.atan2(uv1.getBaseUnitValue(), uv2.getBaseUnitValue());
        return UnitedValue.makeFunctionResult(u, v);
    }
}

