/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations.functions;

import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.Unit;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.Function;

public class AdditionFunction
implements Function {
    @Override
    public UnitedValue perform(UnitedValue ... uvs) {
        Unit u2;
        if (uvs.length != 2) {
            return UnitedValue.makeError(EquationParser.CalcState.WRONG_NUMBER_ARGUMENTS);
        }
        if (uvs[0].isError()) {
            return uvs[0];
        }
        if (uvs[1].isError()) {
            return uvs[1];
        }
        double v = 0.0;
        UnitedValue uv1 = uvs[0];
        UnitedValue uv2 = uvs[1];
        Unit u1 = uv1.getUnit();
        if (!u1.isMatchOrUnitless(u2 = uv2.getUnit())) {
            return UnitedValue.makeError(EquationParser.CalcState.MISMATCHED_UNITS);
        }
        Unit u = u1.isUnitless() ? u2 : u1;
        v = u.convertFromBaseUnitValue(uv1.getBaseUnitValue() + uv2.getBaseUnitValue());
        return UnitedValue.makeFunctionResult(u, v);
    }
}

