/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations;

import java.text.DecimalFormat;
import net.sourceforge.jocular.math.equations.AbstractUnit;
import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.EquationParser;
import net.sourceforge.jocular.math.equations.Unit;

public class UnitedValue {
    public static final UnitedValue NAN = new UnitedValue(BaseUnit.UNITLESS, 0.0);
    public static final UnitedValue ZERO = new UnitedValue(BaseUnit.UNITLESS, 0.0);
    public static final UnitedValue DEFERRED = new UnitedValue(BaseUnit.UNITLESS, 0.0, EquationParser.CalcState.COMPUTATION_DEFERRED);
    private Unit m_unit;
    private double m_value;
    private EquationParser.CalcState m_state;

    private UnitedValue(Unit unit, double value) {
        this.m_unit = unit;
        this.m_value = value;
        this.m_state = EquationParser.CalcState.SIMPLE_VALUE;
    }

    private UnitedValue(Unit unit, double value, EquationParser.CalcState state) {
        this.m_unit = unit;
        this.m_value = value;
        this.m_state = state;
    }

    public static UnitedValue makeError(EquationParser.CalcState sc) {
        return new UnitedValue(BaseUnit.UNITLESS, 0.0, sc);
    }

    public static UnitedValue makeFunctionResult(Unit unit, double value) {
        return new UnitedValue(unit, value, EquationParser.CalcState.COMPUTED_VALUE);
    }

    public static UnitedValue makeSimpleValue(Unit unit, double value) {
        return new UnitedValue(unit, value, EquationParser.CalcState.SIMPLE_VALUE);
    }

    public double getValue() {
        return this.m_value;
    }

    public boolean isError() {
        return this.m_state != EquationParser.CalcState.COMPUTED_VALUE && this.m_state != EquationParser.CalcState.SIMPLE_VALUE && this.m_state != EquationParser.CalcState.COMPUTATION_DEFERRED;
    }

    public boolean isDeferred() {
        return this.m_state == EquationParser.CalcState.COMPUTATION_DEFERRED;
    }

    public String getErrorText() {
        return this.m_state.toString();
    }

    public boolean isSimpleValue() {
        return this.m_state == EquationParser.CalcState.SIMPLE_VALUE;
    }

    public Unit getUnit() {
        return this.m_unit;
    }

    public double getBaseUnitValue() {
        return this.m_unit.convertToBaseUnitValue(this.m_value);
    }

    public UnitedValue convertToBaseUnits() {
        BaseUnit[] us = this.m_unit.getBaseUnits();
        double[] ps = this.m_unit.getBaseUnitPowers();
        double v = this.m_unit.convertToBaseUnitValue(this.m_value);
        Unit u = AbstractUnit.makeUnit(us, ps);
        return new UnitedValue(u, v);
    }

    public String toString() {
        Object s = "";
        if (this.m_state != EquationParser.CalcState.COMPUTED_VALUE || this.m_state != EquationParser.CalcState.SIMPLE_VALUE) {
            s = (String)s + " " + this.m_state.name();
        }
        return this.m_value + " " + this.m_unit + (String)s;
    }

    public String getBaseUnitString() {
        String result;
        if (this.getUnit().isUnitless()) {
            DecimalFormat df = new DecimalFormat("##0.00#E0");
            result = df.format(this.getBaseUnitValue());
        } else {
            result = this.getEngineeringUnitString();
        }
        return result;
    }

    public String getEngineeringUnitString() {
        DecimalFormat df = new DecimalFormat("##0.00#E0");
        String rs = df.format(this.getBaseUnitValue());
        Object s = rs;
        String exp = ((String)s).substring(((String)s).indexOf("E"));
        s = ((String)s).substring(0, ((String)s).indexOf("E")) + " ";
        switch (exp) {
            case "E-15": {
                s = (String)s + "f";
                break;
            }
            case "E-12": {
                s = (String)s + "p";
                break;
            }
            case "E-9": {
                s = (String)s + "n";
                break;
            }
            case "E-6": {
                s = (String)s + "\u00c2\u00b5";
                break;
            }
            case "E-3": {
                s = (String)s + "m";
                break;
            }
            case "E0": {
                break;
            }
            case "E3": {
                s = (String)s + "k";
                break;
            }
            case "E6": {
                s = (String)s + "M";
                break;
            }
            case "E9": {
                s = (String)s + "G";
                break;
            }
            case "E12": {
                s = (String)s + "T";
                break;
            }
            case "E15": {
                s = (String)s + "P";
                break;
            }
            default: {
                s = (String)s + exp;
            }
        }
        for (int i = 0; i < this.getUnit().getBaseUnitCount(); ++i) {
            double p = this.getUnit().getBaseUnitPower(i);
            s = (String)s + this.getUnit().getBaseUnit(i).getPreferredShortName();
            if (p == 1.0) continue;
            s = (String)s + "^" + p;
        }
        return s;
    }
}

