/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations;

import java.util.Collection;
import java.util.HashMap;
import net.sourceforge.jocular.math.equations.AbstractUnit;
import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.Unit;

public class UnitList {
    HashMap<String, Unit> m_unitMap = new HashMap();
    private static final UnitList UNIT_LIST = new UnitList();

    private UnitList() {
        this.m_unitMap.put("m", BaseUnit.METRE);
        this.m_unitMap.put("mm", new AbstractUnit("millimetre", "mm", BaseUnit.METRE, 0.001){});
        this.m_unitMap.put("um", new AbstractUnit("micrometre", "um", BaseUnit.METRE, 1.0E-6){});
        this.m_unitMap.put("nm", new AbstractUnit("nanometre", "nm", BaseUnit.METRE, 1.0E-9){});
        this.m_unitMap.put("pm", new AbstractUnit("picometre", "pm", BaseUnit.METRE, 1.0E-12){});
        this.m_unitMap.put("fm", new AbstractUnit("femtometre", "fm", BaseUnit.METRE, 1.0E-15){});
        this.m_unitMap.put("cm", new AbstractUnit("centimetre", "cm", BaseUnit.METRE, 0.01){});
        this.m_unitMap.put("km", new AbstractUnit("kilometre", "km", BaseUnit.METRE, 1000.0){});
        this.m_unitMap.put("dm", new AbstractUnit("decimetre", "dm", BaseUnit.METRE, 0.1){});
        this.m_unitMap.put("ft", new AbstractUnit("foot", "ft", BaseUnit.METRE, 0.30479999999999996){});
        this.m_unitMap.put("'", this.m_unitMap.get("ft"));
        this.m_unitMap.put("in", new AbstractUnit("inch", "in", BaseUnit.METRE, 0.0254){});
        this.m_unitMap.put("mil", new AbstractUnit("thousandths of an inch", "mil", BaseUnit.METRE, 2.54E-5){});
        this.m_unitMap.put("thou", this.m_unitMap.get("mil"));
        this.m_unitMap.put("\"", this.m_unitMap.get("in"));
        this.m_unitMap.put("yd", new AbstractUnit("yards", "yd", BaseUnit.METRE, 0.9143999999999999){});
        this.m_unitMap.put("rad", BaseUnit.RADIAN);
        this.m_unitMap.put("mrad", new AbstractUnit("milliradian", "mrad", BaseUnit.RADIAN, 0.001){});
        this.m_unitMap.put("urad", new AbstractUnit("microradian", "urad", BaseUnit.RADIAN, 1.0E-6){});
        this.m_unitMap.put("deg", new AbstractUnit("degree", "\u00c2\u00b0", BaseUnit.RADIAN, Math.PI / 180){});
        this.m_unitMap.put("mdeg", new AbstractUnit("millidegree", "m\u00c2\u00b0", BaseUnit.RADIAN, 1.7453292519943296E-5){});
        this.m_unitMap.put("\u00c2\u00b0", this.m_unitMap.get("deg"));
        this.m_unitMap.put("grad", new AbstractUnit("gradian", "grad", BaseUnit.RADIAN, 0.06283185307179587){});
        this.m_unitMap.put("kg", BaseUnit.KILOGRAM);
        this.m_unitMap.put("lb", new AbstractUnit("pound", "lb", BaseUnit.KILOGRAM, 0.4535970244035199){});
        this.m_unitMap.put("s", BaseUnit.SECOND);
        this.m_unitMap.put("ms", new AbstractUnit("millisecond", "ms", BaseUnit.SECOND, 0.001){});
        this.m_unitMap.put("us", new AbstractUnit("microsecond", "us", BaseUnit.SECOND, 1.0E-6){});
        this.m_unitMap.put("ns", new AbstractUnit("nanosecond", "ns", BaseUnit.SECOND, 1.0E-9){});
        this.m_unitMap.put("ps", new AbstractUnit("picosecond", "ps", BaseUnit.SECOND, 1.0E-12){});
        this.m_unitMap.put("fs", new AbstractUnit("femtosecond", "fs", BaseUnit.SECOND, 1.0E-15){});
        this.m_unitMap.put("K", BaseUnit.KELVIN);
    }

    public Unit get(String name) {
        Unit result = this.m_unitMap.get(name);
        if (result == null) {
            throw new RuntimeException("specified unit \"" + name + "\" cannot be found.");
        }
        return result;
    }

    public Collection<String> getUnitNames() {
        return this.m_unitMap.keySet();
    }

    public static UnitList getUnitList() {
        return UNIT_LIST;
    }
}

