/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.ObjectNotFoundException;
import net.sourceforge.jocular.math.equations.PropertyNotFoundException;
import net.sourceforge.jocular.math.equations.Unit;
import net.sourceforge.jocular.math.equations.UnitList;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.math.equations.functions.AdditionFunction;
import net.sourceforge.jocular.math.equations.functions.DivisionFunction;
import net.sourceforge.jocular.math.equations.functions.ExponentFunction;
import net.sourceforge.jocular.math.equations.functions.Function;
import net.sourceforge.jocular.math.equations.functions.FunctionList;
import net.sourceforge.jocular.math.equations.functions.IncorrectUnitsException;
import net.sourceforge.jocular.math.equations.functions.MultiplicationFunction;
import net.sourceforge.jocular.math.equations.functions.NegationFunction;
import net.sourceforge.jocular.math.equations.functions.WrongNumberOfArgumentsException;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyOwner;

public class EquationParser {
    private FunctionList m_functions = FunctionList.getFunctionList();
    private UnitList m_units = UnitList.getUnitList();

    public List<UnitedValue> parse(String s, PropertyOwner po, PropertyManager pm, PropertyKey key) {
        String s2 = s;
        List<UnitedValue> cuv = this.parseEquation(s2, po, pm, key);
        return cuv;
    }

    private List<UnitedValue> parseEquation(String s, PropertyOwner po, PropertyManager pm, PropertyKey key) throws ObjectNotFoundException, PropertyNotFoundException, WrongNumberOfArgumentsException, IncorrectUnitsException, NumberFormatException {
        ArrayList<UnitedValue> result = new ArrayList<UnitedValue>();
        List<String> ss = this.split(s);
        if (ss.size() == 0) {
            result.add(UnitedValue.ZERO);
        } else {
            for (String s2 : ss) {
                UnitedValue uv = this.parseSingleEquation(s2, po, pm, key);
                if (uv == null) continue;
                result.add(uv);
            }
        }
        return result;
    }

    public static String getLeftHandSide(String s) {
        int i = s.indexOf(61);
        String result = "";
        if (i >= 0) {
            result = s.substring(0, i).trim();
        }
        return result;
    }

    public static String getRightHandSide(String s) {
        int i = s.indexOf(61);
        String result = s;
        if (i >= 0) {
            result = s.substring(i + 1).trim();
        }
        return result;
    }

    private UnitedValue parseSingleEquation(String s, PropertyOwner po, PropertyManager pm, PropertyKey key) throws ObjectNotFoundException, PropertyNotFoundException, WrongNumberOfArgumentsException, IncorrectUnitsException, NumberFormatException {
        String ts = s.trim();
        UnitedValue uv = null;
        String lhs = EquationParser.getLeftHandSide(ts);
        String rhs = EquationParser.getRightHandSide(ts);
        uv = this.parseRightHandSide(rhs, po, pm, key);
        return uv;
    }

    private UnitedValue parseRightHandSide(String s, PropertyOwner po, PropertyManager pm, PropertyKey key) throws ObjectNotFoundException, PropertyNotFoundException, WrongNumberOfArgumentsException, IncorrectUnitsException, NumberFormatException {
        char c;
        int i;
        UnitedValue uv = null;
        UnitedValue uv1 = null;
        UnitedValue uv2 = null;
        String ts = s.replace("E-", "F");
        ts = ts.replace("e-", "F");
        ts = ts.replace("E+", "E");
        ts = ts.replace("e+", "E");
        if (uv == null) {
            boolean startsWithNeg = false;
            boolean startsWithPos = false;
            for (i = 0; i < ts.length(); ++i) {
                c = ts.charAt(i);
                switch (c) {
                    case '(': {
                        i = EquationParser.findMatchingBracket(ts, i);
                        break;
                    }
                    case '+': 
                    case '-': {
                        if (i == 0) {
                            if (c == '-') {
                                startsWithNeg = true;
                                break;
                            }
                            startsWithPos = true;
                            break;
                        }
                        if (i >= ts.length() - 1) break;
                        uv1 = this.parseEquation(ts.substring(0, i), po, pm, key).get(0);
                        uv2 = this.parseEquation(ts.substring(i), po, pm, key).get(0);
                        uv = new AdditionFunction().perform(uv1, uv2);
                        break;
                    }
                    default: {
                        if (i != 0 && (!startsWithNeg || i != 1) && (!startsWithPos || i != 1)) break;
                        i = this.scanThroughNumber(ts, i);
                    }
                }
                if (i >= ts.length() - 1) {
                    if (startsWithNeg) {
                        uv1 = this.parseEquation(ts.substring(1), po, pm, key).get(0);
                        uv = new NegationFunction().perform(uv1);
                    } else if (startsWithPos) {
                        uv = this.parseEquation(ts.substring(1), po, pm, key).get(0);
                    }
                }
                if (uv != null) break;
            }
        }
        if (uv == null) {
            for (int i2 = 0; i2 < ts.length(); ++i2) {
                char c2 = ts.charAt(i2);
                switch (c2) {
                    case '(': {
                        i2 = EquationParser.findMatchingBracket(ts, i2);
                        break;
                    }
                    case '*': {
                        uv1 = this.parseEquation(ts.substring(0, i2), po, pm, key).get(0);
                        uv2 = this.parseEquation(ts.substring(i2 + 1), po, pm, key).get(0);
                        uv = new MultiplicationFunction().perform(uv1, uv2);
                        break;
                    }
                    default: {
                        if (i2 != 0) break;
                        i2 = this.scanThroughNumber(ts, i2);
                    }
                }
                if (uv != null) break;
            }
        }
        if (uv == null) {
            for (i = 0; i < ts.length(); ++i) {
                c = ts.charAt(i);
                switch (c) {
                    case '(': {
                        i = EquationParser.findMatchingBracket(ts, i);
                        break;
                    }
                    case '/': {
                        uv1 = this.parseEquation(ts.substring(0, i), po, pm, key).get(0);
                        uv2 = this.parseEquation(ts.substring(i + 1), po, pm, key).get(0);
                        uv = new DivisionFunction().perform(uv1, uv2);
                        break;
                    }
                    default: {
                        if (i != 0) break;
                        i = this.scanThroughNumber(ts, i);
                    }
                }
                if (uv != null) break;
            }
        }
        if (uv == null) {
            for (i = 0; i < ts.length(); ++i) {
                c = ts.charAt(i);
                switch (c) {
                    case '(': {
                        i = EquationParser.findMatchingBracket(ts, i);
                        break;
                    }
                    case '^': {
                        uv1 = this.parseEquation(ts.substring(0, i), po, pm, key).get(0);
                        uv2 = this.parseEquation(ts.substring(i + 1), po, pm, key).get(0);
                        uv = new ExponentFunction().perform(uv1, uv2);
                        break;
                    }
                    case '#': {
                        String s1 = ts.substring(0, i);
                        String s2 = ts.substring(i + 1);
                        uv = pm.lookupObjectPositionerProperty(s1, s2, po, key);
                        break;
                    }
                    case '>': {
                        String s1 = ts.substring(0, i);
                        String s2 = ts.substring(i + 1);
                        uv = pm.lookupObjectProperty(s1, s2, po, key);
                        break;
                    }
                    default: {
                        if (i != 0) break;
                        i = this.scanThroughNumber(ts, i);
                    }
                }
                if (uv != null) break;
            }
        }
        if (uv == null) {
            block25: for (i = 0; i < ts.length(); ++i) {
                c = ts.charAt(i);
                switch (c) {
                    case '(': {
                        int j = EquationParser.findMatchingBracket(ts, i);
                        if (j == ts.length() - 1) {
                            String s1 = ts.substring(0, i);
                            String s2 = ts.substring(i + 1, j);
                            uv = s1.equals("") ? this.parseEquation(s2, po, pm, key).get(0) : this.parseFunction(s1, s2, po, pm, key);
                        }
                        i = j;
                        continue block25;
                    }
                    default: {
                        if (i != 0) continue block25;
                        i = this.scanThroughNumber(ts, i);
                    }
                }
            }
        }
        if (uv == null) {
            if (ts.contains("$")) {
                uv = pm.lookupGlobalVariable(po, key, ts.replace("$", "").trim());
            } else {
                ts = ts.replace("F", "E-");
                uv = this.parseSimpleValue(ts);
            }
        }
        return uv;
    }

    private int scanThroughNumber(String ts, int loc) {
        int i = loc;
        int result = -1;
        NumberState state = NumberState.NOTHING;
        while (result == -1) {
            char c = ts.charAt(i);
            switch (state) {
                case NOTHING: {
                    if ("01234567890".indexOf(c) == -1) {
                        result = i;
                        break;
                    }
                    state = NumberState.MANTISSA;
                    break;
                }
                case MANTISSA: {
                    if ("0123456789.e".indexOf(c) == -1) {
                        result = i - 1;
                        break;
                    }
                    if (c != 'e') break;
                    state = NumberState.EXPONENT;
                    break;
                }
                case EXPONENT: {
                    if ("+-0123456789".indexOf(c) == -1) {
                        result = i - 1;
                        break;
                    }
                    state = NumberState.EXPONENT_NUM;
                    break;
                }
                case EXPONENT_NUM: {
                    if ("0123456789".indexOf(c) != -1) break;
                    result = i - 1;
                }
            }
            if (result != -1 || ++i < ts.length()) continue;
            result = ts.length() - 1;
        }
        return result;
    }

    protected static int findMatchingBracket(String s, int i) {
        int openingNum = 0;
        int result = -1;
        boolean found = false;
        for (int j = i + 1; j < s.length(); ++j) {
            switch (s.charAt(j)) {
                case '(': {
                    ++openingNum;
                    break;
                }
                case ')': {
                    if (openingNum > 0) {
                        --openingNum;
                        break;
                    }
                    result = j;
                    found = true;
                }
            }
            if (found) break;
        }
        if (!found) {
            throw new RuntimeException("Matching bracket not found");
        }
        return result;
    }

    protected UnitedValue parseFunction(String f, String p, PropertyOwner po, PropertyManager pm, PropertyKey key) {
        ArrayList<UnitedValue> uval = new ArrayList<UnitedValue>();
        int lastValueStart = 0;
        block4: for (int i = 0; i < p.length(); ++i) {
            switch (p.charAt(i)) {
                case '(': {
                    i = EquationParser.findMatchingBracket(p, i);
                    continue block4;
                }
                case ',': 
                case ';': {
                    uval.addAll(this.parseEquation(p.substring(lastValueStart, i), po, pm, key));
                    lastValueStart = i + 1;
                }
            }
        }
        if (lastValueStart != p.length()) {
            uval.addAll(this.parseEquation(p.substring(lastValueStart), po, pm, key));
        }
        UnitedValue[] uvs = uval.toArray(new UnitedValue[uval.size()]);
        Function func = this.m_functions.get(f);
        return func.perform(uvs);
    }

    protected int scanForFirstOfCharsOrEnd(String s, String chars, int i) {
        int result = s.length();
        boolean inNumber = false;
        boolean inExponent = false;
        for (int j = i; j < s.length(); ++j) {
            char c = s.charAt(j);
            if (inExponent) {
                if ("-+".indexOf(c) == -1) {
                    inExponent = false;
                }
            } else if (inNumber) {
                if ("0123456789.".indexOf(c) == -1) {
                    if ("eE".indexOf(c) == -1) {
                        inNumber = false;
                    } else {
                        inExponent = true;
                    }
                }
            } else if ("0123456789".indexOf(c) != -1) {
                inNumber = true;
            }
            if (c == '(') {
                inNumber = false;
                j = EquationParser.findMatchingBracket(s, j);
                continue;
            }
            if (chars.indexOf(c) == -1 || inNumber) continue;
            result = j;
            break;
        }
        return result;
    }

    protected UnitedValue parseSimpleValue(String s) throws NumberFormatException {
        String unitName = null;
        int index = -1;
        int unitCharLength = 0;
        double v = 0.0;
        Unit u = BaseUnit.UNITLESS;
        for (String k : this.m_units.getUnitNames()) {
            int i = s.indexOf(k);
            if (i == -1 || k.length() <= unitCharLength) continue;
            unitName = k;
            index = i;
            unitCharLength = k.length();
        }
        if (unitName != null) {
            try {
                v = Double.parseDouble(s.substring(0, index));
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("NumberFormatException while parsing: \"" + s.substring(0, index) + "\"");
            }
            u = this.m_units.get(unitName);
        } else if (s.length() == 0) {
            v = 0.0;
        } else {
            try {
                v = Double.parseDouble(s);
            }
            catch (NumberFormatException e) {
                return UnitedValue.makeError(CalcState.NUMBER_FORMAT_ERROR);
            }
        }
        return UnitedValue.makeSimpleValue(u, v);
    }

    protected String completeBrackets(String s) {
        Object ts = s.trim();
        int openBracketCount = 0;
        for (int i = 0; i < ((String)ts).length(); ++i) {
            char c = ((String)ts).charAt(i);
            if (c == '(') {
                ++openBracketCount;
                continue;
            }
            if (c != ')') continue;
            --openBracketCount;
        }
        if (openBracketCount > 0) {
            for (int j = openBracketCount; j > 0; --j) {
                ts = (String)ts + ")";
            }
        }
        return ts;
    }

    private void test(String s, double shouldBeValue, PropertyOwner po, PropertyManager pm, PropertyKey key) {
        UnitedValue uv = null;
        try {
            String s2 = this.completeBrackets(s);
            uv = this.parse(s2, po, pm, key).get(0);
        }
        catch (RuntimeException e) {
            System.out.println("EquationParser.test: Exception: " + e);
        }
        if (uv != null) {
            String result = "Testing: " + s + " = " + uv + " which is " + uv.convertToBaseUnits();
            result = uv.getBaseUnitValue() == shouldBeValue ? result + " CORRECT" : result + " WRONG!!!!!!!!!!!!!!";
            System.out.println(result);
        }
    }

    public static String[] splitString(String s) {
        ArrayList<String> result = new ArrayList<String>();
        String ts = s.trim();
        int j = 0;
        block4: for (int i = 0; i < ts.length(); ++i) {
            switch (ts.charAt(i)) {
                case '(': {
                    i = EquationParser.findMatchingBracket(ts, i);
                    continue block4;
                }
                case ',': 
                case ';': {
                    result.add(ts.substring(j, i));
                    j = i + 1;
                    continue block4;
                }
            }
        }
        result.add(ts.substring(j));
        return result.toArray(new String[result.size()]);
    }

    public static void main(String[] args) {
        EquationParser ep = new EquationParser();
        PropertyManager pm = PropertyManager.getInstance();
        SphericalLens po = new SphericalLens();
        OpticsProject proj = new OpticsProject();
        pm.addProject(proj);
        proj.getOpticsObject().add(po, 0);
        po.setProperty(PropertyKey.NAME, "lens1");
        PropertyKey key = PropertyKey.LENGTH;
        po.setProperty(PropertyKey.THICKNESS, "10mm");
        ep.test("4*lens1>thick", 0.04, po, pm, key);
        ep.test("4*lens1#ortho", Double.NaN, po, pm, key);
        ep.test("blah = 100mm", 0.1, po, pm, key);
        ep.test("-8.3E-01", -0.83, po, pm, key);
        ep.test(" (-(4+6)/2 + 4)+1/2", -0.5, po, pm, key);
        ep.test(" - 5 + 8 + 7", 10.0, po, pm, key);
        ep.test("-(4+6) - 5 + 8 + 7", 0.0, po, pm, key);
        ep.test("-pi() + 2", -1.1415926535897931, po, pm, key);
        ep.test("-6 + 2", -4.0, po, pm, key);
        ep.test("-2.646768761769558E-4", -2.646768761769558E-4, po, pm, key);
        ep.test("tan(30deg)", Math.tan(Math.toRadians(30.0)), po, pm, key);
    }

    public List<String> split(String ts) {
        ArrayList<String> result = new ArrayList<String>();
        boolean found = false;
        block4: for (int i = 0; i < ts.length(); ++i) {
            switch (ts.charAt(i)) {
                case '(': {
                    i = EquationParser.findMatchingBracket(ts, i);
                    continue block4;
                }
                case ',': 
                case ';': {
                    result.add(ts.substring(0, i));
                    result.addAll(this.split(ts.substring(i + 1)));
                    found = true;
                    continue block4;
                }
            }
        }
        if (!found) {
            result.add(ts);
        }
        return result;
    }

    public EquationProperty[] split(EquationArrayProperty eap, PropertyOwner po, PropertyKey key, PropertyManager pm, boolean onlyLhs) {
        List<String> ss = this.split(eap.getDefiningString());
        int n = ss.size();
        EquationProperty[] result = new EquationProperty[n];
        for (int i = 0; i < n; ++i) {
            String s = ss.get(i);
            if (onlyLhs) {
                s = EquationParser.getLeftHandSide(s);
            }
            result[i] = new EquationProperty(s, po, key);
        }
        return result;
    }

    private static enum NumberState {
        NOTHING,
        MANTISSA,
        EXPONENT,
        EXPONENT_NUM;

    }

    public static enum CalcState {
        UNKNOWN_STATE,
        CIRCULAR_REFERENCE,
        PROPERTY_NOT_NUMBER,
        SIMPLE_VALUE,
        COMPUTED_VALUE,
        OBJECT_NOT_FOUND,
        PROPERTY_NOT_FOUND,
        WRONG_NUMBER_ARGUMENTS,
        MISMATCHED_UNITS,
        UNDERSPECIFIED_OBJECT,
        NUMBER_FORMAT_ERROR,
        COMPUTATION_DEFERRED,
        VARIABLE_NOT_FOUND;

    }
}

