/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations;

import net.sourceforge.jocular.math.equations.AbstractUnit;
import net.sourceforge.jocular.math.equations.Unit;

public class BaseUnit
extends AbstractUnit
implements Unit {
    public static final BaseUnit UNITLESS = new BaseUnit("Unitless", "?", Unit.UnitType.NONE);
    public static final BaseUnit METRE = new BaseUnit("Metre", "m", Unit.UnitType.LENGTH);
    public static final BaseUnit KILOGRAM = new BaseUnit("Kilogram", "kg", Unit.UnitType.MASS);
    public static final BaseUnit SECOND = new BaseUnit("Second", "s", Unit.UnitType.TIME);
    public static final BaseUnit RADIAN = new BaseUnit("Radian", "rad", Unit.UnitType.ANGLE);
    public static final BaseUnit KELVIN = new BaseUnit("Kelvin", "K", Unit.UnitType.TEMPERATURE);
    private static final BaseUnit[] m_baseUnits = new BaseUnit[]{UNITLESS, KILOGRAM, METRE, RADIAN, SECOND, KELVIN};
    private Unit.UnitType m_type;

    private BaseUnit(String name, String shortName, Unit.UnitType type) {
        super(name, shortName, null, 1.0);
        this.m_type = type;
    }

    public static BaseUnit[] getAllBaseUnits() {
        return m_baseUnits;
    }

    @Override
    public BaseUnit getBaseUnit(int i) {
        return this;
    }

    @Override
    public double getBaseUnitPower(int i) {
        return 1.0;
    }

    @Override
    public BaseUnit[] getBaseUnits() {
        BaseUnit[] result = new BaseUnit[]{this};
        return result;
    }

    @Override
    public double[] getBaseUnitPowers() {
        double[] result = new double[]{1.0};
        return result;
    }

    @Override
    public int getBaseUnitCount() {
        return 1;
    }

    @Override
    public double convertToBaseUnitValue(double v) {
        return v;
    }

    @Override
    public double convertFromBaseUnitValue(double v) {
        return v;
    }

    @Override
    public Unit.UnitType getType() {
        return this.m_type;
    }

    @Override
    public boolean isUnitless() {
        return this.equals(UNITLESS);
    }
}

