/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math.equations;

import java.util.ArrayList;
import net.sourceforge.jocular.math.equations.BaseUnit;
import net.sourceforge.jocular.math.equations.Unit;

public abstract class AbstractUnit
implements Unit {
    private final String m_name;
    private final String m_shortName;
    private final BaseUnit[] m_baseUnit;
    private final double[] m_power;
    private final double m_factor;

    protected AbstractUnit(String name, String shortName, BaseUnit baseUnit, double factor) {
        this.m_name = name;
        this.m_shortName = shortName;
        this.m_baseUnit = new BaseUnit[1];
        this.m_baseUnit[0] = baseUnit;
        this.m_power = new double[1];
        this.m_power[0] = 1.0;
        this.m_factor = factor;
    }

    protected AbstractUnit(BaseUnit[] baseUnits, double[] powers) {
        this.m_name = "";
        this.m_shortName = "";
        this.m_baseUnit = new BaseUnit[baseUnits.length];
        this.m_power = new double[baseUnits.length];
        for (int i = 0; i < baseUnits.length; ++i) {
            this.m_baseUnit[i] = baseUnits[i];
            this.m_power[i] = powers[i];
        }
        this.m_factor = 1.0;
    }

    public static Unit makeUnit(BaseUnit[] baseUnits, double[] powers) {
        if (baseUnits.length == 1 && powers[0] == 1.0) {
            return baseUnits[0];
        }
        if (baseUnits.length == 0) {
            return BaseUnit.UNITLESS;
        }
        return new AbstractUnit(baseUnits, powers){};
    }

    @Override
    public BaseUnit getBaseUnit(int i) {
        return this.m_baseUnit[i];
    }

    @Override
    public double getBaseUnitPower(int i) {
        return this.m_power[i];
    }

    @Override
    public int getBaseUnitCount() {
        return this.m_baseUnit.length;
    }

    @Override
    public double convertToBaseUnitValue(double v) {
        return v * this.m_factor;
    }

    @Override
    public double convertFromBaseUnitValue(double v) {
        return v / this.m_factor;
    }

    @Override
    public Unit.UnitType getType() {
        if (this.m_baseUnit.length > 1) {
            return Unit.UnitType.MULTIPLE;
        }
        return this.m_baseUnit[0].getType();
    }

    @Override
    public BaseUnit[] getBaseUnits() {
        BaseUnit[] result = new BaseUnit[this.m_baseUnit.length];
        for (int i = 0; i < this.m_baseUnit.length; ++i) {
            result[i] = this.m_baseUnit[i];
        }
        return result;
    }

    @Override
    public double[] getBaseUnitPowers() {
        double[] result = new double[this.m_baseUnit.length];
        for (int i = 0; i < this.m_baseUnit.length; ++i) {
            result[i] = this.m_power[i];
        }
        return result;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    @Override
    public String getPreferredShortName() {
        return this.m_shortName;
    }

    @Override
    public boolean isMatchOrUnitless(Unit u) {
        boolean result = true;
        if (u.isUnitless() || this.isUnitless()) {
            return true;
        }
        if (this.getBaseUnitCount() != u.getBaseUnitCount()) {
            result = false;
        }
        for (int i = 0; i < this.getBaseUnitCount(); ++i) {
            boolean found = false;
            for (int j = 0; j < this.getBaseUnitCount(); ++j) {
                if (!u.getBaseUnit(j).equals(this.getBaseUnit(i)) || u.getBaseUnitPower(j) != this.getBaseUnitPower(i)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result = false;
        }
        return result;
    }

    public String toString() {
        Object result = "";
        if (this.getName().equals("")) {
            for (int i = 0; i < this.getBaseUnitCount(); ++i) {
                result = (String)result + this.getBaseUnit(i).getPreferredShortName();
                double p = this.getBaseUnitPower(i);
                if (p != 1.0) {
                    result = Math.floor(p) == p && !Double.isInfinite(p) ? (String)result + "^" + (int)p : (String)result + "^" + this.getBaseUnitPower(i);
                }
                if (i == this.getBaseUnitCount() - 1) continue;
                result = (String)result + "\u00c2\u00b7";
            }
        } else {
            result = (String)result + this.getName();
        }
        return result;
    }

    public static Unit combineBaseUnits(Unit u1, Unit u2) {
        if (u1.isUnitless()) {
            return u2;
        }
        if (u2.isUnitless()) {
            return u1;
        }
        ArrayList<Double> bups = new ArrayList<Double>();
        ArrayList<BaseUnit> bus = new ArrayList<BaseUnit>();
        for (BaseUnit bu : BaseUnit.getAllBaseUnits()) {
            double p = AbstractUnit.getPowerOfBaseUnit(u1, bu) + AbstractUnit.getPowerOfBaseUnit(u2, bu);
            if (p == 0.0) continue;
            bups.add(p);
            bus.add(bu);
        }
        double[] powers = new double[bups.size()];
        for (int i = 0; i < bups.size(); ++i) {
            powers[i] = (Double)bups.get(i);
        }
        BaseUnit[] baseUnits = bus.toArray(new BaseUnit[bus.size()]);
        return AbstractUnit.makeUnit(baseUnits, powers);
    }

    public static double getPowerOfBaseUnit(Unit u, BaseUnit bu) {
        int j = -1;
        double result = 0.0;
        for (int i = 0; i < u.getBaseUnitCount(); ++i) {
            if (!u.getBaseUnit(i).equals(bu)) continue;
            j = i;
            break;
        }
        if (j != -1) {
            result = u.getBaseUnitPower(j);
        }
        return result;
    }

    public static Unit scaleBaseUnitPowers(Unit u, double s) {
        if (u.isUnitless()) {
            return u;
        }
        BaseUnit[] bus = u.getBaseUnits();
        double[] ps = u.getBaseUnitPowers();
        int i = 0;
        while (i < ps.length) {
            int n = i++;
            ps[n] = ps[n] * s;
        }
        return AbstractUnit.makeUnit(bus, ps);
    }

    @Override
    public boolean isUnitless() {
        return false;
    }
}

