/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.text.DecimalFormat;
import javafx.geometry.Point3D;

public class Vector3D {
    public static final Vector3D INF = new Vector3D(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY){

        @Override
        public double abs() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public double magSquared() {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Vector3D scale(double s) {
            throw new RuntimeException("Vector to scale is INF.");
        }

        @Override
        public Vector3D subtract(Vector3D v) {
            return INF;
        }

        @Override
        public Vector3D scale(Vector3D s) {
            throw new RuntimeException("Vector to scale is INF.");
        }

        @Override
        public double distanceTo(Vector3D v) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Vector3D subtract(double v) {
            return INF;
        }

        @Override
        public Vector3D add(Vector3D p) {
            return INF;
        }

        @Override
        public Vector3D add(double v) {
            return INF;
        }

        @Override
        public double dot(Vector3D p) {
            return Double.POSITIVE_INFINITY;
        }

        @Override
        public Vector3D cross(Vector3D p) {
            return INF;
        }

        @Override
        public Vector3D divide(Vector3D s) {
            throw new RuntimeException("Vector to scale is INF.");
        }

        @Override
        public Vector3D normalize() {
            return INF;
        }

        @Override
        public String toString() {
            return "Vector3D.INF";
        }

        @Override
        public boolean equals(Object o) {
            return o == INF;
        }

        @Override
        public boolean isNormalized() {
            return false;
        }

        @Override
        public Vector3D neg() {
            return INF;
        }

        @Override
        public Vector3D getPerpendicularComponent(Vector3D v) {
            return INF;
        }

        @Override
        public Vector3D getParallelComponent(Vector3D v) {
            return INF;
        }

        @Override
        public double angleBetween(Vector3D v) {
            return Double.NaN;
        }

        @Override
        public Vector3D rotate(Vector3D v, double rad) {
            return INF;
        }

        @Override
        public Vector3D calcRotation(Vector3D v) {
            return INF;
        }

        @Override
        public Vector3D rotate(Vector3D origin, Vector3D rotation) {
            return INF;
        }

        @Override
        public Vector3D rotate(Vector3D rotation) {
            return INF;
        }

        @Override
        public Vector3D concatenateRotation(Vector3D rotation) {
            return INF;
        }
    };
    public static final Vector3D X_AXIS = new Vector3D(1.0, 0.0, 0.0);
    public static final Vector3D Y_AXIS = new Vector3D(0.0, 1.0, 0.0);
    public static final Vector3D Z_AXIS = new Vector3D(0.0, 0.0, 1.0);
    public static final Vector3D ORIGIN = new Vector3D(0.0, 0.0, 0.0);
    public static final Vector3D DIR = Z_AXIS;
    public static final Vector3D TRANS = Y_AXIS;
    public static final Vector3D ORTHO = X_AXIS;
    public final double x;
    public final double y;
    public final double z;

    public Vector3D(double x, double y, double z) {
        if (Double.isNaN(x + y + z)) {
            throw new RuntimeException("Parameters are NaN.");
        }
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof Vector3D) {
            Vector3D v = (Vector3D)o;
            if (this.x == v.x && this.y == v.y && this.z == v.z) {
                result = true;
            }
        }
        return result;
    }

    public Vector3D(double[] d) {
        if (d.length != 3) {
            throw new RuntimeException("Array must have exactly three elements, not " + d.length);
        }
        this.x = d[0];
        this.y = d[1];
        this.z = d[2];
    }

    public Vector3D(Vector3D p) {
        this(p.x, p.y, p.z);
    }

    public static Vector3D random() {
        return new Vector3D(Math.random(), Math.random(), Math.random());
    }

    public double distanceTo(Vector3D v) {
        if (v == null || v == INF) {
            return Double.POSITIVE_INFINITY;
        }
        return this.subtract(v).abs();
    }

    public double angleBetween(Vector3D v) {
        Vector3D nv = v.normalize();
        Vector3D n = this.normalize();
        double c = n.dot(nv);
        double s = n.cross(nv).abs();
        return Math.atan2(s, c);
    }

    public Vector3D subtract(double v) {
        if (Double.isInfinite(v)) {
            return INF;
        }
        Vector3D result = new Vector3D(this.x - v, this.y - v, this.z - v);
        return result;
    }

    public Vector3D subtract(Vector3D v) {
        if (v == null || v == INF) {
            return INF;
        }
        Vector3D result = new Vector3D(this.x - v.x, this.y - v.y, this.z - v.z);
        return result;
    }

    public Vector3D add(Vector3D p) {
        if (p == null || p == INF) {
            return INF;
        }
        Vector3D result = new Vector3D(p.x + this.x, p.y + this.y, p.z + this.z);
        return result;
    }

    public Vector3D add(double v) {
        if (Double.isInfinite(v)) {
            return INF;
        }
        Vector3D result = new Vector3D(this.x + v, this.y + v, this.z + v);
        return result;
    }

    public double dot(Vector3D p) {
        double result = 0.0;
        result = p == null ? 0.0 : (p == INF ? Double.POSITIVE_INFINITY : p.x * this.x + p.y * this.y + p.z * this.z);
        return result;
    }

    public Vector3D cross(Vector3D p) {
        if (p == null) {
            return null;
        }
        if (p == INF) {
            return INF;
        }
        return new Vector3D(this.y * p.z - this.z * p.y, this.z * p.x - this.x * p.z, this.x * p.y - this.y * p.x);
    }

    public double abs() {
        double result = Math.pow(this.x, 2.0);
        result += Math.pow(this.y, 2.0);
        return Math.sqrt(result += Math.pow(this.z, 2.0));
    }

    public double magSquared() {
        double result = Math.pow(this.x, 2.0);
        result += Math.pow(this.y, 2.0);
        return result += Math.pow(this.z, 2.0);
    }

    public Vector3D scale(double s) {
        if (Double.isInfinite(s)) {
            throw new RuntimeException("Scale factor is infinite.");
        }
        if (Double.isNaN(s)) {
            throw new RuntimeException("Scale factor is NaN.");
        }
        return new Vector3D(this.x * s, this.y * s, this.z * s);
    }

    public Vector3D scale(Vector3D s) {
        return new Vector3D(this.x * s.x, this.y * s.y, this.z * s.z);
    }

    public Vector3D divide(Vector3D s) {
        if (s.x == 0.0 || s.y == 0.0 || s.z == 0.0) {
            throw new RuntimeException("Element of dividing Vector is zero: " + s);
        }
        return new Vector3D(this.x / s.x, this.y / s.y, this.z / s.z);
    }

    public Vector3D normalize() {
        double m = this.abs();
        if (m == 0.0) {
            return ORIGIN;
        }
        return new Vector3D(this.x / m, this.y / m, this.z / m);
    }

    public String toString() {
        DecimalFormat nf = new DecimalFormat("0.00E0");
        return "Vector3D x,y,z,abs = " + nf.format(this.x) + ", " + nf.format(this.y) + ", " + nf.format(this.z) + ", " + nf.format(this.abs());
    }

    public boolean isNormalized() {
        return Math.abs(this.abs() - 1.0) < 1.0E-12;
    }

    public Vector3D neg() {
        return new Vector3D(-this.x, -this.y, -this.z);
    }

    public Vector3D getParallelComponent(Vector3D v) {
        if (v == null || v == INF) {
            return INF;
        }
        Vector3D vNorm = v.normalize();
        double dot = this.dot(vNorm);
        Vector3D result = vNorm.scale(dot);
        return result;
    }

    public Vector3D getPerpendicularComponent(Vector3D v) {
        if (v == null || v == INF) {
            return INF;
        }
        Vector3D result = this.subtract(this.getParallelComponent(v));
        return result;
    }

    public static Vector3D getTrans(Vector3D dir, Vector3D ortho) {
        return dir.cross(ortho);
    }

    public static Vector3D getOrtho(Vector3D dir, Vector3D trans) {
        return trans.cross(dir);
    }

    public static Vector3D getDir(Vector3D trans, Vector3D ortho) {
        return trans.cross(ortho);
    }

    public Vector3D rotate(Vector3D v, double rad) {
        Vector3D n = v.normalize();
        Vector3D comp = n.scale(this.dot(n));
        Vector3D perp = this.subtract(comp);
        Vector3D ortho = Vector3D.getTrans(n, perp);
        double x0 = this.dot(perp);
        double y0 = this.dot(ortho);
        double c = Math.cos(rad);
        double s = Math.sin(rad);
        double x1 = x0 * c - y0 * s;
        double y1 = x0 * s + y0 * c;
        Vector3D perp1 = perp.scale(x1);
        Vector3D ortho1 = ortho.scale(y1);
        Vector3D result = comp.add(perp1.add(ortho1));
        return result;
    }

    public Vector3D calcRotation(Vector3D v) {
        Vector3D dir = v.cross(this);
        double s = dir.abs();
        double c = v.dot(this);
        if (Math.abs(s) == 0.0) {
            if (c < 0.0) {
                Vector3D xperp = X_AXIS.getPerpendicularComponent(this);
                Vector3D yperp = Y_AXIS.getPerpendicularComponent(this);
                Vector3D perp = xperp.abs() > yperp.abs() ? xperp.normalize() : yperp.normalize();
                return perp.scale(Math.PI);
            }
            return ORIGIN;
        }
        dir = dir.scale(1.0 / s);
        double angle = -Math.atan2(s, c);
        return dir.scale(angle);
    }

    public Vector3D rotate(Vector3D origin, Vector3D rotation) {
        double angle = rotation.abs();
        if (angle == 0.0) {
            return this;
        }
        Vector3D axis = rotation.scale(1.0 / angle);
        Vector3D temp = this.subtract(origin);
        temp = temp.rotate(axis, angle);
        temp = temp.add(origin);
        return temp;
    }

    public Vector3D rotate(Vector3D rotation) {
        double angle = rotation.abs();
        if (angle == 0.0) {
            return this;
        }
        Vector3D axis = rotation.scale(1.0 / angle);
        Vector3D temp = this.rotate(axis, angle);
        return temp;
    }

    public Vector3D concatenateRotation(Vector3D rotation) {
        Vector3D r1 = rotation;
        Vector3D r2 = this;
        double a1 = r1.abs();
        double w1 = 1.0;
        double x1 = 0.0;
        double y1 = 0.0;
        double z1 = 0.0;
        if (a1 != 0.0) {
            w1 = Math.cos(a1 / 2.0);
            x1 = r1.x / a1 * Math.sin(a1 / 2.0);
            y1 = r1.y / a1 * Math.sin(a1 / 2.0);
            z1 = r1.z / a1 * Math.sin(a1 / 2.0);
        }
        double a2 = r2.abs();
        double w2 = 1.0;
        double x2 = 0.0;
        double y2 = 0.0;
        double z2 = 0.0;
        if (a2 != 0.0) {
            w2 = Math.cos(a2 / 2.0);
            x2 = r2.x / a2 * Math.sin(a2 / 2.0);
            y2 = r2.y / a2 * Math.sin(a2 / 2.0);
            z2 = r2.z / a2 * Math.sin(a2 / 2.0);
        }
        double wr = w1 * w2 - x1 * x2 - y1 * y2 - z1 * z2;
        double xr = w1 * x2 + x1 * w2 + y1 * z2 - z1 * y2;
        double yr = w1 * y2 + y1 * w2 - x1 * z2 + z1 * x2;
        double zr = w1 * z2 + z1 * w2 + x1 * y2 - y1 * x2;
        Vector3D result = new Vector3D(xr, yr, zr);
        double sinar2 = result.abs();
        double ar = Math.atan2(sinar2, wr);
        result = sinar2 == 0.0 ? ORIGIN : result.scale(2.0 * ar / sinar2);
        return result;
    }

    public static void main(String[] args) {
        Vector3D r1 = X_AXIS.scale(Math.toRadians(30.0));
        Vector3D r2 = Y_AXIS.scale(Math.toRadians(60.0));
        Vector3D r3 = Z_AXIS.scale(Math.toRadians(90.0));
        Vector3D r4 = X_AXIS.scale(Math.toRadians(120.0));
        Vector3D r5 = Y_AXIS.scale(Math.toRadians(150.0));
        Vector3D r6 = Z_AXIS.scale(Math.toRadians(180.0));
        Vector3D rt = r1.concatenateRotation(r2).concatenateRotation(r3).concatenateRotation(r4).concatenateRotation(r5).concatenateRotation(r6);
        Vector3D p1 = new Vector3D(-1.0, 1.0, 1.0);
        Vector3D p2 = p1.rotate(r1).rotate(r2).rotate(r3).rotate(r4).rotate(r5).rotate(r6);
        Vector3D p3 = p1.rotate(rt);
        System.out.println("Vector3D.main p2: " + p2 + ", " + p3);
    }

    public Point3D toPoint3D() {
        return new Point3D(this.x, this.y, this.z);
    }

    public static Vector3D computeNormal(Vector3D p1, Vector3D p2, Vector3D p3) {
        Vector3D v12 = p2.subtract(p1);
        Vector3D v13 = p3.subtract(p1);
        Vector3D n = v12.cross(v13);
        return n.normalize();
    }
}

