/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import net.sourceforge.jocular.math.FunctionOfX;
import net.sourceforge.jocular.math.LookupTable;

public class TransmittanceLookupTable
implements FunctionOfX {
    private final FunctionOfX m_lookup;
    private final double m_minW;
    private final double m_maxW;

    public TransmittanceLookupTable(double[] ws, double wavelengthMultiplier, double thickness, double[] ts, double transmittanceMultiplier, boolean totalNotInternal, FunctionOfX refractiveIndex) {
        if (ts.length != ws.length) {
            throw new RuntimeException("Arrays are not the same length.");
        }
        int n = ws.length;
        double[] ws2 = new double[n + 2];
        double[] ts2 = new double[n + 2];
        for (int i = 0; i < n; ++i) {
            double w = ws[i] * wavelengthMultiplier;
            double t = ts[i] * transmittanceMultiplier;
            if (t > 1.0) {
                t = 1.0;
            } else if (t < 0.0) {
                t = 0.0;
            }
            if (totalNotInternal) {
                double index = refractiveIndex.getValue(w);
                t /= 2.0 * index / (index * index + 1.0);
            }
            t = Math.pow(t, 0.001 / thickness);
            ws2[i + 1] = w;
            ts2[i + 1] = t;
        }
        this.m_maxW = ws2[n];
        this.m_minW = ws2[1];
        ws2[0] = ws2[1] - (this.m_maxW - this.m_minW) / (double)n;
        ws2[n + 1] = ws2[n] + (this.m_maxW - this.m_minW) / (double)n;
        ts2[0] = 0.0;
        ts2[n + 1] = 0.0;
        this.m_lookup = LookupTable.makeLinearLookup(ws2, ts2);
    }

    @Override
    public double getValue(double x) {
        double result = x < this.m_minW ? 0.0 : (x > this.m_maxW ? 0.0 : this.m_lookup.getValue(x));
        return result;
    }
}

