/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;
import net.sourceforge.jocular.math.CalcCompleteEvent;
import net.sourceforge.jocular.math.CubicFit;
import net.sourceforge.jocular.math.SolverUpdateListener;
import net.sourceforge.jocular.math.SystemSolver;
import net.sourceforge.jocular.math.SystemToSolve;

public class SimpleMinimumSolver
implements SystemSolver {
    private SystemToSolve m_system = null;
    private ArrayList<Point2D.Double> m_history = new ArrayList();
    private ArrayList<Point2D.Double> m_lowestPoints = new ArrayList();
    private CubicFit m_fit = new CubicFit();
    private State m_firstTime = State.FIRST_TIME;
    private double[] m_fitYs = new double[100];
    private double[] m_fitXs = new double[100];
    private double m_bestValueAv = 0.0;
    private double m_bestValueSq = 0.0;
    private List<SolverUpdateListener> m_listeners = new CopyOnWriteArrayList<SolverUpdateListener>();
    int m_runCounter = 0;
    double m_min = 0.0;
    double m_max = 0.0;
    double m_bestValue = 0.0;
    private boolean m_running;
    private static final int FIT_POINTS = 100;

    @Override
    public void solve(SystemToSolve system) {
        if (this.m_system != null) {
            this.m_system.removeCalcCompleteListener(this);
        }
        this.m_system = system;
        this.m_system.addCalcCompleteListener(this);
        if (!this.m_running) {
            this.m_runCounter = 0;
            this.m_running = true;
            this.runOneIteration();
        }
    }

    @Override
    public void stop() {
        if (this.m_running) {
            this.m_running = false;
        }
    }

    private void runOneIteration() {
        if (!this.m_running || this.m_system == null) {
            return;
        }
        ++this.m_runCounter;
        if (this.m_runCounter < 1000) {
            double v = this.m_system.getParameter(0);
            switch (this.m_firstTime) {
                case FIRST_TIME: {
                    this.m_min = this.m_system.getMinLimit(0);
                    this.m_max = this.m_system.getMaxLimit(0);
                    v = this.m_min;
                    this.m_firstTime = State.SECOND_TIME;
                    break;
                }
                case SECOND_TIME: {
                    this.m_firstTime = State.SUBSEQUENT_TIMES;
                    v = this.m_max;
                    break;
                }
                default: {
                    v = Math.random() * (this.m_max - this.m_min) + this.m_min;
                }
            }
            this.m_system.setParameter(0, v);
            this.m_system.computeError(1.0);
        }
    }

    @Override
    public double[] getErrorPlotValues() {
        double[] result = new double[this.m_lowestPoints.size()];
        for (int i = 0; i < this.m_lowestPoints.size(); ++i) {
            result[i] = this.m_lowestPoints.get((int)i).y;
        }
        return result;
    }

    @Override
    public double[] getParameterPlotValues(int n) {
        double[] result = new double[this.m_lowestPoints.size()];
        for (int i = 0; i < this.m_lowestPoints.size(); ++i) {
            result[i] = this.m_lowestPoints.get((int)i).x;
        }
        return result;
    }

    @Override
    public double[] getFitXPlotValues(int i) {
        return this.m_fitXs;
    }

    @Override
    public double[] getFitYPlotValues() {
        double[] result = new double[this.m_lowestPoints.size()];
        for (int i = 0; i < this.m_lowestPoints.size(); ++i) {
            result[i] = this.m_lowestPoints.get((int)i).x;
        }
        return this.m_fitYs;
    }

    @Override
    public void calcComplete(CalcCompleteEvent e) {
        if (this.m_system == null) {
            return;
        }
        boolean keepRunning = true;
        Point2D.Double p = new Point2D.Double(this.m_system.getParameter(0), this.m_system.getErrorValue());
        this.m_history.add(p);
        if (this.m_lowestPoints.size() == 0) {
            this.m_lowestPoints.add(p);
        } else {
            int j = this.m_lowestPoints.size();
            for (int i = 0; i < this.m_lowestPoints.size(); ++i) {
                if (!(this.m_lowestPoints.get((int)i).x > p.x)) continue;
                j = i;
                break;
            }
            this.m_lowestPoints.add(j, p);
        }
        if (this.m_lowestPoints.size() > 31) {
            int maxI = this.m_lowestPoints.size() - 1;
            if (this.m_history.size() % 3 == 1) {
                if (this.m_bestValue - this.m_lowestPoints.get((int)0).x > this.m_lowestPoints.get((int)maxI).x - this.m_bestValue) {
                    this.m_lowestPoints.remove(0);
                } else {
                    this.m_lowestPoints.remove(maxI);
                }
            }
        }
        if (this.m_lowestPoints.size() > 3) {
            int i;
            this.m_min = this.m_lowestPoints.get((int)0).x;
            this.m_max = this.m_lowestPoints.get((int)(this.m_lowestPoints.size() - 1)).x;
            double[] xs = new double[this.m_lowestPoints.size()];
            double[] ys = new double[this.m_lowestPoints.size()];
            for (i = 0; i < xs.length; ++i) {
                xs[i] = this.m_lowestPoints.get((int)i).x;
                ys[i] = this.m_lowestPoints.get((int)i).y;
            }
            this.m_fit.fit(xs, ys);
            keepRunning = !this.accumulateBestValue(this.m_fit.getMin(this.m_min, this.m_max));
            for (i = 0; i < 100; ++i) {
                this.m_fitXs[i] = (this.m_max - this.m_min) / 100.0 * (double)i + this.m_min;
                this.m_fitYs[i] = this.m_fit.getValue(this.m_fitXs[i]);
            }
        }
        if (keepRunning) {
            this.runLater();
        }
    }

    private boolean accumulateBestValue(double bv) {
        this.m_bestValue = bv;
        this.m_bestValueAv *= 0.95;
        this.m_bestValueAv += 0.05 * bv;
        this.m_bestValueSq *= 0.95;
        this.m_bestValueSq += 0.05 * bv * bv;
        double sd = Math.sqrt(this.m_bestValueSq - Math.pow(this.m_bestValueAv, 2.0));
        System.out.println("SimpleMinimumSolver.accululateBestValue st dev " + sd);
        return sd < 1.0E-6;
    }

    @Override
    public boolean isRunning() {
        return this.m_running;
    }

    private void runLater() {
        if (!this.m_running || this.m_system == null) {
            return;
        }
        if (!this.m_system.isCalculating()) {
            this.runOneIteration();
        } else {
            Timer t = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    SimpleMinimumSolver.this.runLater();
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    @Override
    public double getBestParameterValue(int i) {
        if (this.m_system == null) {
            throw new RuntimeException("System is null");
        }
        double result = this.m_system.getParameter(i);
        if (i == 0) {
            result = this.m_bestValue;
        }
        return result;
    }

    @Override
    public void reset() {
        this.m_running = false;
        this.m_history.clear();
        this.m_lowestPoints.clear();
        this.m_firstTime = State.FIRST_TIME;
        this.m_runCounter = 0;
    }

    @Override
    public void addSolverUpdateListener(SolverUpdateListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeSolverUpdateListener(SolverUpdateListener listener) {
        this.m_listeners.remove(listener);
    }

    @Override
    public double getStandardDeviation(int i) {
        return Math.sqrt(this.m_bestValueSq - Math.pow(this.m_bestValueAv, 2.0));
    }

    @Override
    public boolean isSolved() {
        return false;
    }

    @Override
    public int getParameterCount() {
        return 0;
    }

    private static enum State {
        FIRST_TIME,
        SECOND_TIME,
        SUBSEQUENT_TIMES;

    }
}

