/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import net.sourceforge.jocular.math.FunctionOfX;

public class SellmeierEquation2
implements FunctionOfX {
    private final double m_b1;
    private final double m_b3;
    private final double m_b2;
    private final double m_c2;

    public SellmeierEquation2(double b1, double b2, double b3, double c2) {
        this.m_b1 = b1;
        this.m_b2 = b2;
        this.m_b3 = b3 * 1.0E-12;
        this.m_c2 = c2 * 1.0E-12;
    }

    @Override
    public double getValue(double x) {
        double x2 = Math.pow(x, 2.0);
        double result = this.m_b1;
        result += this.m_b2 / (x2 - this.m_c2);
        result += this.m_b3 * x2;
        result = Math.sqrt(result);
        return result;
    }
}

