/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import Jama.Matrix;
import Jama.QRDecomposition;
import net.sourceforge.jocular.math.FunctionOfX;

public class SellmeierEquation
implements FunctionOfX {
    private final double m_b1;
    private final double m_b3;
    private final double m_b2;
    private final double m_c1;
    private final double m_c2;
    private final double m_c3;

    public SellmeierEquation(double b1, double b2, double b3, double c1, double c2, double c3) {
        this.m_b1 = b1;
        this.m_b2 = b2;
        this.m_b3 = b3;
        this.m_c1 = c1 * 1.0E-12;
        this.m_c2 = c2 * 1.0E-12;
        this.m_c3 = c3 * 1.0E-12;
    }

    public SellmeierEquation(double[] wavelength, double[] index, double wavelengthMultiplier) {
        if (wavelength.length != index.length) {
            throw new RuntimeException("Wavelength and Index arrays are not the same length.");
        }
        int n = wavelength.length;
        Matrix residual = new Matrix(n, 1);
        Matrix lam2 = new Matrix(n, 1);
        for (int i = 0; i < n; ++i) {
            residual.set(i, 0, Math.pow(index[i], 2.0) - 1.0);
            lam2.set(i, 0, Math.pow(wavelength[i] * wavelengthMultiplier, 2.0));
        }
        Matrix a = new Matrix(n, 2);
        Matrix y = residual.arrayTimes(lam2);
        a.setMatrix(0, n - 1, 0, 0, lam2);
        a.setMatrix(0, n - 1, 1, 1, residual);
        QRDecomposition qrd = new QRDecomposition(a);
        Matrix coeff = qrd.solve(y);
        this.m_b1 = coeff.get(0, 0);
        this.m_c1 = coeff.get(1, 0);
        Matrix fit = lam2.times(this.m_b1);
        fit = fit.arrayRightDivide(lam2.minus(new Matrix(n, 1, this.m_c1)));
        residual = residual.minus(fit);
        a = new Matrix(n, 2);
        y = residual.arrayTimes(lam2);
        a.setMatrix(0, n - 1, 0, 0, lam2);
        a.setMatrix(0, n - 1, 1, 1, residual);
        qrd = new QRDecomposition(a);
        coeff = qrd.solve(y);
        this.m_b2 = coeff.get(0, 0);
        this.m_c2 = coeff.get(1, 0);
        fit = lam2.times(this.m_b2);
        fit = fit.arrayRightDivide(lam2.minus(new Matrix(n, 1, this.m_c2)));
        residual = residual.minus(fit);
        a = new Matrix(n, 2);
        y = residual.arrayTimes(lam2);
        a.setMatrix(0, n - 1, 0, 0, lam2);
        a.setMatrix(0, n - 1, 1, 1, residual);
        qrd = new QRDecomposition(a);
        coeff = qrd.solve(y);
        this.m_b3 = coeff.get(0, 0);
        this.m_c3 = coeff.get(1, 0);
        fit = lam2.times(this.m_b3);
        fit = fit.arrayRightDivide(lam2.minus(new Matrix(n, 1, this.m_c3)));
        residual = residual.minus(fit);
    }

    @Override
    public double getValue(double x) {
        double x2 = Math.pow(x, 2.0);
        double result = this.m_b1 / (x2 - this.m_c1);
        result += this.m_b2 / (x2 - this.m_c2);
        result += this.m_b3 / (x2 - this.m_c3);
        result *= x2;
        result += 1.0;
        result = Math.sqrt(result);
        return result;
    }
}

