/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import Jama.Matrix;

public class QuinticFit {
    private double m_a = 0.0;
    private double m_b = 0.0;
    private double m_c = 0.0;
    private double m_d = 0.0;
    private double m_e = 0.0;
    private double m_f = 0.0;

    public void fit(double[] x, double[] y) {
        double[][] xs = new double[x.length][6];
        for (int i = 0; i < x.length; ++i) {
            xs[i][0] = Math.pow(x[i], 5.0);
            xs[i][1] = Math.pow(x[i], 4.0);
            xs[i][2] = Math.pow(x[i], 3.0);
            xs[i][3] = Math.pow(x[i], 2.0);
            xs[i][4] = x[i];
            xs[i][5] = 1.0;
        }
        Matrix my = new Matrix(y, y.length);
        Matrix mxs = new Matrix(xs);
        Matrix mxst = mxs.transpose();
        Matrix mi = mxst.times(mxs).inverse();
        Matrix mc = mi.times(mxst).times(my);
        this.m_a = mc.get(0, 0);
        this.m_b = mc.get(1, 0);
        this.m_c = mc.get(2, 0);
        this.m_d = mc.get(3, 0);
        this.m_e = mc.get(4, 0);
        this.m_f = mc.get(5, 0);
    }

    public double getValue(double x) {
        return ((((this.m_a * x + this.m_b) * x + this.m_c) * x + this.m_d) * x + this.m_e) * x + this.m_f;
    }

    public double getMin(double xMin, double xMax) {
        double x = xMin;
        double sqr = 4.0 * this.m_b * this.m_b - 12.0 * this.m_a * this.m_c;
        if (sqr > 0.0) {
            double t2 = Math.sqrt(sqr) / 6.0 / this.m_a;
            double t1 = -this.m_b / 3.0 / this.m_a;
            double x1 = t1 + t2;
            double x2 = t1 - t2;
            System.out.println("CubicFit.getMin " + x1 + ", " + x2);
            if (x1 >= xMin && x1 <= xMax) {
                x = x1;
            } else if (x2 >= xMin && x2 <= xMax) {
                x = x2;
            }
        }
        double yMin = this.getValue(xMin);
        double yMax = this.getValue(xMax);
        double yX = this.getValue(x);
        if (!(yX < yMin) || !(yX < yMax)) {
            if (yMin < yX && yMin < yMax) {
                x = xMin;
            } else if (yMax < yX && yMax < yMin) {
                x = xMax;
            }
        }
        return x;
    }
}

