/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import Jama.Matrix;
import net.sourceforge.jocular.math.Polynomial;

public class QuadraticFit {
    private Polynomial m_fit;

    public void fit(double[] x, double[] y) {
        double[][] xs = new double[x.length][3];
        for (int i = 0; i < x.length; ++i) {
            xs[i][2] = Math.pow(x[i], 2.0);
            xs[i][1] = x[i];
            xs[i][0] = 1.0;
        }
        Matrix my = new Matrix(y, y.length);
        Matrix mxs = new Matrix(xs);
        Matrix mxst = mxs.transpose();
        Matrix mi = mxst.times(mxs).inverse();
        Matrix mc = mi.times(mxst).times(my);
        this.m_fit = Polynomial.makeFromCoefficients(mc.getRowPackedCopy());
    }

    public double getValue(double x) {
        return this.m_fit.evaluate(x);
    }
}

