/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.splines.SplineCoefficients;

public class PolygonDicer {
    private final double[] m_xs;
    private final double[] m_ys;
    private final boolean[] m_smooths;
    private final ArrayList<Integer> m_pointsNotDiced = new ArrayList();
    private final double m_sumAround;
    private final double m_sumAround2;
    private ArrayList<int[]> m_triangles = new ArrayList();

    public PolygonDicer(SplineCoefficients[] scs, int segNum) {
        if (scs == null) {
            throw new RuntimeException("Coeffs cannot be null!");
        }
        int m = scs.length;
        if (scs == null || m <= 2) {
            this.m_ys = new double[]{0.0, 0.005, 0.005, 0.0};
            this.m_xs = new double[]{-0.005, -0.005, 0.005, 0.005};
            this.m_smooths = new boolean[]{false, false, false, false};
        } else {
            int n = 0;
            for (SplineCoefficients sc : scs) {
                if (sc.isStraight()) {
                    ++n;
                    continue;
                }
                n += segNum;
            }
            this.m_xs = new double[++n];
            this.m_ys = new double[n];
            this.m_smooths = new boolean[n];
            int i = 0;
            for (SplineCoefficients sc : scs) {
                if (sc.isStraight()) {
                    this.m_xs[i] = sc.calcX(0.0);
                    this.m_ys[i] = sc.calcY(0.0);
                    this.m_smooths[i] = false;
                    this.m_pointsNotDiced.add(i);
                    ++i;
                    continue;
                }
                double s = 0.0;
                int iStop = i + segNum;
                double ds = 1.0 / (double)segNum;
                while (i < iStop) {
                    this.m_xs[i] = sc.calcX(s);
                    this.m_ys[i] = sc.calcY(s);
                    this.m_smooths[i] = true;
                    this.m_pointsNotDiced.add(i);
                    s += ds;
                    ++i;
                }
            }
            this.m_xs[n - 1] = scs[m - 1].calcX(1.0);
            this.m_ys[n - 1] = scs[m - 1].calcY(1.0);
            this.m_smooths[n - 1] = true;
            this.m_pointsNotDiced.add(n - 1);
        }
        this.m_sumAround = this.calcSumAround();
        if (this.m_sumAround > 0.0) {
            this.reversePoints();
        }
        this.m_sumAround2 = this.calcSumAround();
    }

    public PolygonDicer(double[] xs, double[] ys, boolean[] smooths) {
        if (xs.length != ys.length && xs.length != smooths.length) {
            throw new RuntimeException("Arrays should be the same length!");
        }
        this.m_xs = xs;
        this.m_ys = ys;
        if (Double.isNaN(this.m_xs[0])) {
            throw new RuntimeException("Thingy is NaN!");
        }
        int n = xs.length;
        this.m_smooths = smooths;
        for (int i = 0; i < n; ++i) {
            this.m_pointsNotDiced.add(i);
        }
        this.m_sumAround = this.calcSumAround();
        if (this.m_sumAround > 0.0) {
            this.reversePoints();
        }
        this.m_sumAround2 = this.calcSumAround();
    }

    private void reversePoints() {
        int n = this.getPointCount();
        if (this.isCcw()) {
            int j = n - 1;
            for (int i = 0; i < n; ++i) {
                this.m_pointsNotDiced.set(i, j);
                --j;
            }
        }
    }

    private double calcSumAround() {
        double sum = 0.0;
        int n = this.getPointCount();
        for (int i = 0; i < n; ++i) {
            double a = this.getDegrees(this.getVertices(i));
            sum += a;
        }
        return sum;
    }

    public int getPointCount() {
        return this.m_xs.length;
    }

    public void dice() {
        while (this.m_pointsNotDiced.size() > 3) {
            this.removeOneEar();
        }
        this.m_triangles.add(this.getVertices(0));
        this.m_pointsNotDiced.clear();
    }

    public Vector3D project(int index, Vector3D origin, Vector3D xDir, Vector3D yDir) {
        double x = this.m_xs[index];
        double y = this.m_ys[index];
        return origin.add(xDir.scale(x)).add(yDir.scale(y));
    }

    private void removeOneEar() {
        double bestErr = Double.POSITIVE_INFINITY;
        int bestIndex = 0;
        double targetDeg = 120.0;
        int n = this.m_pointsNotDiced.size();
        for (int i1 = 0; i1 < n; ++i1) {
            int[] is = this.getVertices(i1);
            double angle = this.getDegrees(is);
            double err = Math.abs(angle - targetDeg);
            if (err < bestErr && !this.containsAnyOtherPoints(is)) {
                bestErr = err;
                bestIndex = i1;
            }
            if (bestErr < 30.0) break;
        }
        int[] is = this.getVertices(bestIndex);
        this.m_triangles.add(is);
        this.m_pointsNotDiced.remove(bestIndex);
    }

    private int[] getVertices(int i1) {
        int n = this.m_pointsNotDiced.size();
        int i0 = i1 - 1;
        int i2 = i1 + 1;
        if (i0 < 0) {
            i0 += n;
        }
        if (i2 >= n) {
            i2 -= n;
        }
        return new int[]{this.m_pointsNotDiced.get(i0), this.m_pointsNotDiced.get(i1), this.m_pointsNotDiced.get(i2)};
    }

    private Vector3D makeVec(int i) {
        double y;
        int ii = i % this.getPointCount();
        double x = this.m_xs[ii];
        if (Double.isNaN(x + (y = this.m_ys[ii]))) {
            throw new RuntimeException("point is NaN.");
        }
        return new Vector3D(x, y, 0.0);
    }

    private double getDegrees(int[] is) {
        Vector3D p0 = this.makeVec(is[0]);
        Vector3D p1 = this.makeVec(is[1]);
        Vector3D p2 = this.makeVec(is[2]);
        Vector3D d12 = p2.subtract(p1);
        Vector3D d01 = p1.subtract(p0);
        double a01 = Math.toDegrees(Math.atan2(d01.y, d01.x));
        double a12 = Math.toDegrees(Math.atan2(d12.y, d12.x));
        double result = a12 - a01;
        if (result < -180.0) {
            result += 360.0;
        } else if (result > 180.0) {
            result -= 360.0;
        }
        return result;
    }

    public static void main(String ... args) {
        double[] xs = new double[]{0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 1.0, 2.0, 2.0};
        double[] ys = new double[]{0.0, 1.0, 1.0, 2.0, 2.0, 3.0, 3.0, 2.0, 0.0};
        boolean[] ss = new boolean[]{false, false, false, false, false, false, false, false, false};
        PolygonDicer d = new PolygonDicer(xs, ys, ss);
        d.dice();
    }

    public List<int[]> getTriangles() {
        if (this.m_pointsNotDiced.size() > 0) {
            this.dice();
        }
        return this.m_triangles;
    }

    public double[] getXs() {
        return this.m_xs;
    }

    public double[] getYs() {
        return this.m_ys;
    }

    private boolean isSameSide(Vector3D lp0, Vector3D lp1, Vector3D p, Vector3D pt) {
        double ptdot;
        Vector3D ndir;
        Vector3D dir = lp1.subtract(lp0);
        Vector3D dpt = pt.subtract(lp0);
        Vector3D dp = p.subtract(lp0);
        double pdot = dp.dot(ndir = new Vector3D(-dir.y, dir.x, 0.0));
        return pdot * (ptdot = dpt.dot(ndir)) >= 0.0;
    }

    private boolean contains(int[] is, int it) {
        Vector3D pt;
        boolean result = false;
        Vector3D p0 = this.makeVec(0);
        Vector3D p1 = this.makeVec(1);
        Vector3D p2 = this.makeVec(2);
        if (this.isSameSide(p0, p2, p1, pt = this.makeVec(it)) && this.isSameSide(p0, p1, p2, pt) && this.isSameSide(p1, p2, p0, pt)) {
            result = true;
        }
        return result;
    }

    private boolean containsAnyOtherPoints(int[] is) {
        boolean result = false;
        int n = this.m_pointsNotDiced.size();
        for (int i = 0; i < n; ++i) {
            int it = this.m_pointsNotDiced.get(i);
            if (it == is[0] || it == is[1] || it == is[2] || !this.contains(is, it)) continue;
            result = true;
            break;
        }
        return result;
    }

    public boolean isCcw() {
        return this.m_sumAround < 0.0;
    }

    public boolean[] getSmooths() {
        return this.m_smooths;
    }
}

