/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.ProbabilityResolver;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.Polarization;

public class OpticalCalcs {
    public static void calcReflectOrRefractRay(PhotonInteraction pi, PhotonTrajectory pt) {
        Photon.PhotonSource pSource;
        double phaseB;
        double phaseA;
        double magB;
        double magA;
        double dot;
        Vector3D dirA;
        Vector3D dirB;
        Vector3D dir;
        double tP;
        double tS;
        double rP;
        double rS;
        double nEnd;
        OpticalMaterial mEnd;
        Vector3D surfaceNormal = pi.getNormal();
        OpticsObject o = pi.getInteractingObject();
        boolean fromInside = pi.isFromInside();
        Photon p = pt.getPhoton();
        if (pt.isInOutermostObject() && fromInside) {
            System.out.println("OpticalCalcs.calcReflectOrRefractRay photon has somehow got out of an object without properly getting out.");
            return;
        }
        OpticsObject oBegin = pi.getFromObject() == null ? pt.getContainingObject() : pi.getFromObject();
        OpticsObject oEnd = pi.getToObject() == null ? pt.getOutermostObject() : pi.getToObject();
        OpticalMaterial mBegin = oBegin.getMaterial();
        if (mBegin.equals(mEnd = oEnd.getMaterial())) {
            Photon p2 = new Photon(pi.getLocation(), p.getDirection(), p.getWavelength(), p.getPolarization(), Photon.PhotonSource.UNCHANGED, p.getIntensity(), oEnd);
            PhotonInteraction pi2 = new PhotonInteraction(p2, pi.getLocation(), oBegin, pi.getNormal(), "passed through unchanged");
            pt.addPhoton(p2, pi2);
            return;
        }
        Vector3D n = surfaceNormal.normalize();
        double nBegin = mBegin.isIsotropic() ? mBegin.getOrdinaryRefractiveIndex(p.getWavelength()) : (p.getPolarization().getMagA() > 0.0 ? mBegin.getExtraordinaryRefractiveIndex(p.getWavelength()) : mBegin.getOrdinaryRefractiveIndex(p.getWavelength()));
        if (mEnd.isIsotropic()) {
            nEnd = mEnd.getOrdinaryRefractiveIndex(p.getWavelength());
        } else {
            Vector3D trans = o.getPositioner().getTransDirection();
            Polarization pol = p.getPolarization().resolveOntoAxis(trans);
            p = new Photon(p.getOrigin(), p.getDirection(), p.getWavelength(), pol, Photon.PhotonSource.TRANSMITTED, p.getIntensity(), p.getContainingObject());
            nEnd = pol.getMagA() > 0.0 ? mEnd.getExtraordinaryRefractiveIndex(p.getWavelength()) : mEnd.getOrdinaryRefractiveIndex(p.getWavelength());
        }
        double cosI = Math.abs(p.getDirection().dot(n));
        double sinI = p.getDirection().cross(n).abs();
        double sinT = nEnd > 0.0 ? nBegin * sinI / nEnd : Double.MAX_VALUE;
        double cosT = 0.0;
        Polarization pAligned = p.getPolarization().rotate(n);
        boolean willReflect = false;
        if (sinT >= 1.0) {
            willReflect = true;
            rS = 1.0;
            rP = 1.0;
            tS = 0.0;
            tP = 0.0;
        } else {
            cosT = Math.sqrt(1.0 - Math.pow(sinT, 2.0));
            rS = Math.pow((nBegin * cosI - nEnd * cosT) / (nBegin * cosI + nEnd * cosT), 2.0);
            rP = Math.pow((nBegin * cosT - nEnd * cosI) / (nBegin * cosT + nEnd * cosI), 2.0);
            tS = 1.0 - rS;
            tP = 1.0 - rP;
            double pReflect = rS * pAligned.getMagA() + rP * pAligned.getMagB();
            double pRefract = tS * pAligned.getMagA() + tP * pAligned.getMagB();
            double prob = pReflect / (pReflect + pRefract);
            willReflect = ProbabilityResolver.resolve(prob);
        }
        Vector3D pn = p.getDirection().getParallelComponent(n);
        Vector3D po = p.getDirection().subtract(pn);
        Vector3D origin = p.getOrigin();
        if (willReflect) {
            dir = po.subtract(pn);
            dirA = dir.cross(dirB = pAligned.getDirB());
            dot = dirA.dot(pAligned.getDirA());
            if (dot < 0.0) {
                dirA = dirA.neg();
            }
            magA = pAligned.getMagA() * rS * rS;
            magB = pAligned.getMagB() * rP * rP;
            double k = Math.sqrt(magA * magA + magB * magB);
            magA /= k;
            magB /= k;
            phaseA = -pAligned.getPhaseA();
            phaseB = pAligned.getPhaseB();
            pSource = Photon.PhotonSource.REFLECTED;
        } else {
            dir = pn.normalize().scale(cosT);
            dirA = (dir = dir.add(po.normalize().scale(sinT))).cross(dirB = pAligned.getDirB());
            dot = dirA.dot(pAligned.getDirA());
            if (dot < 0.0) {
                dirA = dirA.neg();
            }
            magA = pAligned.getMagA() * tS * tS;
            magB = pAligned.getMagB() * tP * tP;
            double k = Math.sqrt(magA * magA + magB * magB);
            magA /= k;
            magB /= k;
            phaseA = pAligned.getPhaseA();
            phaseB = pAligned.getPhaseB();
            pSource = Photon.PhotonSource.REFRACTED;
        }
        Polarization newPol = new Polarization(dirA, dirB, magA, magB, phaseA, phaseB);
        OpticsObject co = willReflect ? oBegin : oEnd;
        pt.addPhoton(new Photon(origin, dir, p.getWavelength(), newPol, pSource, p.getIntensity(), co), pi);
    }
}

