/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.util.SplittableRandom;
import net.sourceforge.jocular.settings.Settings;

public class MultiProbabilityResolver<T> {
    private static final SplittableRandom random = new SplittableRandom(1L);
    private T[] m_keys;
    private double[] m_probs;
    private T m_choice;
    private double m_choiceValue;
    private int m_max;

    public MultiProbabilityResolver(T[] keys, double[] probabilities) {
        this.m_probs = probabilities;
        this.m_keys = keys;
        if (keys.length != probabilities.length) {
            throw new RuntimeException("Array lengths not equal");
        }
        this.resolve();
    }

    public void resolve() {
        if (Settings.SETTINGS.isPickMostProbable()) {
            this.m_choice = this.m_keys[this.m_max];
            this.m_choiceValue = 1.0;
        } else {
            double r = random.nextDouble();
            for (int i = 0; i < this.m_probs.length; ++i) {
                double p = this.m_probs[i];
                if (r < p || i == this.m_probs.length - 1) {
                    this.m_choice = this.m_keys[i];
                    this.m_choiceValue = r / p;
                    break;
                }
                r -= p;
            }
        }
    }

    public T getChosenKey() {
        return this.m_choice;
    }

    public double getRelativeChoiceValue() {
        return this.m_choiceValue;
    }

    public static void main(String[] args) {
        SplittableRandom r = new SplittableRandom();
        double total = 0.0;
        long start = System.currentTimeMillis();
        for (long i = 0L; i < 1000000000L; ++i) {
            total += r.nextDouble();
        }
        long end = System.currentTimeMillis();
        System.out.println("MultiProbabilityResolver " + total + " in " + (end - start));
    }
}

