/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.Timer;
import net.sourceforge.jocular.math.CalcCompleteEvent;
import net.sourceforge.jocular.math.SolverUpdateEvent;
import net.sourceforge.jocular.math.SolverUpdateListener;
import net.sourceforge.jocular.math.SystemSolver;
import net.sourceforge.jocular.math.SystemToSolve;

public class MultiMinimumSolver
implements SystemSolver {
    private boolean m_running = false;
    private ArrayList<OneSample> m_workingSamples = new ArrayList();
    private double[] m_currentValues;
    private double[] m_minValues;
    private double[] m_maxValues;
    private double[] m_bestValues;
    private double m_minError = 0.0;
    private double m_maxError = 0.0;
    private static final int CYCLES_BEFORE_DISCARD = 20;
    private static final int MAX_WORKING_POINTS = 50;
    private double m_quality = 0.0;
    private int m_cycleCount = 0;
    private SystemToSolve m_system = null;
    private int m_paramNum = 0;
    private double[] m_bestValueAvs;
    private double[] m_bestValueSqAvs;
    private boolean m_solved = false;
    private List<SolverUpdateListener> m_listeners = new CopyOnWriteArrayList<SolverUpdateListener>();

    @Override
    public void calcComplete(CalcCompleteEvent e) {
        OneSample os = new OneSample(this.m_system.getErrorValue(), this.m_currentValues);
        this.m_workingSamples.add(os);
        this.m_solved = this.calcBestValues();
        ++this.m_cycleCount;
        if (this.m_cycleCount > 20 * this.m_paramNum && (this.m_cycleCount % 2 == 0 || this.m_workingSamples.size() > 50 * this.m_paramNum)) {
            this.discardWorstValue();
        }
        this.fireSolverUpdate();
        this.runLater();
    }

    @Override
    public void solve(SystemToSolve system) {
        if (!this.m_running) {
            if (system != this.m_system || system.getParameterCount() != this.m_paramNum) {
                if (this.m_system != null) {
                    this.m_system.removeCalcCompleteListener(this);
                }
                this.m_system = system;
                this.m_cycleCount = 0;
            }
            this.m_system.addCalcCompleteListener(this);
            this.m_running = true;
            this.m_solved = false;
            this.runOneIteration();
        }
    }

    private void runOneIteration() {
        switch (this.m_cycleCount) {
            case 0: {
                this.m_paramNum = this.m_system.getParameterCount();
                this.m_currentValues = new double[this.m_paramNum];
                this.m_minValues = new double[this.m_paramNum];
                this.m_maxValues = new double[this.m_paramNum];
                this.m_bestValues = new double[this.m_paramNum];
                this.m_bestValueAvs = new double[this.m_paramNum];
                this.m_bestValueSqAvs = new double[this.m_paramNum];
                this.m_workingSamples.clear();
                for (int i = 0; i < this.m_paramNum; ++i) {
                    this.m_bestValueAvs[i] = 0.01;
                    this.m_bestValueSqAvs[i] = 0.01;
                    this.m_currentValues[i] = this.m_system.getMinLimit(i);
                    this.m_minValues[i] = this.m_system.getMinLimit(i);
                    this.m_maxValues[i] = this.m_system.getMaxLimit(i);
                    this.m_system.setParameter(i, this.m_currentValues[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < this.m_paramNum; ++i) {
                    this.m_currentValues[i] = this.m_maxValues[i];
                    this.m_system.setParameter(i, this.m_currentValues[i]);
                }
                break;
            }
            default: {
                this.calcRandomValues();
            }
        }
        this.m_system.computeError(this.m_quality);
    }

    private void calcRandomValues() {
        double mag = Double.MAX_VALUE;
        while (mag > 1.0) {
            mag = 0.0;
            for (int i = 0; i < this.m_paramNum; ++i) {
                this.m_currentValues[i] = (this.m_maxValues[i] - this.m_minValues[i]) * Math.random() + this.m_minValues[i];
                this.m_system.setParameter(i, this.m_currentValues[i]);
            }
        }
    }

    @Override
    public void stop() {
        if (this.m_running) {
            this.m_running = false;
            this.fireSolverUpdate();
            this.m_system.removeCalcCompleteListener(this);
        }
    }

    @Override
    public double[] getErrorPlotValues() {
        double[] result = new double[this.m_workingSamples.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.m_workingSamples.get(i).getError();
        }
        return result;
    }

    @Override
    public double[] getParameterPlotValues(int n) {
        if (n > this.m_paramNum) {
            throw new RuntimeException("Index out of bounds " + n);
        }
        double[] result = new double[this.m_workingSamples.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.m_workingSamples.get(i).getParam(n);
            if (this.m_cycleCount > 20 * this.m_paramNum) {
                int n2 = i;
                result[n2] = result[n2] - this.m_bestValues[n];
                continue;
            }
            int n3 = i;
            result[n3] = result[n3] - (this.m_maxValues[n] + this.m_minValues[n]) / 2.0;
        }
        return result;
    }

    @Override
    public double[] getFitXPlotValues(int i) {
        double[] xs = new double[]{0.0, 0.0};
        return xs;
    }

    @Override
    public double[] getFitYPlotValues() {
        double[] ys = new double[]{this.m_minError, this.m_maxError};
        return ys;
    }

    @Override
    public boolean isRunning() {
        return this.m_running;
    }

    @Override
    public void reset() {
        this.stop();
        this.m_workingSamples.clear();
        this.m_cycleCount = 0;
        if (this.m_system != null) {
            this.m_system.removeCalcCompleteListener(this);
        }
        this.m_system = null;
        this.m_bestValues = null;
        this.m_minValues = null;
        this.m_maxValues = null;
        this.m_bestValueAvs = null;
        this.m_bestValueSqAvs = null;
    }

    @Override
    public int getParameterCount() {
        int result = 0;
        if (this.m_bestValues != null) {
            result = this.m_bestValues.length;
        }
        return result;
    }

    @Override
    public double getBestParameterValue(int i) {
        double result = 0.0;
        if (this.m_bestValues != null) {
            result = this.m_bestValues[i];
        }
        return result;
    }

    private void runLater() {
        if (!this.m_running || this.m_system == null || this.m_solved) {
            return;
        }
        if (!this.m_system.isCalculating()) {
            this.runOneIteration();
        } else {
            Timer t = new Timer(100, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    MultiMinimumSolver.this.runLater();
                }
            });
            t.setRepeats(false);
            t.start();
        }
    }

    private boolean calcBestValues() {
        int i;
        double mean = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        double[] minPs = new double[this.m_paramNum];
        double[] maxPs = new double[this.m_paramNum];
        double[] minBestHalf = new double[this.m_paramNum];
        double[] maxBestHalf = new double[this.m_paramNum];
        boolean firstTime = true;
        for (OneSample os : this.m_workingSamples) {
            mean += os.getError();
            if (os.getError() > max) {
                max = os.getError();
            }
            if (os.getError() < min) {
                min = os.getError();
            }
            if (this.m_cycleCount <= 20 * this.m_paramNum) continue;
            for (int i2 = 0; i2 < this.m_paramNum; ++i2) {
                if (firstTime) {
                    minPs[i2] = Double.MAX_VALUE;
                    maxPs[i2] = Double.MIN_VALUE;
                    minBestHalf[i2] = Double.MAX_VALUE;
                    maxBestHalf[i2] = Double.MIN_VALUE;
                }
                if (minPs[i2] > os.getParam(i2)) {
                    minPs[i2] = os.getParam(i2);
                }
                if (!(maxPs[i2] < os.getParam(i2))) continue;
                maxPs[i2] = os.getParam(i2);
            }
            firstTime = false;
        }
        if (this.m_cycleCount > 20 * this.m_paramNum) {
            this.m_maxValues = maxPs;
            this.m_minValues = minPs;
        }
        mean /= (double)this.m_workingSamples.size();
        double[] bvs = new double[this.m_paramNum];
        firstTime = true;
        int n = 0;
        for (OneSample os : this.m_workingSamples) {
            if (!(os.getError() < mean)) continue;
            ++n;
            for (i = 0; i < this.m_paramNum; ++i) {
                if (firstTime) {
                    bvs[i] = os.getParam(i);
                } else {
                    int n2 = i;
                    bvs[n2] = bvs[n2] + os.getParam(i);
                }
                if (os.getParam(i) > maxBestHalf[i]) {
                    maxBestHalf[i] = os.getParam(i);
                }
                if (!(os.getParam(i) < minBestHalf[i])) continue;
                minBestHalf[i] = os.getParam(i);
            }
            firstTime = false;
        }
        for (int i3 = 0; i3 < this.m_paramNum; ++i3) {
            if (n == 0) {
                bvs[i3] = 0.0;
                continue;
            }
            int n3 = i3;
            bvs[n3] = bvs[n3] / (double)n;
        }
        double noise = 0.0;
        for (i = 0; i < this.m_paramNum; ++i) {
            double pNoise = (maxBestHalf[i] - minBestHalf[i]) / (this.m_maxValues[i] - this.m_minValues[i]);
            noise += Math.pow(pNoise, 2.0);
        }
        noise = Math.sqrt(noise / (double)this.m_paramNum);
        this.m_quality += (noise -= 0.75) / 100.0;
        if (this.m_quality > 1.0) {
            this.m_quality = 1.0;
        } else if (this.m_quality < 0.0) {
            this.m_quality = 0.0;
        }
        this.m_bestValues = bvs;
        this.m_minError = min;
        this.m_maxError = max;
        return this.accumulateBestValue(bvs);
    }

    private void discardWorstValue() {
        OneSample worstSample = null;
        double d = 0.0;
        double worstD = 0.0;
        for (OneSample os : this.m_workingSamples) {
            d = os.distance(this.m_bestValues);
            if (worstSample != null && !(d > worstD)) continue;
            worstD = d;
            worstSample = os;
        }
        if (worstSample != null) {
            this.m_workingSamples.remove(worstSample);
        }
    }

    private boolean accumulateBestValue(double[] bvs) {
        double maxSd = 0.0;
        for (int i = 0; i < bvs.length; ++i) {
            int n = i;
            this.m_bestValueAvs[n] = this.m_bestValueAvs[n] * 0.95;
            int n2 = i;
            this.m_bestValueAvs[n2] = this.m_bestValueAvs[n2] + 0.05 * bvs[i];
            int n3 = i;
            this.m_bestValueSqAvs[n3] = this.m_bestValueSqAvs[n3] * 0.95;
            int n4 = i;
            this.m_bestValueSqAvs[n4] = this.m_bestValueSqAvs[n4] + 0.05 * bvs[i] * bvs[i];
            double sd = Math.sqrt(this.m_bestValueSqAvs[i] - Math.pow(this.m_bestValueAvs[i], 2.0));
            if (Double.isNaN(sd)) {
                sd = Double.MAX_VALUE;
            }
            if (sd > maxSd) {
                maxSd = sd;
            }
            if (!Double.isNaN(this.m_bestValueAvs[i]) && !Double.isNaN(this.m_bestValueSqAvs[i])) continue;
            this.m_bestValueAvs[i] = 0.01;
            this.m_bestValueSqAvs[i] = 0.01;
        }
        return maxSd < 1.0E-6;
    }

    @Override
    public void addSolverUpdateListener(SolverUpdateListener listener) {
        if (!this.m_listeners.contains(listener)) {
            this.m_listeners.add(listener);
        }
    }

    @Override
    public void removeSolverUpdateListener(SolverUpdateListener listener) {
        this.m_listeners.remove(listener);
    }

    private void fireSolverUpdate() {
        SolverUpdateEvent e = new SolverUpdateEvent(this);
        for (SolverUpdateListener ccl : this.m_listeners) {
            ccl.solverUpdated(e);
        }
    }

    @Override
    public double getStandardDeviation(int i) {
        if (this.m_bestValueSqAvs == null || this.m_bestValueAvs == null) {
            return 0.0;
        }
        return Math.sqrt(this.m_bestValueSqAvs[i] - Math.pow(this.m_bestValueAvs[i], 2.0));
    }

    @Override
    public boolean isSolved() {
        return this.m_solved;
    }

    private class OneSample {
        private final double m_errorValue;
        private final double[] m_paramValues;

        OneSample(double error, double[] params) {
            this.m_errorValue = error;
            this.m_paramValues = new double[params.length];
            for (int i = 0; i < this.m_paramValues.length; ++i) {
                this.m_paramValues[i] = params[i];
            }
        }

        public double getError() {
            return this.m_errorValue;
        }

        public double getParam(int i) {
            return this.m_paramValues[i];
        }

        public double distance(double[] p) {
            double result = 0.0;
            for (int i = 0; i < this.m_paramValues.length; ++i) {
                result += Math.pow(this.m_paramValues[i] - p[i], 2.0);
            }
            result = Math.sqrt(result);
            return result;
        }
    }
}

