/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import net.sourceforge.jocular.math.FunctionOfX;

public class LookupTable
implements FunctionOfX {
    private final double[][] c;
    private final double xMin;
    private final double xMax;
    private final double dx;

    public LookupTable(double[] xData, double[] yData) {
        this(xData, yData, xData.length, true);
    }

    public static LookupTable makeLinearLookup(double[] xData, double[] yData) {
        return new LookupTable(xData, yData, xData.length, true, false, true);
    }

    public LookupTable(double[] xData, double[] yData, int size, boolean linearNotLog) {
        this(xData, yData, size, linearNotLog, false, false);
    }

    public LookupTable(double[] xData, double[] yData, int size, boolean linearNotLog, boolean zeroSlopeAtEndpoints, boolean linearNotCubic) {
        if (xData.length != yData.length) {
            throw new RuntimeException("Both arrays are not the same size in LookupTable");
        }
        if (linearNotLog) {
            int i;
            int len = xData.length;
            this.xMin = xData[0];
            this.xMax = xData[len - 1];
            this.dx = (this.xMax - this.xMin) / (double)(size - 1);
            double[] slope = new double[len];
            double[] y = new double[size];
            double[] dy = new double[size];
            for (i = 1; i < len - 1; ++i) {
                slope[i] = (yData[i + 1] - yData[i - 1]) / (xData[i + 1] - xData[i - 1]);
            }
            if (zeroSlopeAtEndpoints) {
                slope[0] = 0.0;
                slope[len - 1] = 0.0;
            } else {
                slope[0] = slope[1] - (slope[2] - slope[1]) / (xData[2] - xData[1]) * (xData[1] - xData[0]);
                slope[len - 1] = slope[len - 2] + (slope[len - 3] - slope[len - 2]) / (xData[len - 3] - xData[len - 2]) * (xData[len - 2] - xData[len - 1]);
            }
            for (i = 0; i < size - 1; ++i) {
                double x = this.getXValue(i);
                int n = this.lookup(xData, x);
                double[] coeffs = linearNotCubic ? this.solveLinearSpline(xData[n], xData[n + 1], yData[n], yData[n + 1], slope[n], slope[n + 1]) : this.solveCubicSpline(xData[n], xData[n + 1], yData[n], yData[n + 1], slope[n], slope[n + 1]);
                y[i] = this.calcSplineValue(coeffs, x);
                dy[i] = this.calcSplineSlope(coeffs, x);
                if (i != size - 2) continue;
                y[i + 1] = this.calcSplineValue(coeffs, this.getXValue(i + 1));
                dy[i + 1] = this.calcSplineSlope(coeffs, this.getXValue(i + 1));
            }
            this.c = new double[size][4];
            double[] coeffs = new double[4];
            for (int i2 = 0; i2 < size; ++i2) {
                if (i2 < size - 1) {
                    coeffs = linearNotCubic ? this.solveLinearSpline(this.getXValue(i2), this.getXValue(i2 + 1), y[i2], y[i2 + 1], dy[i2], dy[i2 + 1]) : this.solveCubicSpline(this.getXValue(i2), this.getXValue(i2 + 1), y[i2], y[i2 + 1], dy[i2], dy[i2 + 1]);
                }
                this.c[i2][0] = coeffs[0];
                this.c[i2][1] = coeffs[1];
                this.c[i2][2] = coeffs[2];
                this.c[i2][3] = coeffs[3];
            }
        } else {
            throw new RuntimeException("Log not supported yet.");
        }
    }

    @Override
    public double getValue(double x) {
        double[] coeffs = this.c[this.getIndex(x)];
        return this.calcSplineValue(coeffs, x);
    }

    private double calcSplineValue(double[] coeffs, double x) {
        double result = coeffs[3];
        result *= x;
        result += coeffs[2];
        result *= x;
        result += coeffs[1];
        result *= x;
        return result += coeffs[0];
    }

    private int lookup(double[] xs, double x) {
        int i;
        for (i = 0; i < xs.length && !(xs[i] > x); ++i) {
        }
        return i - 1;
    }

    private double calcSplineSlope(double[] coeffs, double x) {
        double result = coeffs[3];
        result *= x;
        result += 2.0 * coeffs[2];
        result *= x;
        return result += coeffs[1];
    }

    private double[] solveCubicSpline(double x0, double x1, double y0, double y1, double dy0, double dy1) {
        double[] result = new double[4];
        double[] c0 = new double[]{Math.pow(x0, 3.0), Math.pow(x1, 3.0), 3.0 * Math.pow(x0, 2.0), 3.0 * Math.pow(x1, 2.0)};
        double[] c1 = new double[]{Math.pow(x0, 2.0), Math.pow(x1, 2.0), 1.0, 1.0};
        double[] c2 = new double[]{x0, x1, 1.0, 1.0};
        double[] c3 = new double[]{1.0, 1.0, 0.0, 0.0};
        double[] y = new double[]{y0, y1, dy0, dy1};
        double detA = this.determinant4(this.columnsToMatrix4(c0, c1, c2, c3));
        result[3] = this.determinant4(this.columnsToMatrix4(y, c1, c2, c3)) / detA;
        result[2] = this.determinant4(this.columnsToMatrix4(c0, y, c2, c3)) / detA;
        result[1] = this.determinant4(this.columnsToMatrix4(c0, c1, y, c3)) / detA;
        result[0] = this.determinant4(this.columnsToMatrix4(c0, c1, c2, y)) / detA;
        return result;
    }

    private double[] solveLinearSpline(double x0, double x1, double y0, double y1, double dy0, double dy1) {
        double[] result = new double[4];
        double[] c0 = new double[]{x0, x1};
        double[] c1 = new double[]{1.0, 1.0};
        double[] y = new double[]{y0, y1};
        double detA = this.determinant2(this.columnsToMatrix2(c0, c1));
        result[3] = 0.0;
        result[2] = 0.0;
        result[1] = this.determinant2(this.columnsToMatrix2(y, c1)) / detA;
        result[0] = this.determinant2(this.columnsToMatrix2(c0, y)) / detA;
        return result;
    }

    private double[][] columnsToMatrix4(double[] c0, double[] c1, double[] c2, double[] c3) {
        if (c0.length != 4 || c1.length != 4 || c2.length != 4 || c3.length != 4) {
            throw new RuntimeException("LookupTable.columnsToMatrix4 requires arrays of 4 elements.");
        }
        double[][] result = new double[4][4];
        for (int i = 0; i < 4; ++i) {
            result[i][0] = c0[i];
            result[i][1] = c1[i];
            result[i][2] = c2[i];
            result[i][3] = c3[i];
        }
        return result;
    }

    private double[][] columnsToMatrix2(double[] c0, double[] c1) {
        if (c0.length != 2 || c1.length != 2) {
            throw new RuntimeException("LookupTable.columnsToMatrix2 requires arrays of 2 elements.");
        }
        double[][] result = new double[2][2];
        for (int i = 0; i < 2; ++i) {
            result[i][0] = c0[i];
            result[i][1] = c1[i];
        }
        return result;
    }

    private double determinant2(double[][] a) {
        if (a[0].length != 2 || a.length != 2) {
            throw new RuntimeException("Matrix input does not have dimensions 2x2");
        }
        return a[0][0] * a[1][1] - a[1][0] * a[0][1];
    }

    private double determinant4(double[][] a) {
        if (a[0].length != 4 || a.length != 4) {
            throw new RuntimeException("Matrix input to determinant4 does not have dimensions 4x4");
        }
        double result = 0.0;
        double sign0 = -1.0;
        for (int i0 = 0; i0 < 4; ++i0) {
            sign0 = -sign0;
            double sign1 = -1.0;
            for (int i1 = 0; i1 < 4; ++i1) {
                if (i1 == i0) continue;
                sign1 = -sign1;
                double sign2 = -1.0;
                for (int i2 = 0; i2 < 4; ++i2) {
                    if (i2 == i1 || i2 == i0) continue;
                    sign2 = -sign2;
                    for (int i3 = 0; i3 < 4; ++i3) {
                        if (i3 == i2 || i3 == i1 || i3 == i0) continue;
                        result += sign0 * sign1 * sign2 * a[0][i0] * a[1][i1] * a[2][i2] * a[3][i3];
                    }
                }
            }
        }
        return result;
    }

    private int getIndex(double x) {
        double temp = x;
        if (temp > this.xMax) {
            temp = this.xMax;
        } else if (temp < this.xMin) {
            temp = this.xMin;
        }
        temp -= this.xMin;
        return (int)(temp /= this.dx);
    }

    private double getXValue(int i) {
        double result = i;
        result *= this.dx;
        return result += this.xMin;
    }
}

