/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import net.sourceforge.jocular.math.Polynomial;
import net.sourceforge.jocular.math.Vector3D;

public class LineToLineDistance {
    private Vector3D m_line1Origin;
    private Vector3D m_line1Dir;
    private Vector3D m_line2Origin;
    private Vector3D m_line2Dir;
    private Polynomial m_curve;

    public LineToLineDistance(Vector3D o1, Vector3D d1, Vector3D o2, Vector3D d2) {
        this.m_line1Origin = o1;
        this.m_line1Dir = d1;
        this.m_line2Origin = o2;
        this.m_line2Dir = d2;
        this.calcCoeffs();
    }

    private void calcCoeffs() {
        Vector3D c1 = this.m_line2Dir.scale(this.m_line2Origin.dot(this.m_line2Dir) - this.m_line1Origin.dot(this.m_line2Dir)).add(this.m_line1Origin).subtract(this.m_line2Origin);
        Vector3D c2 = this.m_line1Dir.subtract(this.m_line2Dir.scale(this.m_line1Dir.dot(this.m_line2Dir)));
        this.m_curve = Polynomial.makeFromCoefficients(new double[]{c2.magSquared(), 2.0 * c1.dot(c2), c1.magSquared()});
    }

    public double distanceAlongLine2(double s1) {
        return (s1 - this.m_line1Dir.dot(this.m_line2Origin) + this.m_line1Dir.dot(this.m_line1Origin)) / this.m_line1Dir.dot(this.m_line2Dir);
    }

    public double distanceAlongLine1(double s2) {
        return this.m_line2Dir.scale(s2).add(this.m_line2Origin).subtract(this.m_line1Origin).dot(this.m_line1Dir);
    }

    public double distanceFromLine1(double s1) {
        return Math.sqrt(this.m_curve.evaluate(s1));
    }

    public double distanceFromLine2(double s2) {
        return this.distanceFromLine1(this.distanceAlongLine1(s2));
    }

    public Polynomial getCurve() {
        return this.m_curve;
    }
}

