/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jocular.math.Complex;
import net.sourceforge.jocular.math.Polynomial;

public class JenkinsAndTraubPolySolver {
    private static final int MAX_TRIES = 40000;
    private int m_iterations = 0;
    static final int NUM_CYCLES = 1000000;

    public Polynomial factorOnce(Polynomial poly) {
        Polynomial k;
        Polynomial dydx = k = poly.derivative();
        Polynomial z = Polynomial.makeFromCoefficients(new double[]{0.0, 1.0});
        Stage stage = Stage.NO_SHIFT;
        boolean notDone = true;
        int iter = 0;
        Complex s1 = null;
        Complex s2 = null;
        double vOld = Double.MAX_VALUE;
        double s = Double.NaN;
        Polynomial sigma = null;
        Polynomial noShiftK = null;
        double ps = Double.MAX_VALUE;
        Polynomial result = null;
        this.m_iterations = 0;
        double epsilon = Math.abs(5.0E-14 * poly.maxCoeff());
        block6: while (notDone && this.m_iterations < 40000) {
            ++iter;
            switch (stage) {
                default: {
                    k = k.subtract(poly.multiplyBy(k.evaluate(0.0) / poly.evaluate(0.0))).dividedBy(z)[0];
                    if (iter <= 5) continue block6;
                    stage = Stage.CHOOSE_SIGMA;
                    noShiftK = k;
                    continue block6;
                }
                case CHOOSE_SIGMA: {
                    double a = Math.random() * 2.0 * Math.PI;
                    double r = Math.random();
                    s1 = new Complex(r * Math.cos(a), r * Math.sin(a));
                    s2 = s1.conjugate();
                    sigma = Polynomial.makeFromComplex(s1);
                    k = noShiftK;
                    stage = Stage.FIXED_SHIFT;
                    iter = 0;
                    ++this.m_iterations;
                    continue block6;
                }
                case FIXED_SHIFT: {
                    k = this.makeNewK23(poly, k, sigma, s1, s2);
                    s = s1.subtract(poly.evaluate(s1).divide(k.evaluate(s1))).real();
                    sigma = this.calcNewQuadSigma(poly, k, s1, s2);
                    double thresh = this.m_iterations < 5 ? 0.5 : (this.m_iterations < 10 ? 0.5 : 0.5);
                    double v = sigma.get(0);
                    if (Math.abs((vOld - v) / v) <= thresh) {
                        stage = Stage.QUADRATIC_VARIABLE_SHIFT;
                        iter = 0;
                        continue block6;
                    }
                    vOld = v;
                    if (iter <= 10 && !sigma.isNan()) continue block6;
                    stage = Stage.CHOOSE_SIGMA;
                    continue block6;
                }
                case QUADRATIC_VARIABLE_SHIFT: {
                    Complex[] cs = sigma.quadraticRoot();
                    s1 = cs[0];
                    s2 = cs[1];
                    if (s1.isReal()) {
                        iter = 0;
                        stage = Stage.LINEAR_VARIABLE_SHIFT;
                        s = s1.real();
                        continue block6;
                    }
                    ps = Math.max(poly.evaluate(s1).divide(dydx.evaluate(s1)).abs(), poly.evaluate(s2).divide(dydx.evaluate(s2)).abs());
                    if (ps < epsilon) {
                        notDone = false;
                        result = sigma;
                        continue block6;
                    }
                    if ((sigma = this.calcNewQuadSigma(poly, k = this.makeNewK23(poly, k, sigma, s1, s2), s1, s2)).isNan()) {
                        stage = Stage.CHOOSE_SIGMA;
                    }
                    if (iter <= 10) continue block6;
                    stage = Stage.CHOOSE_SIGMA;
                    continue block6;
                }
                case LINEAR_VARIABLE_SHIFT: 
            }
            double kc = k.get(k.order());
            ps = poly.evaluate(s);
            double ks = k.evaluate(s);
            if (Math.abs(ps / dydx.evaluate(s)) < epsilon) {
                notDone = false;
                result = Polynomial.makeFromRealRoots(new double[]{s});
                continue;
            }
            k = k.multiplyBy(ps / ks).subtract(poly).dividedBy(Polynomial.makeFromRealRoots(new double[]{s}))[0];
            s -= ps / ks * kc;
            if (iter <= 10) continue;
            stage = Stage.CHOOSE_SIGMA;
        }
        if (this.m_iterations >= 40000) {
            throw new RuntimeException("Failed to solve in " + this.m_iterations + " iterations. " + poly.toArrayString());
        }
        return result;
    }

    private Polynomial makeNewK23(Polynomial poly, Polynomial oldK, Polynomial sigma, Complex s1, Complex s2) {
        Polynomial k = oldK;
        Complex ks1 = k.evaluate(s1);
        Complex ks2 = k.evaluate(s2);
        Complex ps1 = poly.evaluate(s1);
        Complex ps2 = poly.evaluate(s2);
        Complex a = ps1.multiply(ks2).subtract(ps2.multiply(ks1));
        Complex b = ks1.multiply(s2).multiply(ps2).subtract(ks2.multiply(s1).multiply(ps1));
        Complex c = s1.multiply(ps1).multiply(ps2).subtract(ps1.multiply(s2).multiply(ps2));
        Complex k0 = c.divide(a);
        Complex k1 = b.divide(a);
        Polynomial newK = k.multiplyBy(k0.real());
        double[] dArray = new double[]{k1.real(), 1.0};
        Polynomial[] nks = (newK = newK.add(Polynomial.makeFromCoefficients(dArray).multiplyBy(poly))).dividedBy(sigma);
        if (nks[1].evaluate(1.0) > 1.0E-10) {
            // empty if block
        }
        newK = nks[0];
        return newK;
    }

    private Polynomial calcNewQuadSigma(Polynomial poly, Polynomial k, Complex s1, Complex s2) {
        double p0 = poly.evaluate(0.0);
        Polynomial z = Polynomial.makeFromCoefficients(new double[]{0.0, 1.0});
        Polynomial k0 = k;
        Polynomial k1 = k0.subtract(poly.multiplyBy(k0.evaluate(0.0) / p0)).dividedBy(z)[0];
        Polynomial k2 = k1.subtract(poly.multiplyBy(k1.evaluate(0.0) / p0)).dividedBy(z)[0];
        Complex k0s1 = k0.evaluate(s1);
        Complex k1s1 = k1.evaluate(s1);
        Complex k2s1 = k2.evaluate(s1);
        Complex k0s2 = k0.evaluate(s2);
        Complex k1s2 = k1.evaluate(s2);
        Complex k2s2 = k2.evaluate(s2);
        Complex unitCoeff = k0s1.multiply(k1s2).subtract(k0s2.multiply(k1s1));
        Complex zCoeff = k0s2.multiply(k2s1).subtract(k0s1.multiply(k2s2));
        Complex z2Coeff = k1s1.multiply(k2s2).subtract(k2s1.multiply(k1s2));
        Complex den = k1s1.multiply(k2s2).subtract(k2s1.multiply(k1s2));
        double rUnit = unitCoeff.divide(den).real();
        double rZ = zCoeff.divide(den).real();
        double rZ2 = z2Coeff.divide(den).real();
        Polynomial newSigma = Polynomial.makeFromCoefficients(new double[]{rUnit, rZ, rZ2});
        return newSigma;
    }

    public List<Polynomial> factor(Polynomial poly) {
        notNullList result = new notNullList();
        Polynomial p1 = poly;
        double f = p1.get(p1.order());
        if (f != 1.0) {
            p1 = p1.dividedBy(f)[0];
        }
        Polynomial dydx = p1.derivative();
        while (p1.order() > 3) {
            Polynomial[] ps;
            Polynomial p2 = this.factorOnce(p1);
            if (p2.order() == 2) {
                List<Polynomial> rs = p2.quadraticRealRoots();
                for (Polynomial r : rs) {
                    Polynomial r1 = this.refineRoot(poly, dydx, r);
                    result.add(r1);
                    ps = p1.dividedBy(r1);
                    p1 = ps[0];
                }
                continue;
            }
            if (p2.order() == 1) {
                Polynomial r1 = this.refineRoot(poly, dydx, p2);
                result.add(r1);
                ps = p1.dividedBy(r1);
                p1 = ps[0];
                continue;
            }
            throw new RuntimeException("Order is greater than 2. " + p2.order());
        }
        List<Polynomial> rs = p1.cubicRealRoots();
        for (Polynomial r : rs) {
            Polynomial r1 = this.refineRoot(poly, dydx, r);
            result.add(r1);
        }
        if (f != 1.0) {
            result.add(Polynomial.makeFromCoefficients(new double[]{f}));
        }
        return result;
    }

    private Polynomial refineRoot(Polynomial p, Polynomial dydx, Polynomial root) {
        Polynomial result;
        double ex = Double.MAX_VALUE;
        if (root.order() == 1) {
            Complex cr;
            result = root;
            double r = root.linearRoot();
            double e = Math.abs(p.evaluate(r) / dydx.evaluate(r));
            double minErr = e;
            if (minErr > 5.0E-14 && (ex = p.evaluate(cr = p.laguerreSolve(r, 5)).divide(dydx.evaluate(cr)).abs()) < e) {
                minErr = ex;
                r = cr.real();
                result = Polynomial.makeFromRealRoots(new double[]{r});
            }
        } else if (root.order() == 2) {
            Complex[] cs = root.quadraticRoot();
            double ecs0 = p.evaluate(cs[0]).divide(dydx.evaluate(cs[0])).abs();
            double ecs1 = p.evaluate(cs[1]).divide(dydx.evaluate(cs[1])).abs();
            Complex xcs0 = p.laguerreSolve(cs[0], 5);
            Complex xcs1 = p.laguerreSolve(cs[1], 5);
            double excs0 = p.evaluate(xcs0).divide(dydx.evaluate(xcs0)).abs();
            double excs1 = p.evaluate(xcs1).divide(dydx.evaluate(xcs1)).abs();
            if (excs0 < ecs0) {
                cs[0] = xcs0;
            }
            if (excs1 < ecs1) {
                cs[1] = xcs1;
            }
            result = Polynomial.makeFromComplexPair(cs[0], cs[1], true);
        } else if (root.order() == 0) {
            result = root;
        } else {
            throw new RuntimeException("The order of this root is " + root.order());
        }
        return result;
    }

    public static void main(String[] args) {
        JenkinsAndTraubPolySolver s = new JenkinsAndTraubPolySolver();
        Polynomial p1 = Polynomial.makeFromCoefficients(new double[]{-0.5274952329594953, -568.2009600579195, 18.883333836865233, -60.12587795905908, 0.9999999999999999});
        double worst = Double.MIN_NORMAL;
        Polynomial worstP = null;
        double worstRatio = Double.MIN_NORMAL;
        double worstEpsilon = Double.MIN_VALUE;
        double worstDx = Double.MIN_NORMAL;
        long startTime = System.currentTimeMillis();
        boolean firstPoly = true;
        for (int i = 0; i < 1000000; ++i) {
            if (i % 10000 == 0) {
                System.out.println("JenkinsAndTraubPolySolver.main done " + i + " so far.");
            }
            List<Polynomial> ps = s.factor(p1);
            if (firstPoly) {
                System.out.println("First poly solved in " + s.getIterations() + " iterations.");
            }
            firstPoly = false;
            boolean firstTime = true;
            Polynomial test = Polynomial.UNIT;
            Polynomial dp1dx = p1.derivative();
            for (Polynomial p : ps) {
                double dx;
                if (!firstTime) {
                    // empty if block
                }
                test = test.multiplyBy(p);
                if (p.order() == 1) {
                    double x = p.linearRoot();
                    dx = p1.evaluate(x) / dp1dx.evaluate(x);
                } else if (p.order() == 2) {
                    Complex[] xs = p.quadraticRoot();
                    double dx1 = p1.evaluate(xs[0]).abs() / dp1dx.evaluate(xs[0].abs());
                    double dx2 = p1.evaluate(xs[1]).abs() / dp1dx.evaluate(xs[1].abs());
                    dx = Math.max(dx1, dx2);
                } else {
                    dx = 0.0;
                }
                if (!(dx > worstDx)) continue;
                worstDx = dx;
            }
            double epsilon = p1.maxCoeff() * 5.0E-14;
            if (p1.distance(test) > worst) {
                worst = p1.distance(test);
                worstP = p1;
                worstEpsilon = epsilon;
            }
            if (p1.distance(test) / epsilon > worstRatio) {
                worstRatio = p1.distance(test) / epsilon;
            }
            if (p1.distance(test) > epsilon) {
                // empty if block
            }
            p1 = Polynomial.makeRandom(6, 1000.0);
        }
        double polyPerSecond = 1.0 / ((double)(System.currentTimeMillis() - startTime) / 1000000.0 / 1000.0);
        System.out.println("JenkinsAndTraubPolySolver.main poly per second: " + polyPerSecond);
        System.out.println("JenkinsAndTraubPolySolver.main worst dx: " + worstDx);
        System.out.println("JenkinsAndTraubPolySolver.main worst error: " + worst + ", epsilon: " + worstEpsilon + " from poly " + worstP.toArrayString());
        System.out.println("JenkinsAndTraubPolySolver.main worst ratio: " + worstRatio);
    }

    public int getIterations() {
        return this.m_iterations;
    }

    private class notNullList
    extends ArrayList<Polynomial> {
        private notNullList() {
        }

        @Override
        public boolean add(Polynomial p) {
            if (p == null) {
                throw new RuntimeException("Element to add is null.");
            }
            return super.add(p);
        }
    }

    private static enum Stage {
        NO_SHIFT,
        FIXED_SHIFT,
        CHOOSE_SIGMA,
        LINEAR_VARIABLE_SHIFT,
        QUADRATIC_VARIABLE_SHIFT;

    }
}

