/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import Jama.Matrix;
import net.sourceforge.jocular.math.Polynomial;

public class CubicFit {
    Polynomial m_fit;

    public void fit(double[] x, double[] y) {
        double[][] xs = new double[x.length][4];
        for (int i = 0; i < x.length; ++i) {
            xs[i][3] = Math.pow(x[i], 3.0);
            xs[i][2] = Math.pow(x[i], 2.0);
            xs[i][2] = x[i];
            xs[i][0] = 1.0;
        }
        Matrix my = new Matrix(y, y.length);
        Matrix mxs = new Matrix(xs);
        Matrix mxst = mxs.transpose();
        Matrix mi = mxst.times(mxs).inverse();
        Matrix mc = mi.times(mxst).times(my);
        this.m_fit = Polynomial.makeFromCoefficients(mc.getRowPackedCopy());
    }

    public double getValue(double x) {
        return this.m_fit.evaluate(x);
    }

    public double getMin(double xMin, double xMax) {
        double a = this.m_fit.get(3);
        double b = this.m_fit.get(2);
        double c = this.m_fit.get(1);
        double x = xMin;
        double sqr = 4.0 * b * b - 12.0 * a * c;
        if (sqr > 0.0) {
            double t2 = Math.sqrt(sqr) / 6.0 / a;
            double t1 = -b / 3.0 / a;
            double x1 = t1 + t2;
            double x2 = t1 - t2;
            if (x1 >= xMin && x1 <= xMax) {
                x = x1;
            } else if (x2 >= xMin && x2 <= xMax) {
                x = x2;
            }
        }
        double yMin = this.getValue(xMin);
        double yMax = this.getValue(xMax);
        double yX = this.getValue(x);
        if (!(yX < yMin) || !(yX < yMax)) {
            if (yMin < yX && yMin < yMax) {
                x = xMin;
            } else if (yMax < yX && yMax < yMin) {
                x = xMax;
            }
        }
        return x;
    }
}

