/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.math;

import java.text.DecimalFormat;

public class Complex {
    private static final double EPSILON = 1.0E-25;
    private final double m_real;
    private final double m_imag;

    public Complex(double rp) {
        this.m_real = rp;
        this.m_imag = 0.0;
    }

    public Complex(double rp, double ip) {
        this.m_real = rp;
        this.m_imag = ip;
    }

    public Complex add(Complex c) {
        return new Complex(this.m_real + c.m_real, this.m_imag + c.m_imag);
    }

    public Complex add(double d) {
        return new Complex(this.m_real + d, this.m_imag);
    }

    public Complex sqr() {
        return this.multiply(this);
    }

    public Complex subtract(Complex c) {
        return new Complex(this.m_real - c.m_real, this.m_imag - c.m_imag);
    }

    public Complex subtract(double d) {
        return new Complex(this.m_real - d, this.m_imag);
    }

    public Complex multiply(Complex c) {
        return new Complex(this.m_real * c.m_real - this.m_imag * c.m_imag, this.m_imag * c.m_real + this.m_real * c.m_imag);
    }

    public Complex multiply(double d) {
        return new Complex(this.m_real * d, this.m_imag * d);
    }

    public Complex neg() {
        return new Complex(-this.m_real, -this.m_imag);
    }

    public Complex divide(Complex c) {
        double r = this.m_real * c.m_real + this.m_imag * c.m_imag;
        double i = this.m_imag * c.m_real - this.m_real * c.m_imag;
        double d = c.m_real * c.m_real + c.m_imag * c.m_imag;
        return new Complex(r / d, i / d);
    }

    public Complex divide(double d) {
        double r = this.m_real / d;
        double i = this.m_imag / d;
        return new Complex(r, i);
    }

    public Complex rootn(double n) {
        double abs = this.abs();
        double arg = this.arg();
        return Complex.complexFromPolar(Math.pow(abs, 1.0 / n), arg / n);
    }

    public Complex sqrt() {
        if (this.m_imag == 0.0 && this.m_real > 0.0) {
            return new Complex(Math.sqrt(this.m_real), 0.0);
        }
        double abs = Math.sqrt(this.abs());
        double arg = this.arg() / 2.0;
        return Complex.complexFromPolar(abs, arg);
    }

    public double abs() {
        return Math.sqrt(this.m_real * this.m_real + this.m_imag * this.m_imag);
    }

    public double arg() {
        return Math.atan2(this.m_imag, this.m_real);
    }

    public static Complex complexFromPolar(double r, double a) {
        return new Complex(r * Math.cos(a), r * Math.sin(a));
    }

    public double absSq() {
        return this.m_real * this.m_real + this.m_imag * this.m_imag;
    }

    public double real() {
        return this.m_real;
    }

    public double imag() {
        return this.m_imag;
    }

    public Complex onlyReal() {
        return new Complex(this.m_real, 0.0);
    }

    public Complex onlyImag() {
        return new Complex(0.0, this.m_imag);
    }

    public boolean isNaN() {
        return Double.isNaN(this.m_real + this.m_imag);
    }

    public Complex conjugate() {
        return new Complex(this.m_real, -this.m_imag);
    }

    public String toString() {
        DecimalFormat df = new DecimalFormat("0.####E0");
        if (this.isNaN()) {
            return "(NaN)";
        }
        Object ip = df.format(this.m_imag);
        if (((String)ip).equals("0") || ((String)ip).equals("-0")) {
            ip = "";
        } else if (((String)(ip = (String)ip + "*i")).substring(0, 1).equals("-")) {
            ip = " " + (String)ip;
        } else if (!((String)ip).equals("")) {
            ip = " +" + (String)ip;
        }
        return "(" + df.format(this.m_real) + (String)ip + ")";
    }

    public boolean isReal() {
        if (this.m_imag == 0.0) {
            return true;
        }
        if (this.m_real == 0.0) {
            return false;
        }
        return Math.abs(this.m_imag / this.m_real) < 1.0E-25;
    }
}

