/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.materials;

import java.util.Random;
import net.sourceforge.jocular.imager.OpticsColour;
import net.sourceforge.jocular.materials.BoroSilicate;
import net.sourceforge.jocular.materials.Calcite;
import net.sourceforge.jocular.materials.F2Material;
import net.sourceforge.jocular.materials.Lbal35;
import net.sourceforge.jocular.materials.MagnesiumFluoride;
import net.sourceforge.jocular.materials.Nbk7;
import net.sourceforge.jocular.materials.Nsf18;
import net.sourceforge.jocular.materials.Nsf2;
import net.sourceforge.jocular.materials.Nsf5;
import net.sourceforge.jocular.materials.Nsk2;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.materials.Polycarbonate;
import net.sourceforge.jocular.materials.Sf10Material;
import net.sourceforge.jocular.materials.ShinyMetal;
import net.sourceforge.jocular.materials.Topas5013LS10;
import net.sourceforge.jocular.materials.Vacuum;
import net.sourceforge.jocular.math.FunctionOfX;
import net.sourceforge.jocular.math.MultiProbabilityResolver;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.Polarization;
import net.sourceforge.jocular.positioners.AxisPositioner;
import net.sourceforge.jocular.positioners.ObjectPositioner;

public class SimpleOpticalMaterial
implements OpticalMaterial {
    public static final SimpleOpticalMaterial BOROSILICATE = new BoroSilicate();
    public static final SimpleOpticalMaterial N_BK7 = new Nbk7();
    public static final SimpleOpticalMaterial MAGNESIUM_FLUORIDE = new MagnesiumFluoride();
    public static final SimpleOpticalMaterial VACUUM = new Vacuum();
    public static final SimpleOpticalMaterial SF10 = new Sf10Material();
    public static final SimpleOpticalMaterial POLYCARBONATE = new Polycarbonate();
    public static final SimpleOpticalMaterial CALCITE = new Calcite();
    public static final SimpleOpticalMaterial TOPAS5013LS = new Topas5013LS10();
    public static final SimpleOpticalMaterial SHINYMETAL = new ShinyMetal();
    public static final SimpleOpticalMaterial F2 = new F2Material();
    public static final SimpleOpticalMaterial LBAL35 = new Lbal35();
    public static final SimpleOpticalMaterial N_SF5 = new Nsf5();
    public static final SimpleOpticalMaterial N_SF2 = new Nsf2();
    public static final SimpleOpticalMaterial N_SK2 = new Nsk2();
    public static final SimpleOpticalMaterial SF18 = new Nsf18();
    protected final FunctionOfX m_refractiveIndexOrdinary;
    protected final FunctionOfX m_refractiveIndexEx;
    protected final FunctionOfX m_transmissivity;
    protected final FunctionOfX m_scatteringCoefficient;
    private static final Random random = new Random(0L);

    public SimpleOpticalMaterial(FunctionOfX refractiveIndex, FunctionOfX transmissivity, FunctionOfX scatteringCoeff) {
        this.m_refractiveIndexOrdinary = refractiveIndex;
        this.m_refractiveIndexEx = null;
        this.m_transmissivity = transmissivity;
        this.m_scatteringCoefficient = scatteringCoeff;
    }

    public SimpleOpticalMaterial(FunctionOfX nO, FunctionOfX nE, FunctionOfX transmissivity, FunctionOfX scatteringCoeff) {
        this.m_refractiveIndexOrdinary = nO;
        this.m_refractiveIndexEx = nE;
        this.m_transmissivity = transmissivity;
        this.m_scatteringCoefficient = scatteringCoeff;
    }

    @Override
    public double getOrdinaryRefractiveIndex(double wavelength) {
        return this.m_refractiveIndexOrdinary.getValue(wavelength);
    }

    @Override
    public double getExtraordinaryRefractiveIndex(double wavelength) {
        if (this.isIsotropic()) {
            return this.m_refractiveIndexOrdinary.getValue(wavelength);
        }
        return this.m_refractiveIndexEx.getValue(wavelength);
    }

    @Override
    public double getTransmissivity(double wavelength, Vector3D polarizationAngle, ObjectPositioner materialPositioner) {
        double result = this.m_transmissivity.getValue(wavelength);
        if (result < 0.0) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public double getScatteringCoeff(double wavelength, Vector3D polarizationAngle, ObjectPositioner materialPositioner) {
        double result = 1.0;
        if (this.m_scatteringCoefficient != null && (result = this.m_scatteringCoefficient.getValue(wavelength)) < 0.0) {
            result = 0.0;
        }
        return result;
    }

    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        Photon input = pt.getPhoton();
        Vector3D p = pi.getLocation();
        Vector3D pStart = input.getOrigin();
        double d = p.subtract(pStart).abs();
        double pA1mm = 1.0 - this.m_transmissivity.getValue(input.getWavelength());
        double pS1mm = 0.0;
        if (this.m_scatteringCoefficient != null) {
            pS1mm = 1.0 - this.m_scatteringCoefficient.getValue(input.getWavelength());
        }
        double pT1mm = 1.0 - pA1mm - pS1mm;
        double pTd = Math.pow(pT1mm, d / 0.001);
        double pR = 0.0;
        if (pT1mm < 1.0) {
            pR = (1.0 - pTd) / (1.0 - pT1mm);
        }
        double pSd = pR * pS1mm;
        double pAd = pR * pA1mm;
        MultiProbabilityResolver<Photon.PhotonSource> pr = new MultiProbabilityResolver<Photon.PhotonSource>(new Photon.PhotonSource[]{Photon.PhotonSource.ABSORBED, Photon.PhotonSource.SCATTERED, Photon.PhotonSource.TRANSMITTED}, new double[]{pAd, pSd, pTd});
        switch (pr.getChosenKey()) {
            default: {
                System.out.println("SimpleOpticalMaterial.interact: " + this.toString() + "absorbing photon.");
                pt.absorb(d * pr.getRelativeChoiceValue(), input.getContainingObject());
                break;
            }
            case SCATTERED: {
                Vector3D pDir = new Vector3D(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5).normalize();
                Vector3D pTrans = new Vector3D(random.nextDouble() - 0.5, random.nextDouble() - 0.5, random.nextDouble() - 0.5);
                pTrans = pTrans.getPerpendicularComponent(pDir).normalize();
                Vector3D pOrtho = Vector3D.getOrtho(pDir, pTrans);
                double pPolMagTrans = random.nextDouble();
                double pPolMagOrtho = Math.sqrt(1.0 - pPolMagTrans * pPolMagTrans);
                Photon pOld = pt.getPhoton();
                Polarization pPolOld = pOld.getPolarization();
                Polarization pPol = new Polarization(pTrans, pOrtho, pPolMagTrans, pPolMagOrtho, pPolOld.getPhaseA(), pPolOld.getPhaseB());
                double dNew = pr.getRelativeChoiceValue() * d;
                Vector3D pOrg = pi.getLocation().subtract(pOld.getDirection().scale(dNew));
                Photon newP = new Photon(pOrg, pDir, pOld.getWavelength(), pPol, Photon.PhotonSource.SCATTERED, pOld.getIntensity(), input.getContainingObject());
                PhotonInteraction newPi = new PhotonInteraction(pt.getPhoton(), pOrg, input.getContainingObject(), pDir, "Scattered.");
                pt.addPhoton(newP, newPi);
                break;
            }
            case TRANSMITTED: {
                double dPhase;
                Polarization pol;
                double w = input.getWavelength();
                if (!this.isIsotropic()) {
                    Vector3D trans = pi.getInteractingObject().getPositioner().getTransDirection();
                    pol = input.getPolarization().resolveOntoAxis(trans);
                    dPhase = pol.getMagA() > 0.0 ? d / w * 2.0 * Math.PI * this.m_refractiveIndexEx.getValue(w) : d / w * 2.0 * Math.PI * this.m_refractiveIndexOrdinary.getValue(w);
                } else {
                    pol = input.getPolarization();
                    dPhase = d / w * 2.0 * Math.PI * this.m_refractiveIndexOrdinary.getValue(w);
                }
                Polarization polTranslated = new Polarization(pol.getDirA(), pol.getDirB(), pol.getMagA(), pol.getMagB(), pol.getPhaseA() + dPhase, pol.getPhaseB() + dPhase);
                Photon newP = new Photon(p, input.getDirection(), input.getWavelength(), polTranslated, Photon.PhotonSource.TRANSMITTED, input.getIntensity(), input.getContainingObject());
                PhotonInteraction newPi = new PhotonInteraction(pt.getPhoton(), p, input.getContainingObject(), input.getDirection(), "Transmitted.");
                pt.addPhoton(newP, newPi);
            }
        }
    }

    @Override
    public OpticsColour getColour() {
        return OpticsColour.RED;
    }

    @Override
    public boolean isIsotropic() {
        return this.m_refractiveIndexEx == null;
    }

    public String makeCsv() {
        AxisPositioner p = new AxisPositioner();
        Object result = "wavelength (m), No, Ne, Internal Transmittance for 1mm, Scattering coefficient for 1mm\n";
        for (double wl = 1.0E-7; wl < 5.0E-6; wl *= 1.02) {
            double no = this.getOrdinaryRefractiveIndex(wl);
            double ne = this.getExtraordinaryRefractiveIndex(wl);
            double t = this.getTransmissivity(wl, Vector3D.Y_AXIS, p);
            double s = this.getScatteringCoeff(wl, Vector3D.Y_AXIS, p);
            result = (String)result + wl;
            result = (String)result + ", ";
            result = (String)result + no;
            result = (String)result + ", ";
            result = (String)result + ne;
            result = (String)result + ", ";
            result = (String)result + t;
            result = (String)result + ", ";
            result = (String)result + s;
            result = (String)result + "\n";
        }
        return result;
    }
}

