/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.imager;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import javafx.scene.paint.Color;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.Polarization;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.sources.HemiPointSource;

public class OpticsColour {
    protected static final double IR_W = 7.0E-7;
    protected static final double RED_W = 6.25E-7;
    protected static final double YELLOW_W = 5.5E-7;
    protected static final double GREEN_W = 5.25E-7;
    protected static final double CYAN_W = 4.8E-7;
    protected static final double BLUE_W = 4.5E-7;
    protected static final double VIOLET_W = 4.0E-7;
    protected static final double UV_W = 2.0E-7;
    public static final OpticsColour RED = new OpticsColour(1.0, 0.0, 0.0);
    public static final OpticsColour GREEN = new OpticsColour(0.0, 1.0, 0.0);
    public static final OpticsColour BLUE = new OpticsColour(0.0, 0.0, 1.0);
    public static final OpticsColour WHITE = new OpticsColour(1.0, 1.0, 1.0);
    public static final OpticsColour BLACK = new OpticsColour(0.0, 0.0, 0.0);
    public static final OpticsColour CYAN = new OpticsColour(0.0, 1.0, 1.0);
    public static final OpticsColour MAGENTA = new OpticsColour(1.0, 0.0, 1.0);
    public static final OpticsColour DARK_MAGENTA = new OpticsColour(0.5, 0.0, 0.5);
    public static final OpticsColour YELLOW = new OpticsColour(1.0, 1.0, 0.0);
    public static final OpticsColour ORANGE = new OpticsColour(1.0, 0.5, 0.0);
    public static final OpticsColour GREY = new OpticsColour(0.5, 0.5, 0.5);
    public static final OpticsColour DARK_GREY = new OpticsColour(0.25, 0.25, 0.25);
    public static final OpticsColour PINK = new OpticsColour(1.0, 0.5, 0.5);
    private static final OpticsColour[] SEQUENCE = OpticsColour.getColourSequence();
    private double m_red = 0.0;
    private double m_green = 0.0;
    private double m_blue = 0.0;
    private double m_alpha = 1.0;
    private static final Random m_random = new Random();

    public OpticsColour(int red, int green, int blue) {
        this(red, green, blue, 255);
    }

    public OpticsColour(int red, int green, int blue, int alpha) {
        this((double)red / 255.0, (double)green / 255.0, (double)blue / 255.0, (double)alpha / 255.0);
    }

    public OpticsColour(double red, double green, double blue) {
        this(red, green, blue, 1.0);
    }

    public OpticsColour(double red, double green, double blue, double alpha) {
        this.m_red = red;
        this.m_green = green;
        this.m_blue = blue;
        this.m_alpha = alpha;
        if (this.m_red > 1.0) {
            throw new RuntimeException("Red (" + red + ") is > 1.0");
        }
        if (this.m_green > 1.0) {
            throw new RuntimeException("Green (" + green + ") is > 1.0");
        }
        if (this.m_blue > 1.0) {
            throw new RuntimeException("Blue (" + blue + ") is > 1.0");
        }
        if (!Double.isFinite(this.m_red + this.m_green + this.m_blue)) {
            throw new RuntimeException("A value is not finite.");
        }
    }

    public double getAlpha() {
        return this.m_alpha;
    }

    public double getRed() {
        return this.m_red;
    }

    public double getGreen() {
        return this.m_green;
    }

    public double getBlue() {
        return this.m_blue;
    }

    public Color getFxColor() {
        return new Color(this.m_red, this.m_green, this.m_blue, this.m_alpha);
    }

    public java.awt.Color getAwtColor() {
        return new java.awt.Color((float)this.m_red, (float)this.m_green, (float)this.m_blue);
    }

    public java.awt.Color getColour() {
        return new java.awt.Color((float)this.m_red, (float)this.m_green, (float)this.m_blue);
    }

    public static OpticsColour getColorFromWavelength(double w, double wfwhm) {
        double sd = wfwhm * HemiPointSource.STDEV_OVER_FWHM;
        if (sd == 0.0) {
            return OpticsColour.getColorFromWavelength(w);
        }
        double r = 0.0;
        double g = 0.0;
        double b = 0.0;
        int n = 1000;
        Random random = new Random();
        for (int i = 0; i < n; ++i) {
            double w2 = w + random.nextGaussian() * sd;
            OpticsColour c = OpticsColour.getColorFromWavelength(w2);
            if (Double.isFinite((r += c.getRed()) + (g += c.getGreen()) + (b += c.getBlue()))) continue;
            throw new RuntimeException("Is NaN!");
        }
        double m = Math.max(r, Math.max(g, b));
        if (m > 0.0) {
            r /= m;
            g /= m;
            b /= m;
        }
        return new OpticsColour(r, g, b);
    }

    public static OpticsColour getColorFromWavelength(double w) {
        double m;
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        double[] r1Coeff = new double[]{1.0281E21, -2.0444E15, 1.343E9, -290.97};
        double[] r2Coeff = new double[]{-4.5752E21, 5.5868E15, -2.2649E9, 304.95};
        double[] gCoeff = new double[]{-1.7498E19, -8.8893E13, 1.1016E8, -30.044};
        double[] bCoeff = new double[]{-1.0889E21, 1.2198E15, -4.3481E8, 48.758};
        if (w > 5.3E-7 && w < 7.0E-7) {
            red = OpticsColour.getPosCubicValue(r1Coeff, w);
        } else if (w > 3.8E-7 && w < 5.2E-7) {
            red = 2.0 * OpticsColour.getPosCubicValue(r2Coeff, w);
        }
        if (w > 4.5E-7 && w < 6.2E-7) {
            green = OpticsColour.getPosCubicValue(gCoeff, w);
        }
        if (w > 3.8E-7 && w < 5.1E-7) {
            blue = OpticsColour.getPosCubicValue(bCoeff, w);
        }
        if (!Double.isFinite(m = Math.max(red, Math.max(green, blue)))) {
            throw new RuntimeException("NaN!");
        }
        if (!Double.isFinite(red + blue + green)) {
            throw new RuntimeException("NaN!");
        }
        m = m > 0.0 ? 1.0 / m : 1.0;
        return new OpticsColour(red *= m, green *= m, blue *= m);
    }

    private static double getPosCubicValue(double[] coeffs, double x) {
        double result = coeffs[0];
        result *= x;
        result += coeffs[1];
        result *= x;
        result += coeffs[2];
        result *= x;
        if ((result += coeffs[3]) < 0.0) {
            result = 0.0;
        } else if (result > 1.0) {
            result = 1.0;
        }
        return result;
    }

    public static OpticsColour getColorFromWavelengthOld(double w) {
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        if (w < 2.0E-7) {
            red = 0.5;
            blue = 0.5;
        } else if (w < 4.0E-7) {
            red = 0.5;
            blue = 1.0 - 0.5 * (4.0E-7 - w) / 2.0E-7;
        } else if (w < 4.5E-7) {
            blue = 1.0;
            red = 0.5 * (4.5E-7 - w) / 5.0E-8;
        } else if (w < 4.8E-7) {
            blue = 1.0;
            green = 1.0 - (4.8E-7 - w) / 2.999999999999998E-8;
        } else if (w < 5.25E-7) {
            green = 1.0;
            blue = (5.25E-7 - w) / 4.499999999999999E-8;
        } else if (w < 5.5E-7) {
            green = 1.0;
            red = (w - 5.25E-7) / 2.5000000000000078E-8;
        } else if (w < 6.25E-7) {
            red = 1.0;
            green = (6.25E-7 - w) / 7.500000000000002E-8;
        } else {
            red = w < 7.0E-7 ? 0.5 + (7.0E-7 - w) / 7.499999999999992E-8 / 2.0 : 0.5;
        }
        return new OpticsColour(red, green, blue);
    }

    public static OpticsColour getColourFromPolarization(Polarization pol) {
        double red = 0.0;
        double green = 0.0;
        double blue = 0.0;
        Polarization pa = pol.resolveOntoAxis(Vector3D.Y_AXIS);
        red = pa.getMagA();
        green = pa.getMagB();
        return new OpticsColour(red, green, blue);
    }

    private static OpticsColour[] getColourSequence() {
        ArrayList<OpticsColour> result = new ArrayList<OpticsColour>();
        double step = 0.1;
        for (double red = 0.0; red <= 1.0; red += step) {
            for (double green = 0.0; green <= 1.0; green += step) {
                for (double blue = 0.0; blue <= 1.0; blue += step) {
                    result.add(new OpticsColour(red, green, blue));
                }
            }
        }
        Collections.shuffle(result, new Random(2L));
        return result.toArray(new OpticsColour[result.size()]);
    }

    public static OpticsColour getColour(PhotonTrajectory pt, int i, OutputPanel.PhotonRenderColour pc) {
        OpticsColour result;
        Photon p = pt.getPhoton(i);
        OpticsColour[] cs = SEQUENCE;
        int m = 0;
        switch (pc) {
            default: {
                m = OpticsColour.hashInt(i, cs.length);
                result = cs[m];
                break;
            }
            case WAVELENGTH: {
                double w = p.getWavelength();
                result = OpticsColour.getColorFromWavelength(w);
                break;
            }
            case SOURCE_NUM: {
                m = 0;
                if (p != null) {
                    m = pt.getInteraction(0).getFromObject().hashCode();
                    m = OpticsColour.hashInt(m, cs.length);
                }
                result = cs[m];
                break;
            }
            case POLARIZATION: {
                result = OpticsColour.getColourFromPolarization(p.getPolarization());
                break;
            }
            case IN_OBJECT: {
                OpticsObject o = p.getContainingObject();
                m = 0;
                if (o != null) {
                    m = o.hashCode();
                    m = OpticsColour.hashInt(m, cs.length);
                }
                result = cs[m];
                break;
            }
            case MATERIAL: {
                OpticalMaterial mat = pt.getMaterial(i);
                m = MaterialProperty.MaterialKey.getKey(mat).ordinal();
                m = OpticsColour.hashInt(m, cs.length);
                result = cs[m];
                break;
            }
            case PHOTON_SOURCE: {
                m = p.getPhotonSource().ordinal();
                result = cs[m %= cs.length];
            }
        }
        return result;
    }

    private static int hashInt(int seed, int range) {
        m_random.setSeed(seed);
        return m_random.nextInt(range);
    }

    public OpticsColour makeBright(double brightness) {
        double r = this.m_red;
        double g = this.m_green;
        double b = this.m_blue;
        double abs = Math.max(r, Math.max(g, b));
        if (abs == 0.0) {
            r = brightness;
            g = brightness;
            b = brightness;
        } else {
            double k = brightness / abs;
            r *= k;
            g *= k;
            b *= k;
        }
        if (r > 1.0) {
            r = 1.0;
        }
        if (b > 1.0) {
            b = 1.0;
        }
        if (g > 1.0) {
            g = 1.0;
        }
        return new OpticsColour(r, g, b);
    }

    public int getIntRgb() {
        int r = (int)Math.round(this.m_red * 255.0);
        int g = (int)Math.round(this.m_green * 255.0);
        int b = (int)Math.round(this.m_blue * 255.0);
        int result = 0xFF000000 | r << 16 | g << 8 | b;
        return result;
    }
}

