/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.imager;

import net.sourceforge.jocular.imager.ColourPoint;
import net.sourceforge.jocular.imager.OpticsColour;
import net.sourceforge.jocular.imager.Pixel;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.Polarization;

public class MonoPixel
implements Pixel {
    private ColourPoint m_point = new ColourPoint();

    @Override
    public void clear() {
        this.m_point = new ColourPoint();
    }

    @Override
    public void addPhoton(Photon photon, Vector3D trans) {
        Polarization p = photon.getPolarization().rotate(trans);
        double w = photon.getWavelength();
        double i = photon.getIntensity();
        double energy = 1.98644568E-25 / w;
        this.m_point.addPhoton(energy * i, p);
    }

    @Override
    public double getMaxMagnitude() {
        return this.m_point.getMagnitude();
    }

    @Override
    public double getMaxValue() {
        return this.m_point.getValue();
    }

    @Override
    public OpticsColour getNormalColour() {
        double red;
        double green = red = this.m_point.getMagnitude();
        double blue = red;
        double max = red;
        OpticsColour oc = new OpticsColour(red / max, green / max, blue / max);
        return oc;
    }

    @Override
    public int getRGBMagnitude(double scale) {
        int red;
        int green = red = (int)(this.m_point.getMagnitude() / scale * 255.0);
        int blue = red;
        return red << 16 | green << 8 | blue;
    }

    @Override
    public int getRGBValue(double scale) {
        int red;
        int green = red = (int)(this.m_point.getValue() / scale * 255.0);
        int blue = red;
        return red << 16 | green << 8 | blue;
    }

    @Override
    public double getRed(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_point.getValue();
        }
        return this.m_point.getMagnitude();
    }

    @Override
    public double getBlue(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_point.getValue();
        }
        return this.m_point.getMagnitude();
    }

    @Override
    public double getGreen(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_point.getValue();
        }
        return this.m_point.getMagnitude();
    }

    @Override
    public void addColourPoints(ColourPoint[] cps) {
        if (cps.length == 1) {
            this.m_point.addColourPoint(cps[0]);
        }
    }

    @Override
    public ColourPoint[] getColourPoints() {
        return new ColourPoint[]{this.m_point};
    }
}

