/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.imager;

import java.awt.image.BufferedImage;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.jocular.imager.ColourPixel;
import net.sourceforge.jocular.imager.ColourPoint;
import net.sourceforge.jocular.imager.MonoPixel;
import net.sourceforge.jocular.imager.Pixel;
import net.sourceforge.jocular.math.Complex;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.objects.AbstractOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OutputObject;
import net.sourceforge.jocular.photons.InteractionSorter;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.PhotonInteraction;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.OffsetPositioner;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.IntegerProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.settings.Settings;

public class Imager
extends AbstractOpticsObject
implements OutputObject {
    private final ArrayList<Pixel> m_pixels = new ArrayList();
    private EquationProperty m_xSize = new EquationProperty(0.01);
    private EquationProperty m_ySize = new EquationProperty(0.01);
    private IntegerProperty m_xDim = new IntegerProperty("100");
    private IntegerProperty m_yDim = new IntegerProperty("100");
    private EnumProperty m_pixelType = new EnumProperty(PixelType.MONO, PixelType.MONO.name());
    private BooleanProperty m_absorbPhotons = new BooleanProperty("true");
    private double m_maxPixelValue;
    private double m_maxPixelMagnitude;

    public Imager() {
        this.setPositioner(new OffsetPositioner());
        this.updateDimensions();
    }

    protected void updateDimensions() {
        this.m_pixels.clear();
        this.m_maxPixelValue = 0.0;
        this.m_maxPixelMagnitude = 0.0;
        for (int x = 0; x < this.m_xDim.getValue(); ++x) {
            for (int y = 0; y < this.m_yDim.getValue(); ++y) {
                if (this.m_pixelType.getValue() == PixelType.COLOUR) {
                    this.m_pixels.add(new ColourPixel());
                    continue;
                }
                this.m_pixels.add(new MonoPixel());
            }
        }
    }

    @Override
    public OpticsObject makeCopy() {
        Imager result = new Imager();
        result.copyProperties(this);
        result.setPositioner(this.getPositioner().makeCopy());
        return result;
    }

    @Override
    public void getPossibleInteraction(PhotonTrajectory pt, InteractionSorter is) {
        Photon p = pt.getPhoton();
        Vector3D intersection = Vector3D.INF;
        Vector3D yDir = this.getPositioner().getTransDirection();
        Vector3D xDir = Vector3D.getTrans(this.getPositioner().getDirection(), yDir);
        Vector3D distToImagerOrigin = this.getPositioner().getOrigin().subtract(p.getOrigin());
        Vector3D alongImagerNormal = distToImagerOrigin.getParallelComponent(this.getPositioner().getDirection());
        double d = alongImagerNormal.magSquared() / alongImagerNormal.dot(p.getDirection());
        if (d > 0.0) {
            Vector3D vectToImagerPlane = p.getDirection().scale(d);
            Vector3D pointOnImagerPlane = vectToImagerPlane.add(p.getOrigin());
            Vector3D distAlongPlane = pointOnImagerPlane.subtract(this.getPositioner().getOrigin());
            double yDist = yDir.dot(distAlongPlane);
            double xDist = xDir.dot(distAlongPlane);
            if (Math.abs(yDist) < this.m_ySize.getValue().getBaseUnitValue() / 2.0 && Math.abs(xDist) < this.m_xSize.getValue().getBaseUnitValue() / 2.0) {
                intersection = pointOnImagerPlane;
            }
        }
        is.add(new PhotonInteraction(p, this, null, intersection, null, ""));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void interact(PhotonInteraction pi, PhotonTrajectory pt) {
        Vector3D yDir = this.getPositioner().getTransDirection();
        Vector3D xDir = this.getPositioner().getDirection().cross(yDir);
        Vector3D distAlongPlane = pi.getLocation().subtract(this.getPositioner().getOrigin());
        double yDist = yDir.dot(distAlongPlane);
        double xDist = xDir.dot(distAlongPlane);
        int y = this.convertToYPixelLocation(yDist);
        int x = this.convertToXPixelLocation(xDist);
        Pixel hitPixel = this.getPixel(x, y);
        if (hitPixel == null) {
            throw new RuntimeException("Photon missed imager.");
        }
        Imager imager = this;
        synchronized (imager) {
            hitPixel.addPhoton(pt.getPhoton(), this.getPositioner().getTransDirection());
            this.updateMaxValue(hitPixel);
        }
        if (this.m_absorbPhotons.getValue().booleanValue()) {
            pt.absorb(0.0, this);
        } else {
            Photon p = pt.getPhoton();
            Photon nP = new Photon(pi.getLocation(), p.getDirection(), p.getWavelength(), p.getPolarization(), Photon.PhotonSource.UNCHANGED, p.getIntensity(), p.getContainingObject());
            pt.addPhoton(new Photon(nP), pi);
        }
    }

    private int convertToXPixelLocation(double dist) {
        double xDist = dist + this.m_xSize.getValue().getBaseUnitValue() / 2.0;
        xDist /= this.m_xSize.getValue().getBaseUnitValue();
        return (int)(xDist *= (double)this.m_xDim.getValue().intValue());
    }

    private int convertToYPixelLocation(double dist) {
        double yDist = dist + this.m_ySize.getValue().getBaseUnitValue() / 2.0;
        yDist /= this.m_ySize.getValue().getBaseUnitValue();
        return (int)(yDist *= (double)this.m_yDim.getValue().intValue());
    }

    public Pixel getPixel(int x, int y) {
        if (x >= this.m_xDim.getValue() || y >= this.m_yDim.getValue() || x < 0 || y < 0) {
            return null;
        }
        int i = x * this.m_yDim.getValue() + y;
        Pixel result = null;
        if (this.m_pixels.size() > i) {
            result = this.m_pixels.get(i);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImage() {
        BufferedImage bi = new BufferedImage(this.m_xDim.getValue(), this.m_yDim.getValue(), 1);
        Imager imager = this;
        synchronized (imager) {
            boolean vNotM = Settings.SETTINGS.usePolarizationInImager();
            for (int x = 0; x < this.m_xDim.getValue(); ++x) {
                for (int y = 0; y < this.m_yDim.getValue(); ++y) {
                    Pixel p;
                    int rgb = vNotM ? this.getPixel(x, y).getRGBValue(this.m_maxPixelValue) : ((p = this.getPixel(x, y)) == null ? 0 : p.getRGBMagnitude(this.m_maxPixelMagnitude));
                    bi.setRGB(x, y, rgb);
                }
            }
        }
        return bi;
    }

    @Override
    public void clear() {
        this.updateDimensions();
        for (Pixel p : this.m_pixels) {
            p.clear();
        }
    }

    private void updateMaxValue(Pixel pixel) {
        if (pixel.getMaxValue() > this.m_maxPixelValue) {
            this.m_maxPixelValue = pixel.getMaxValue();
        }
        if (pixel.getMaxMagnitude() > this.m_maxPixelMagnitude) {
            this.m_maxPixelMagnitude = pixel.getMaxMagnitude();
        }
    }

    public double getMax() {
        PixelType pt = (PixelType)((Object)this.m_pixelType.getValue());
        double result = pt == PixelType.MONO ? this.m_maxPixelMagnitude : this.m_maxPixelValue;
        return result;
    }

    public double getWidth() {
        return this.m_xSize.getValue().getBaseUnitValue();
    }

    public double getHeight() {
        return this.m_ySize.getValue().getBaseUnitValue();
    }

    @Override
    public void setProperty(PropertyKey key, String s) {
        switch (key) {
            case TRANS_SIZE: {
                this.m_ySize = new EquationProperty(s, this, key);
                this.updateDimensions();
                break;
            }
            case ORTHO_SIZE: {
                this.m_xSize = new EquationProperty(s, this, key);
                this.updateDimensions();
                break;
            }
            case TRANS_DIM: {
                this.m_yDim = new IntegerProperty(s);
                this.updateDimensions();
                break;
            }
            case ORTHO_DIM: {
                this.m_xDim = new IntegerProperty(s);
                this.updateDimensions();
                break;
            }
            case ABSORBS_PHOTONS: {
                this.m_absorbPhotons = new BooleanProperty(s);
                break;
            }
            case PIXEL_TYPE: {
                this.m_pixelType = new EnumProperty(PixelType.MONO, s);
                this.updateDimensions();
                break;
            }
            default: {
                super.setProperty(key, s);
            }
        }
        if (this.getPropertyKeys().contains((Object)key)) {
            this.firePropertyUpdated(key);
        }
    }

    @Override
    public Property<?> getProperty(PropertyKey key) {
        Property<UnitedValue> result;
        switch (key) {
            case TRANS_SIZE: {
                result = this.m_ySize;
                break;
            }
            case ORTHO_SIZE: {
                result = this.m_xSize;
                break;
            }
            case TRANS_DIM: {
                result = this.m_yDim;
                break;
            }
            case ORTHO_DIM: {
                result = this.m_xDim;
                break;
            }
            case ABSORBS_PHOTONS: {
                result = this.m_absorbPhotons;
                break;
            }
            case IMAGE: {
                result = new ImageProperty(this.getImage());
                break;
            }
            case PIXEL_TYPE: {
                result = this.m_pixelType;
                break;
            }
            default: {
                result = super.getProperty(key);
            }
        }
        return result;
    }

    @Override
    public List<PropertyKey> getPropertyKeys() {
        ArrayList<PropertyKey> result = new ArrayList<PropertyKey>(Arrays.asList(PropertyKey.NAME, PropertyKey.SUPPRESSED, PropertyKey.PIXEL_TYPE, PropertyKey.TRANS_SIZE, PropertyKey.ORTHO_SIZE, PropertyKey.TRANS_DIM, PropertyKey.ORTHO_DIM, PropertyKey.ABSORBS_PHOTONS, PropertyKey.IMAGE));
        return result;
    }

    @Override
    public void accept(OpticsObjectVisitor visitor) {
        visitor.visit(this);
    }

    public boolean addContents(ObjectInputStream stream) throws IOException {
        boolean result;
        block15: {
            int j;
            PixelType pt;
            ArrayList<Double> doubles = new ArrayList<Double>();
            result = true;
            boolean colourNotMono = false;
            int x = -1;
            int y = -1;
            x = stream.readInt();
            y = stream.readInt();
            colourNotMono = stream.readBoolean();
            PixelType pixelType = pt = colourNotMono ? PixelType.COLOUR : PixelType.MONO;
            if (y != this.m_yDim.getValue()) {
                result = false;
                System.out.println("Imager.addContents: y Dim loaded: " + y + ", should be: " + this.m_yDim);
            }
            if (x != this.m_xDim.getValue()) {
                result = false;
                System.out.println("Imager.addContents: x Dim loaded: " + x + ", should be: " + this.m_xDim);
            }
            if (pt != this.m_pixelType.getValue()) {
                result = false;
                System.out.println("Imager.addContents: pixel type loaded: " + pt + ", should be: " + this.m_pixelType);
            }
            try {
                while (stream.available() != -1) {
                    doubles.add(stream.readDouble());
                }
            }
            catch (EOFException eOFException) {
                // empty catch block
            }
            if (colourNotMono) {
                if (doubles.size() != 15 * x * y) {
                    result = false;
                    System.out.println("Imager.addContents: pixel num was: " + doubles.size() + ", should be: " + 15 * x * y);
                }
            } else if (doubles.size() != 5 * x * y) {
                result = false;
                System.out.println("Imager.addContents: pixel num was: " + doubles.size() + ", should be: " + 5 * x * y);
            }
            if (!result) break block15;
            ArrayList<ColourPoint> cps = new ArrayList<ColourPoint>();
            for (j = 0; j < doubles.size(); j += 5) {
                double mag = (Double)doubles.get(j);
                Complex main = new Complex((Double)doubles.get(j + 1), (Double)doubles.get(j + 2));
                Complex other = new Complex((Double)doubles.get(j + 3), (Double)doubles.get(j + 4));
                cps.add(new ColourPoint(mag, main, other));
            }
            if (colourNotMono) {
                for (j = 0; j < this.m_pixels.size(); ++j) {
                    ColourPoint cp0 = (ColourPoint)cps.get(j * 3);
                    ColourPoint cp1 = (ColourPoint)cps.get(j * 3 + 1);
                    ColourPoint cp2 = (ColourPoint)cps.get(j * 3 + 2);
                    Pixel p = this.m_pixels.get(j);
                    p.addColourPoints(new ColourPoint[]{cp0, cp1, cp2});
                    this.updateMaxValue(p);
                }
            } else {
                for (j = 0; j < this.m_pixels.size(); ++j) {
                    ColourPoint cp0 = (ColourPoint)cps.get(j);
                    Pixel p = this.m_pixels.get(j);
                    p.addColourPoints(new ColourPoint[]{cp0});
                    this.updateMaxValue(p);
                }
            }
        }
        return result;
    }

    public boolean writeContents(ObjectOutputStream stream) throws IOException {
        boolean result = true;
        stream.writeInt(this.m_xDim.getValue());
        stream.writeInt(this.m_yDim.getValue());
        stream.writeBoolean(this.m_pixelType.getValue() == PixelType.COLOUR);
        for (Pixel p : this.m_pixels) {
            ColourPoint[] cps;
            for (ColourPoint cp : cps = p.getColourPoints()) {
                stream.writeDouble(cp.getMagnitude());
                stream.writeDouble(cp.getMainAxis().real());
                stream.writeDouble(cp.getMainAxis().imag());
                stream.writeDouble(cp.getOtherAxis().real());
                stream.writeDouble(cp.getOtherAxis().imag());
            }
        }
        return result;
    }

    public int getRows() {
        return this.m_yDim.getValue();
    }

    public int getCols() {
        return this.m_xDim.getValue();
    }

    public static enum PixelType {
        COLOUR("Colour"),
        MONO("Monochrome");

        private final String m_name;

        private PixelType(String n2) {
            this.m_name = n2;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

