/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.imager;

import net.sourceforge.jocular.math.Complex;
import net.sourceforge.jocular.photons.Polarization;

public class ColourPoint {
    private Double m_magnitude;
    protected Complex mainAxis;
    protected Complex otherAxis;

    public ColourPoint() {
        this.clear();
    }

    public ColourPoint(double mag, Complex main, Complex other) {
        this.m_magnitude = mag;
        this.mainAxis = main;
        this.otherAxis = other;
    }

    public void clear() {
        this.m_magnitude = 0.0;
        this.mainAxis = new Complex(0.0, 0.0);
        this.otherAxis = new Complex(0.0, 0.0);
    }

    public void addPhoton(double magnitude, Polarization p) {
        this.m_magnitude = this.m_magnitude + magnitude;
        this.mainAxis = this.mainAxis.add(Complex.complexFromPolar(magnitude * p.getMagA(), p.getPhaseA()));
        this.otherAxis = this.otherAxis.add(Complex.complexFromPolar(magnitude * p.getMagB(), p.getPhaseB()));
    }

    public double getValue() {
        return Math.sqrt(this.mainAxis.absSq() + this.otherAxis.absSq());
    }

    public double getMagnitude() {
        return this.m_magnitude;
    }

    public Complex getMainAxis() {
        return this.mainAxis;
    }

    public Complex getOtherAxis() {
        return this.otherAxis;
    }

    public void addColourPoint(ColourPoint cp) {
        this.m_magnitude = this.m_magnitude + cp.m_magnitude;
        this.mainAxis = this.mainAxis.add(cp.mainAxis);
        this.otherAxis = this.otherAxis.add(cp.otherAxis);
    }
}

