/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.imager;

import net.sourceforge.jocular.imager.ColourPoint;
import net.sourceforge.jocular.imager.OpticsColour;
import net.sourceforge.jocular.imager.Pixel;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.photons.Photon;
import net.sourceforge.jocular.photons.Polarization;

public class ColourPixel
implements Pixel {
    private ColourPoint m_redPoint = new ColourPoint();
    private ColourPoint m_bluePoint = new ColourPoint();
    private ColourPoint m_greenPoint = new ColourPoint();

    @Override
    public void clear() {
        this.m_redPoint = new ColourPoint();
        this.m_bluePoint = new ColourPoint();
        this.m_greenPoint = new ColourPoint();
    }

    @Override
    public void addPhoton(Photon photon, Vector3D trans) {
        Polarization p = photon.getPolarization().rotate(trans);
        double w = photon.getWavelength();
        OpticsColour colour = OpticsColour.getColorFromWavelength(w);
        double i = photon.getIntensity();
        this.m_redPoint.addPhoton(colour.getRed() * i, p);
        this.m_bluePoint.addPhoton(colour.getBlue() * i, p);
        this.m_greenPoint.addPhoton(colour.getGreen() * i, p);
    }

    @Override
    public double getMaxMagnitude() {
        return Math.max(this.m_redPoint.getMagnitude(), Math.max(this.m_greenPoint.getMagnitude(), this.m_bluePoint.getMagnitude()));
    }

    @Override
    public double getMaxValue() {
        return Math.max(this.m_redPoint.getValue(), Math.max(this.m_greenPoint.getValue(), this.m_bluePoint.getValue()));
    }

    @Override
    public OpticsColour getNormalColour() {
        double red = this.m_redPoint.getMagnitude();
        double green = this.m_greenPoint.getMagnitude();
        double blue = this.m_bluePoint.getMagnitude();
        double max = Math.max(red, Math.max(green, blue));
        OpticsColour oc = new OpticsColour(red / max, green / max, blue / max);
        return oc;
    }

    @Override
    public int getRGBMagnitude(double scale) {
        int red = (int)(this.m_redPoint.getMagnitude() / scale * 255.0);
        int green = (int)(this.m_greenPoint.getMagnitude() / scale * 255.0);
        int blue = (int)(this.m_bluePoint.getMagnitude() / scale * 255.0);
        return red << 16 | green << 8 | blue;
    }

    @Override
    public int getRGBValue(double scale) {
        int red = (int)(this.m_redPoint.getValue() / scale * 255.0);
        int green = (int)(this.m_greenPoint.getValue() / scale * 255.0);
        int blue = (int)(this.m_bluePoint.getValue() / scale * 255.0);
        return red << 16 | green << 8 | blue;
    }

    @Override
    public double getRed(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_redPoint.getValue();
        }
        return this.m_redPoint.getMagnitude();
    }

    @Override
    public double getBlue(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_bluePoint.getValue();
        }
        return this.m_bluePoint.getMagnitude();
    }

    @Override
    public double getGreen(boolean valueNotMagnitude) {
        if (valueNotMagnitude) {
            return this.m_greenPoint.getValue();
        }
        return this.m_greenPoint.getMagnitude();
    }

    @Override
    public void addColourPoints(ColourPoint[] cps) {
        if (cps.length == 3) {
            this.m_redPoint.addColourPoint(cps[0]);
            this.m_bluePoint.addColourPoint(cps[1]);
            this.m_greenPoint.addColourPoint(cps[2]);
        }
    }

    @Override
    public ColourPoint[] getColourPoints() {
        return new ColourPoint[]{this.m_redPoint, this.m_greenPoint, this.m_bluePoint};
    }
}

