/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.FileArrayProperty;
import net.sourceforge.jocular.properties.FileProperty;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.IntegerProperty;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.properties.MeshDataProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyVisitor;
import net.sourceforge.jocular.properties.StringArrayProperty;
import net.sourceforge.jocular.properties.StringProperty;
import net.sourceforge.jocular.settings.Settings;

public class PropertyCellRenderer
extends DefaultTableCellRenderer
implements PropertyVisitor {
    String m_result;

    @Override
    protected void setValue(Object value) {
        if (value == null) {
            return;
        }
        Property p = (Property)value;
        p.accept(this);
        super.setValue(this.m_result);
    }

    @Override
    public void visit(BooleanProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(EnumProperty v) {
        this.m_result = ((Enum)v.getValue()).toString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(ImageProperty v) {
        this.m_result = "...";
        this.setBackground(Color.white);
    }

    @Override
    public void visit(MeshDataProperty v) {
        this.m_result = "...";
        this.setBackground(Color.white);
    }

    @Override
    public void visit(IntegerProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(EquationProperty v) {
        switch (Settings.SETTINGS.getNumberDisplay()) {
            case EQUATION: {
                this.m_result = v.getDefiningString();
                break;
            }
            case METRIC: {
                this.m_result = v.getValue().getBaseUnitString();
                break;
            }
            case IMPERIAL: {
                this.m_result = "Imperial view not implemented yet.";
            }
        }
        if (v.getValue().isError()) {
            this.setBackground(new Color(1.0f, 0.5f, 0.5f));
            this.setToolTipText(v.getValue().getErrorText());
        } else if (v.getValue().isDeferred()) {
            this.setBackground(new Color(1.0f, 0.75f, 0.5f));
        } else if (v.getValue().isSimpleValue()) {
            this.setBackground(new Color(0.5f, 1.0f, 0.5f));
        } else {
            this.setBackground(new Color(0.5f, 0.5f, 1.0f));
        }
    }

    @Override
    public void visit(MaterialProperty v) {
        this.m_result = v.getKey().toString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(StringProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(FileProperty v) {
        this.m_result = v.getValue().getName();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(StringArrayProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(FileArrayProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(EnumArrayProperty v) {
        this.m_result = v.getDefiningString();
        this.setBackground(Color.white);
    }

    @Override
    public void visit(EquationArrayProperty v) {
        this.m_result = v.getDefiningString();
        String et = "";
        boolean simple = false;
        boolean error = false;
        boolean deferred = false;
        for (UnitedValue uv : v.getValue()) {
            if (uv.isDeferred()) {
                deferred = true;
            }
            if (uv.isSimpleValue()) {
                simple = true;
            }
            if (!uv.isError()) continue;
            error = true;
            et = uv.getErrorText();
        }
        if (error) {
            this.setBackground(new Color(1.0f, 0.5f, 0.5f));
            this.setToolTipText(et);
        } else if (deferred) {
            this.setBackground(new Color(1.0f, 0.75f, 0.5f));
        } else if (simple) {
            this.setBackground(new Color(0.5f, 1.0f, 0.5f));
        } else {
            this.setBackground(new Color(0.5f, 0.5f, 1.0f));
        }
    }
}

