/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.properties.BooleanProperty;
import net.sourceforge.jocular.properties.EnumArrayProperty;
import net.sourceforge.jocular.properties.EnumProperty;
import net.sourceforge.jocular.properties.EquationArrayProperty;
import net.sourceforge.jocular.properties.EquationProperty;
import net.sourceforge.jocular.properties.FileArrayProperty;
import net.sourceforge.jocular.properties.FileProperty;
import net.sourceforge.jocular.properties.ImageProperty;
import net.sourceforge.jocular.properties.IntegerProperty;
import net.sourceforge.jocular.properties.MaterialProperty;
import net.sourceforge.jocular.properties.MeshDataProperty;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyVisitor;
import net.sourceforge.jocular.properties.StringArrayProperty;
import net.sourceforge.jocular.properties.StringProperty;

public class PropertyCellEditorFactory
implements PropertyVisitor {
    TableCellEditor m_editor;

    public TableCellEditor getEditor(Property<?> property) {
        property.accept(this);
        return this.m_editor;
    }

    public static TableCellEditor getDefaultEditor() {
        PropertyCellEditorFactory factory = new PropertyCellEditorFactory();
        return factory.new PropertyCellEditor();
    }

    @Override
    public void visit(BooleanProperty v) {
        this.m_editor = new BooleanPropertyCellEditor();
    }

    @Override
    public void visit(EnumProperty v) {
        this.m_editor = new EnumPropertyCellEditor();
    }

    @Override
    public void visit(ImageProperty v) {
        this.m_editor = new ImagePropertyCellEditor();
    }

    @Override
    public void visit(MeshDataProperty v) {
        this.m_editor = new MeshPropertyCellEditor();
    }

    @Override
    public void visit(IntegerProperty v) {
        this.m_editor = new PropertyCellEditor();
    }

    @Override
    public void visit(EquationProperty v) {
        this.m_editor = new PropertyCellEditor();
    }

    @Override
    public void visit(EquationArrayProperty v) {
        this.m_editor = new PropertyCellEditor();
    }

    @Override
    public void visit(MaterialProperty v) {
        this.m_editor = new MaterialPropertyCellEditor();
    }

    @Override
    public void visit(StringProperty v) {
        this.m_editor = new StringPropertyCellEditor();
    }

    @Override
    public void visit(FileProperty v) {
        this.m_editor = new FilePropertyCellEditor();
    }

    @Override
    public void visit(FileArrayProperty v) {
        this.m_editor = new StringPropertyCellEditor();
    }

    @Override
    public void visit(StringArrayProperty v) {
        this.m_editor = new StringPropertyCellEditor();
    }

    @Override
    public void visit(EnumArrayProperty v) {
        this.m_editor = new StringPropertyCellEditor();
    }

    protected class FilePropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final JButton m_button = new JButton();
        private FileProperty m_property = null;

        public FilePropertyCellEditor() {
            this.m_button.addActionListener(this);
            this.m_button.setBorderPainted(false);
            this.m_button.setContentAreaFilled(false);
            this.m_button.setHorizontalAlignment(2);
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_property.getDefiningString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFileChooser jfc = new JFileChooser();
            jfc.setSelectedFile(this.m_property.getValue());
            if (jfc.showDialog(null, "Select File") == 0) {
                this.m_property = new FileProperty(this.m_property.getOwner(), jfc.getSelectedFile());
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean selected, int row, int column) {
            this.m_property = (FileProperty)value;
            this.m_button.setText(this.m_property.getValue().getName());
            return this.m_button;
        }
    }

    protected class StringArrayPropertyCellEditor
    extends DefaultCellEditor {
        private final JTextField m_textField;

        public StringArrayPropertyCellEditor() {
            super(new JTextField());
            this.m_textField = (JTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            StringArrayProperty sp = (StringArrayProperty)value;
            this.m_textField.setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, sp.getDefiningString(), isSelected, row, column);
        }
    }

    protected class StringPropertyCellEditor
    extends DefaultCellEditor {
        private final JTextField m_textField;

        public StringPropertyCellEditor() {
            super(new JTextField());
            this.m_textField = (JTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            StringProperty sp = (StringProperty)value;
            this.m_textField.setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, sp.getDefiningString(), isSelected, row, column);
        }
    }

    protected class BooleanPropertyCellEditor
    extends DefaultCellEditor {
        private JComboBox<String> m_combo;

        public BooleanPropertyCellEditor() {
            super(new JComboBox());
            this.m_combo = (JComboBox)this.editorComponent;
            this.m_combo.addItem("false");
            this.m_combo.addItem("true");
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            BooleanProperty ep = (BooleanProperty)value;
            int i = ep.getValue() != false ? 1 : 0;
            this.m_combo.setSelectedIndex(i);
            return super.getTableCellEditorComponent(table, ep.getDefiningString(), isSelected, row, column);
        }
    }

    protected class MaterialPropertyCellEditor
    extends DefaultCellEditor {
        private JComboBox<Enum<?>> m_combo;

        public MaterialPropertyCellEditor() {
            super(new JComboBox());
            this.m_combo = (JComboBox)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            MaterialProperty ep = (MaterialProperty)value;
            this.m_combo.removeAllItems();
            for (MaterialProperty.MaterialKey e : MaterialProperty.MaterialKey.values()) {
                this.m_combo.addItem(e);
            }
            this.m_combo.setSelectedItem((Object)ep.getKey());
            return super.getTableCellEditorComponent(table, (Object)ep.getKey(), isSelected, row, column);
        }
    }

    protected class EnumPropertyCellEditor
    extends DefaultCellEditor {
        private JComboBox<Enum<?>> m_combo;

        public EnumPropertyCellEditor() {
            super(new JComboBox());
            this.m_combo = (JComboBox)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            EnumProperty ep = (EnumProperty)value;
            this.m_combo.removeAllItems();
            for (Enum e : (Enum[])ep.getValue().getClass().getEnumConstants()) {
                this.m_combo.addItem(e);
            }
            return super.getTableCellEditorComponent(table, ep.getValue(), isSelected, row, column);
        }
    }

    protected class MeshPropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton m_button = new JButton("...");
        MeshDataProperty m_property = null;
        JTable m_table;

        public MeshPropertyCellEditor() {
            this.m_button.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_property;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.m_property = Jocular.getApp().chooseMeshFile(this.m_table);
            this.fireEditingStopped();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_table = table;
            return this.m_button;
        }
    }

    protected class ImagePropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        JButton m_button = new JButton("...");
        ImageProperty m_property = null;
        JTable m_table;

        public ImagePropertyCellEditor() {
            this.m_button.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            return this.m_property;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            this.m_property = Jocular.defineImage(this.m_table);
            this.fireEditingStopped();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.m_table = table;
            return this.m_button;
        }
    }

    protected class PropertyCellEditor
    extends DefaultCellEditor {
        private final JTextField m_textField;

        public PropertyCellEditor() {
            super(new JTextField());
            this.m_textField = (JTextField)this.editorComponent;
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            Property p = (Property)value;
            this.m_textField.setBorder(new LineBorder(Color.black));
            return super.getTableCellEditorComponent(table, p.getDefiningString(), isSelected, row, column);
        }
    }
}

