/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyOwner;

public class OpticsPropertyTableModel
implements TableModel {
    private final CopyOnWriteArrayList<TableModelListener> m_listeners = new CopyOnWriteArrayList();
    private PropertyOwner m_owner = null;
    private OpticsProject m_project = null;

    public void setPropertyOwner(PropertyOwner o, OpticsProject p) {
        this.m_owner = o;
        this.m_project = p;
        this.fireUpdate();
    }

    @Override
    public void addTableModelListener(TableModelListener tml) {
        this.m_listeners.addIfAbsent(tml);
    }

    public void fireUpdate() {
        for (TableModelListener l : this.m_listeners) {
            l.tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public Class<?> getColumnClass(int c) {
        Class result;
        switch (c) {
            case 0: {
                result = String.class;
                break;
            }
            case 1: {
                result = Property.class;
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public int getColumnCount() {
        return 2;
    }

    @Override
    public String getColumnName(int i) {
        String result;
        switch (i) {
            case 0: {
                result = "Property";
                break;
            }
            case 1: {
                result = "Value";
                break;
            }
            default: {
                result = "N/A";
            }
        }
        return result;
    }

    @Override
    public int getRowCount() {
        int result = 0;
        if (this.m_owner != null) {
            result = this.m_owner.getPropertyKeys().size();
        }
        return result;
    }

    public PropertyKey getPropertyKey(int r) {
        return this.m_owner.getPropertyKeys().get(r);
    }

    @Override
    public Object getValueAt(int r, int c) {
        Object result;
        if (this.m_owner == null) {
            return null;
        }
        PropertyKey pk = this.m_owner.getPropertyKeys().get(r);
        switch (c) {
            case 0: {
                result = pk.toString();
                break;
            }
            case 1: {
                result = this.m_owner.getProperty(pk);
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    @Override
    public boolean isCellEditable(int r, int c) {
        boolean result = false;
        if (c == 1) {
            result = true;
        }
        return result;
    }

    @Override
    public void removeTableModelListener(TableModelListener tml) {
        this.m_listeners.remove(tml);
    }

    @Override
    public void setValueAt(Object s, int r, int c) {
        if (this.m_project == null || this.m_owner == null || s == null) {
            return;
        }
        if (s instanceof Property) {
            s = ((Property)s).getDefiningString();
        }
        String value = s.toString();
        if (s instanceof Enum) {
            value = ((Enum)s).name();
        }
        this.m_project.addPropertyEdit(this.m_owner, this.m_owner.getPropertyKeys().get(r), value);
    }
}

