/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import net.sourceforge.jocular.gui.tables.OpticsPropertyTableModel;
import net.sourceforge.jocular.gui.tables.PropertyCellEditorFactory;
import net.sourceforge.jocular.gui.tables.PropertyCellRenderer;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.settings.Settings;

public class OpticsPropertyTable
extends JTable {
    private final OpticsPropertyTableModel m_model;

    public OpticsPropertyTable(OpticsPropertyTableModel model) {
        super(model);
        this.m_model = model;
        this.setDefaultRenderer(Property.class, new PropertyCellRenderer());
        this.setDefaultRenderer(PropertyKey.class, new PropertyKeyCellRenderer());
        this.setDefaultEditor(Property.class, PropertyCellEditorFactory.getDefaultEditor());
        Settings.SETTINGS.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                switch (e.getPropertyKey()) {
                    case EQUATION_DISPLAY: {
                        OpticsPropertyTable.this.repaint();
                        break;
                    }
                }
            }
        });
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int r = this.rowAtPoint(event.getPoint());
        return this.m_model.getPropertyKey(r).getTooltip();
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        Property p = (Property)this.m_model.getValueAt(row, column);
        PropertyCellEditorFactory editorFactory = new PropertyCellEditorFactory();
        TableCellEditor result = editorFactory.getEditor(p);
        return result;
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean result = super.editCellAt(row, column, e);
        this.selectAll(e);
        return result;
    }

    private void selectAll(EventObject e) {
        final Component editor = this.getEditorComponent();
        if (editor == null || !(editor instanceof JTextField)) {
            return;
        }
        if (e == null) {
            ((JTextField)editor).selectAll();
            return;
        }
        if (e instanceof KeyEvent) {
            ((JTextField)editor).selectAll();
            return;
        }
        if (e instanceof ActionEvent) {
            ((JTextField)editor).selectAll();
            return;
        }
        if (e instanceof MouseEvent) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextField)editor).selectAll();
                }
            });
        }
    }

    protected class PropertyKeyCellRenderer
    extends DefaultTableCellRenderer {
        protected PropertyKeyCellRenderer() {
        }

        @Override
        protected void setValue(Object value) {
            super.setValue(((PropertyKey)((Object)value)).toString());
        }
    }
}

