/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;

public class OpticsObjectTreeModel
implements TreeModel {
    private final Collection<TreeModelListener> m_listeners = new CopyOnWriteArrayList<TreeModelListener>();
    private OpticsObjectGroup m_group = null;

    public OpticsObjectTreeModel() {
        throw new RuntimeException("This class should not be used anymore.");
    }

    public void setGroup(OpticsObjectGroup group) {
        this.m_group = group;
        this.fireUpdate();
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.m_listeners.add(l);
    }

    @Override
    public Object getChild(Object parent, int index) {
        OpticsObject result = null;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            OpticsObject[] os = g.getObjects().toArray(new OpticsObject[g.getObjects().size()]);
            result = os[index];
        }
        return result;
    }

    @Override
    public int getChildCount(Object parent) {
        int result = 0;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            result = g.getObjects().size();
        }
        return result;
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        int result = -1;
        if (parent instanceof OpticsObjectGroup && !(parent instanceof OpticsPart)) {
            OpticsObjectGroup g = (OpticsObjectGroup)parent;
            OpticsObject[] os = g.getObjects().toArray(new OpticsObject[g.getObjects().size()]);
            for (int i = 0; i < os.length; ++i) {
                if (os[i] != child) continue;
                result = i;
                break;
            }
        }
        return result;
    }

    @Override
    public Object getRoot() {
        return this.m_group;
    }

    @Override
    public boolean isLeaf(Object node) {
        boolean result = true;
        if (node instanceof OpticsPart) {
            result = true;
        } else if (node instanceof OpticsObjectGroup) {
            result = false;
        }
        return result;
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.m_listeners.remove(l);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        for (TreeModelListener l : this.m_listeners) {
            l.treeNodesChanged(new TreeModelEvent(newValue, path));
        }
    }

    public void fireUpdate() {
        Object[] path = new Object[]{this.m_group};
        for (TreeModelListener l : this.m_listeners) {
            l.treeStructureChanged(new TreeModelEvent((Object)this.m_group, path));
        }
    }
}

