/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.tables;

import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.actions.ContextPopup;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.PropertyKey;

public class OpticsObjectTree
extends JTree {
    private OpticsProject m_project = null;
    private Jocular m_app;

    public OpticsObjectTree(Jocular app) {
        this.m_app = app;
        this.setProject(new OpticsProject());
        this.disableKeyHandlers();
        this.setCellRenderer(new OpticsObjectTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                OpticsObjectTree.this.m_app.stopEditing();
                OpticsObjectTree.this.m_project.getOpticsObject().setSelected(false);
                if (e.isAddedPath()) {
                    OpticsObject oo;
                    oo.setSelected(!(oo = (OpticsObject)e.getPath().getLastPathComponent()).isSelected());
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            private void testForPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    Object o;
                    Point p = e.getPoint();
                    TreePath tp = OpticsObjectTree.this.getPathForLocation(p.x, p.y);
                    if (!OpticsObjectTree.this.isPathSelected(tp)) {
                        OpticsObjectTree.this.setSelectionPath(tp);
                    }
                    if ((o = tp == null ? OpticsObjectTree.this.m_project.getRoot() : tp.getLastPathComponent()) instanceof OpticsObject) {
                        JPopupMenu popup = ContextPopup.getPopup(OpticsObjectTree.this.m_app, (OpticsObject)o);
                        popup.show(e.getComponent(), e.getX(), e.getY());
                    }
                }
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.testForPopup(e);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                this.testForPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                this.testForPopup(e);
            }
        });
    }

    private void disableKeyHandlers() {
        KeyStroke ks = KeyStroke.getKeyStroke("control C");
        this.getInputMap(0).put(ks, "disableCopy");
        this.getActionMap().put("disableCopy", null);
        ks = KeyStroke.getKeyStroke("control X");
        this.getInputMap(0).put(ks, "disableCut");
        this.getActionMap().put("disableCut", null);
        ks = KeyStroke.getKeyStroke("control V");
        this.getInputMap(0).put(ks, "disablePaste");
        this.getActionMap().put("disablePaste", null);
        ks = KeyStroke.getKeyStroke("DELETE");
        this.getInputMap(0).put(ks, "disableDelete");
        this.getActionMap().put("disableDelete", null);
        ks = KeyStroke.getKeyStroke("F8");
        this.getInputMap(0).put(ks, "disableF8");
        this.getActionMap().put("disableF8", null);
    }

    public void setProject(OpticsProject p) {
        if (p == null) {
            return;
        }
        this.m_project = p;
        this.setModel(p);
        this.m_project.addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent e) {
            }

            @Override
            public void treeNodesInserted(TreeModelEvent e) {
                TreePath tp = e.getTreePath().pathByAddingChild(e.getSource());
                OpticsObjectTree.this.setSelectionPath(tp);
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent e) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent e) {
            }
        });
    }

    protected class OpticsObjectTreeCellRenderer
    extends DefaultTreeCellRenderer {
        protected OpticsObjectTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object s = "";
            boolean suppressed = false;
            if (value instanceof OpticsObject) {
                OpticsObject o = (OpticsObject)value;
                s = o.getClass().getSimpleName();
                String n = o.getProperty(PropertyKey.NAME).getDefiningString();
                if (!n.equals("")) {
                    s = (String)s + " - " + n;
                }
                suppressed = o.isSuppressed();
            }
            Component result = super.getTreeCellRendererComponent(tree, s, selected, expanded, leaf, row, false);
            Font f = result.getFont();
            HashMap<TextAttribute, Boolean> attributes = new HashMap<TextAttribute, Boolean>();
            if (suppressed) {
                attributes.put(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON);
            } else {
                attributes.put(TextAttribute.STRIKETHROUGH, Boolean.FALSE);
            }
            f = f.deriveFont(attributes);
            result.setFont(f);
            return result;
        }
    }
}

