/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panelfx;

import javafx.application.Platform;
import javafx.scene.Group;
import javafx.scene.Node;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.gui.panelfx.Shape3DFactory;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.mesh.MeshOpticsObject;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.PlanoAsphericLens;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.objects.SimpleAperture;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.objects.TriangularPrism;
import net.sourceforge.jocular.project.OpticsObjectVisitor;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.ImageSource;
import net.sourceforge.jocular.splines.ExtrudedSpline;
import net.sourceforge.jocular.splines.RotatedSpline;

public class Shape3DFactoryVisitor
implements OpticsObjectVisitor {
    private Shape3DFactory m_factory = new Shape3DFactory();
    private final Group m_parent;

    public Shape3DFactoryVisitor(Group parent) {
        this.m_parent = parent;
    }

    private void add(final Node s, final OpticsObject oo) {
        s.setUserData(oo);
        oo.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                if (e.getPropertyKey() == PropertyKey.SUPPRESSED && Shape3DFactoryVisitor.this.m_parent != null) {
                    Platform.runLater(() -> {
                        if (!oo.isSuppressed()) {
                            if (!Shape3DFactoryVisitor.this.m_parent.getChildren().contains(s)) {
                                Shape3DFactoryVisitor.this.m_parent.getChildren().add(s);
                            }
                        } else {
                            Shape3DFactoryVisitor.this.m_parent.getChildren().remove(s);
                        }
                    });
                }
            }
        });
        Platform.runLater(() -> {
            if (this.m_parent != null && !oo.isSuppressed()) {
                this.m_parent.getChildren().add(s);
                System.out.println("Shape3DFactoryVisitor.add adding child");
            }
        });
    }

    @Override
    public void visit(Imager v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(SphericalLens v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(HemiPointSource v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(MeshOpticsObject v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(OpticsObjectGroup v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(ProjectRootGroup v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(TriangularPrism v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(ImageSource v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(SimpleAperture v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(SpectroPhotometer v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(AutofocusSensor v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(RotatedSpline v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(PlanoAsphericLens v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(ExtrudedSpline v) {
        this.add(this.m_factory.create(v), v);
    }

    @Override
    public void visit(OpticsPart v) {
        this.add(this.m_factory.create(v), v);
    }
}

