/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panelfx;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.List;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.embed.swing.SwingFXUtils;
import javafx.geometry.Point3D;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Cylinder;
import javafx.scene.shape.DrawMode;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.Shape3D;
import javafx.scene.shape.Sphere;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.sourceforge.jocular.Jocular;
import net.sourceforge.jocular.autofocus.AutofocusSensor;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.gui.panelfx.NodeUpdater;
import net.sourceforge.jocular.gui.panelfx.RotatedMeshMaker;
import net.sourceforge.jocular.gui.panelfx.Shape3DFactoryVisitor;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.imager.OpticsColour;
import net.sourceforge.jocular.materials.OpticalMaterial;
import net.sourceforge.jocular.math.PolygonDicer;
import net.sourceforge.jocular.math.Vector3D;
import net.sourceforge.jocular.math.equations.UnitedValue;
import net.sourceforge.jocular.mesh.MeshMesher;
import net.sourceforge.jocular.mesh.MeshOpticsObject;
import net.sourceforge.jocular.objects.GroupChangeEvent;
import net.sourceforge.jocular.objects.GroupListener;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.objects.OpticsObjectGroup;
import net.sourceforge.jocular.objects.OpticsPart;
import net.sourceforge.jocular.objects.PlanoAsphericLens;
import net.sourceforge.jocular.objects.ProjectRootGroup;
import net.sourceforge.jocular.objects.SimpleAperture;
import net.sourceforge.jocular.objects.SpectroPhotometer;
import net.sourceforge.jocular.objects.SphericalLens;
import net.sourceforge.jocular.objects.TriangularPrism;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.positioners.ObjectPositioner;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.Property;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyManager;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.sources.HemiPointSource;
import net.sourceforge.jocular.sources.ImageSource;
import net.sourceforge.jocular.splines.ExtrudedSpline;
import net.sourceforge.jocular.splines.RotatedSpline;
import net.sourceforge.jocular.splines.SplineCoefficients;

public class Shape3DFactory {
    private static final OpticsColour SELECTED_COLOUR = OpticsColour.MAGENTA;

    protected Node create(Imager v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            float h = (float)((UnitedValue)v.getProperty(PropertyKey.TRANS_SIZE).getValue()).getBaseUnitValue();
            float w = (float)((UnitedValue)v.getProperty(PropertyKey.ORTHO_SIZE).getValue()).getBaseUnitValue();
            this.setImage(n, w, h, v.getImage(), v.isSelected());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(OpticsPart v) {
        return this.create((OpticsObjectGroup)v);
    }

    protected Node create(ExtrudedSpline v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            double thickness = ((UnitedValue)v.getProperty(PropertyKey.THICKNESS).getValue()).getBaseUnitValue();
            SplineCoefficients[] scs = v.getSplineCoefficients();
            if (scs != null) {
                PolygonDicer d = new PolygonDicer(scs, 10);
                d.dice();
                List<int[]> ts = d.getTriangles();
                int len = d.getPointCount();
                float[] points = new float[2 * len * 3];
                Vector3D xDir = Vector3D.X_AXIS;
                Vector3D yDir = Vector3D.Y_AXIS;
                int i = 0;
                while (i < len) {
                    Vector3D vec = d.project(i, new Vector3D(0.0, 0.0, thickness / 2.0), xDir, yDir);
                    points[3 * i + 0] = (float)vec.x;
                    points[3 * i + 1] = (float)vec.y;
                    points[3 * i + 2] = (float)vec.z;
                    vec = d.project(i, new Vector3D(0.0, 0.0, -thickness / 2.0), xDir, yDir);
                    points[3 * i + 0 + len * 3] = (float)vec.x;
                    points[3 * i + 1 + len * 3] = (float)vec.y;
                    points[3 * i + 2 + len * 3] = (float)vec.z;
                    ++i;
                }
                int tLen = ts.size();
                int[] triangs = new int[(tLen + len) * 2 * 6];
                int[] smooths = new int[(tLen + len) * 2];
                int i2 = 0;
                while (i2 < tLen) {
                    int[] t = ts.get(i2);
                    triangs[6 * i2 + 0] = t[0];
                    triangs[6 * i2 + 1] = 0;
                    triangs[6 * i2 + 2] = t[2];
                    triangs[6 * i2 + 3] = 0;
                    triangs[6 * i2 + 4] = t[1];
                    triangs[6 * i2 + 5] = 0;
                    smooths[i2] = 1;
                    triangs[6 * i2 + 0 + 6 * tLen] = t[0] + len;
                    triangs[6 * i2 + 1 + 6 * tLen] = 0;
                    triangs[6 * i2 + 2 + 6 * tLen] = t[1] + len;
                    triangs[6 * i2 + 3 + 6 * tLen] = 0;
                    triangs[6 * i2 + 4 + 6 * tLen] = t[2] + len;
                    triangs[6 * i2 + 5 + 6 * tLen] = 0;
                    smooths[i2 + tLen] = 2;
                    ++i2;
                }
                int smooth = 4;
                int i3 = 0;
                while (i3 < len) {
                    int p00 = i3;
                    int p10 = (i3 + 1) % len;
                    int p11 = (i3 + 1) % len + len;
                    int p01 = i3 + len;
                    boolean s = d.getSmooths()[i3];
                    if (!s) {
                        smooth <<= 1;
                    }
                    triangs[tLen * 2 * 6 + 6 * i3 + 0] = p00;
                    triangs[tLen * 2 * 6 + 6 * i3 + 1] = 0;
                    triangs[tLen * 2 * 6 + 6 * i3 + 2] = p10;
                    triangs[tLen * 2 * 6 + 6 * i3 + 3] = 0;
                    triangs[tLen * 2 * 6 + 6 * i3 + 4] = p11;
                    triangs[tLen * 2 * 6 + 6 * i3 + 5] = 0;
                    smooths[tLen * 2 + i3] = smooth;
                    triangs[tLen * 2 * 6 + 6 * i3 + 0 + 6 * len] = p00;
                    triangs[tLen * 2 * 6 + 6 * i3 + 1 + 6 * len] = 0;
                    triangs[tLen * 2 * 6 + 6 * i3 + 2 + 6 * len] = p11;
                    triangs[tLen * 2 * 6 + 6 * i3 + 3 + 6 * len] = 0;
                    triangs[tLen * 2 * 6 + 6 * i3 + 4 + 6 * len] = p01;
                    triangs[tLen * 2 * 6 + 6 * i3 + 5 + 6 * len] = 0;
                    smooths[tLen * 2 + i3 + len] = smooth;
                    ++i3;
                }
                TriangleMesh tm = new TriangleMesh();
                tm.getPoints().addAll(points);
                tm.getFaces().addAll(triangs);
                tm.getTexCoords().addAll(0.0f, 0.0f);
                tm.getFaceSmoothingGroups().addAll(smooths);
                n.setMesh(tm);
            }
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(PlanoAsphericLens v) {
        return this.create((RotatedSpline)v);
    }

    protected Node create(RotatedSpline v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            SplineCoefficients[] scs = v.getSplineCoefficients();
            PolygonDicer d = new PolygonDicer(scs, 10);
            double angle = v.getAngle();
            RotatedMeshMaker rmm = new RotatedMeshMaker(d, angle);
            n.setMesh(rmm.makeMesh());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(AutofocusSensor v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            double dia = ((UnitedValue)v.getProperty(PropertyKey.DIAMETER).getValue()).getBaseUnitValue();
            double[] rads = new double[]{0.0, dia / 2.0, dia / 2.0, 0.0};
            double[] zeds = new double[]{-1.0E-9, -1.0E-9, 1.0E-9, 1.0E-9};
            boolean[] smooths = new boolean[4];
            RotatedMeshMaker rmm = new RotatedMeshMaker(new PolygonDicer(zeds, rads, smooths), Math.PI * 2);
            n.setMesh(rmm.makeMesh());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(SpectroPhotometer v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            double dia = ((UnitedValue)v.getProperty(PropertyKey.DIAMETER).getValue()).getBaseUnitValue();
            double[] rads = new double[]{0.0, dia / 2.0, dia / 2.0, 0.0};
            double[] zeds = new double[]{-1.0E-9, -1.0E-9, 1.0E-9, 1.0E-9};
            boolean[] smooths = new boolean[4];
            RotatedMeshMaker rmm = new RotatedMeshMaker(new PolygonDicer(zeds, rads, smooths), Math.PI * 2);
            n.setMesh(rmm.makeMesh());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(SimpleAperture v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            double apDia = ((UnitedValue)v.getProperty(PropertyKey.DIAMETER).getValue()).getBaseUnitValue();
            double dia = ((UnitedValue)v.getProperty(PropertyKey.OUTER_DIAMETER).getValue()).getBaseUnitValue();
            double[] rads = new double[]{apDia / 2.0, dia / 2.0, dia / 2.0, apDia / 2.0};
            double[] zeds = new double[]{-1.0E-9, -1.0E-9, 1.0E-9, 1.0E-9};
            boolean[] smooths = new boolean[4];
            RotatedMeshMaker rmm = new RotatedMeshMaker(new PolygonDicer(zeds, rads, smooths), Math.PI * 2);
            n.setMesh(rmm.makeMesh());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    private void setImage(MeshView n, double width, double height, BufferedImage bi, boolean selected) {
        PhongMaterial fxm;
        WritableImage i = SwingFXUtils.toFXImage(bi, null);
        if (selected) {
            n.setDrawMode(DrawMode.LINE);
            fxm = new PhongMaterial(SELECTED_COLOUR.getFxColor());
        } else {
            n.setDrawMode(DrawMode.FILL);
            fxm = new PhongMaterial(new OpticsColour(0.0, 0.0, 0.0, 1.0).getFxColor(), i, i, i, i);
        }
        n.setMaterial(fxm);
        float h2 = (float)(height / 2.0);
        float w2 = (float)(width / 2.0);
        float t2 = 1.0E-9f;
        TriangleMesh tm = new TriangleMesh();
        tm.getTexCoords().addAll(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f);
        tm.getPoints().addAll(w2, h2, 0.0f, w2, -h2, 0.0f, -w2, -h2, 0.0f, -w2, h2, 0.0f);
        tm.getFaces().addAll(0, 3, 3, 1, 2, 0, 0, 3, 2, 0, 1, 2, 0, 3, 2, 0, 3, 1, 0, 3, 1, 2, 2, 0);
        n.setMesh(tm);
    }

    protected Node create(ImageSource v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            float h = (float)((UnitedValue)v.getProperty(PropertyKey.TRANS_SIZE).getValue()).getBaseUnitValue();
            float w = (float)((UnitedValue)v.getProperty(PropertyKey.ORTHO_SIZE).getValue()).getBaseUnitValue();
            this.setImage(n, w, h, v.getImage(), v.isSelected());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(TriangularPrism v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            Vector3D[][] vs = v.getVertices();
            TriangleMesh tm = new TriangleMesh();
            tm.getTexCoords().addAll(0.0f, 0.0f);
            Vector3D p0 = vs[0][0];
            Vector3D p1 = vs[0][1];
            Vector3D p2 = vs[0][2];
            Vector3D p3 = vs[1][0];
            Vector3D p4 = vs[1][1];
            Vector3D p5 = vs[1][2];
            tm.getPoints().addAll((float)p0.x, (float)p0.y, (float)p0.z, (float)p1.x, (float)p1.y, (float)p1.z, (float)p2.x, (float)p2.y, (float)p2.z, (float)p3.x, (float)p3.y, (float)p3.z, (float)p4.x, (float)p4.y, (float)p4.z, (float)p5.x, (float)p5.y, (float)p5.z);
            tm.getFaces().addAll(0, 0, 2, 0, 1, 0, 1, 0, 3, 0, 0, 0, 1, 0, 4, 0, 3, 0, 2, 0, 4, 0, 1, 0, 2, 0, 5, 0, 4, 0, 0, 0, 5, 0, 2, 0, 0, 0, 3, 0, 5, 0, 3, 0, 4, 0, 5, 0);
            n.setMesh(tm);
            this.setLook(n, oo);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(ProjectRootGroup v) {
        return this.create((OpticsObjectGroup)v);
    }

    protected Node create(OpticsObjectGroup v) {
        final Group n = new Group();
        n.setUserData(v);
        v.addGroupListener(new GroupListener(){

            @Override
            public void groupChanged(final GroupChangeEvent gce) {
                Platform.runLater(new Runnable(){

                    @Override
                    public void run() {
                        switch (gce.getType()) {
                            case ADD: {
                                Shape3DFactoryVisitor fv = new Shape3DFactoryVisitor(n);
                                gce.getObject().accept(fv);
                                break;
                            }
                            case REMOVE: {
                                n.getChildren().removeIf(n -> n.getUserData() == gce.getObject());
                            }
                        }
                    }
                });
            }
        });
        Shape3DFactoryVisitor fv = new Shape3DFactoryVisitor(n);
        for (OpticsObject oo2 : v.getObjects()) {
            oo2.accept(fv);
        }
        this.linkListenerAndUpdate(v, oo -> {});
        return n;
    }

    protected Node create(HemiPointSource v) {
        Sphere n = new Sphere();
        n.setRadius(0.001);
        this.linkListenerAndUpdate(v, oo -> {
            double w = ((UnitedValue)v.getProperty(PropertyKey.WAVELENGTH_MEAN).getValue()).getBaseUnitValue();
            double wfwhm = ((UnitedValue)v.getProperty(PropertyKey.WAVELENGTH_FWHM).getValue()).getBaseUnitValue();
            OpticsColour c = OpticsColour.getColorFromWavelength(w, wfwhm);
            this.setLook(n, c, v.isSelected());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(OpticsObject v) {
        Sphere n = new Sphere();
        n.setRadius(0.001);
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(MeshOpticsObject v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            n.setMesh(new MeshMesher(v).makeMesh());
            this.setLook(n, oo);
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    protected Node create(SphericalLens v) {
        MeshView n = new MeshView();
        this.linkListenerAndUpdate(v, oo -> {
            this.setLook(n, oo);
            int stepsPerCurve = 10;
            int pn = 0;
            SphericalLens.SurfaceShape fs = (SphericalLens.SurfaceShape)((Object)((Object)oo.getProperty(PropertyKey.FRONT_SHAPE).getValue()));
            SphericalLens.SurfaceShape bs = (SphericalLens.SurfaceShape)((Object)((Object)oo.getProperty(PropertyKey.BACK_SHAPE).getValue()));
            double dia = ((UnitedValue)oo.getProperty(PropertyKey.DIAMETER).getValue()).getBaseUnitValue();
            if (dia == 0.0) {
                return;
            }
            double thickness = ((UnitedValue)oo.getProperty(PropertyKey.THICKNESS).getValue()).getBaseUnitValue();
            double frontRad = ((UnitedValue)oo.getProperty(PropertyKey.FRONT_RADIUS).getValue()).getBaseUnitValue();
            double backRad = ((UnitedValue)oo.getProperty(PropertyKey.BACK_RADIUS).getValue()).getBaseUnitValue();
            double fz = -thickness / 2.0;
            double bz = thickness / 2.0;
            double famax = Math.asin(dia / 2.0 / frontRad);
            double bamax = Math.asin(dia / 2.0 / backRad);
            double fda = famax / (double)(stepsPerCurve - 1);
            double bda = bamax / (double)(stepsPerCurve - 1);
            switch (fs) {
                case CONCAVE: {
                    pn += stepsPerCurve;
                    fz -= frontRad;
                    break;
                }
                case CONVEX: {
                    pn += stepsPerCurve;
                    fz += frontRad;
                    frontRad = -frontRad;
                    break;
                }
                case FLAT: {
                    pn += 2;
                }
            }
            switch (bs) {
                case CONCAVE: {
                    pn += stepsPerCurve;
                    bz += backRad;
                    backRad = -backRad;
                    break;
                }
                case CONVEX: {
                    pn += stepsPerCurve;
                    bz -= backRad;
                    break;
                }
                case FLAT: {
                    pn += 2;
                }
            }
            double[] rads = new double[pn];
            double[] zeds = new double[pn];
            boolean[] smooths = new boolean[pn];
            int i = 0;
            switch (fs) {
                case CONCAVE: 
                case CONVEX: {
                    double j = 0.0;
                    while (j < (double)stepsPerCurve) {
                        rads[i] = Math.abs(frontRad * Math.sin(j * fda));
                        zeds[i] = fz + frontRad * Math.cos(j * fda);
                        smooths[i] = j < (double)(stepsPerCurve - 1);
                        ++i;
                        j += 1.0;
                    }
                    break;
                }
                case FLAT: {
                    rads[i] = 0.0;
                    zeds[i] = fz;
                    smooths[i] = true;
                    rads[++i] = dia / 2.0;
                    zeds[i] = fz;
                    smooths[i] = false;
                    ++i;
                }
            }
            boolean firstGo = false;
            switch (bs) {
                case CONCAVE: 
                case CONVEX: {
                    double j = stepsPerCurve - 1;
                    while (j >= 0.0) {
                        rads[i] = Math.abs(backRad * Math.sin(j * bda));
                        zeds[i] = bz + backRad * Math.cos(j * bda);
                        smooths[i] = firstGo;
                        firstGo = true;
                        ++i;
                        j -= 1.0;
                    }
                    break;
                }
                case FLAT: {
                    rads[i] = dia / 2.0;
                    zeds[i] = bz;
                    smooths[i] = false;
                    rads[++i] = 0.0;
                    zeds[i] = bz;
                    smooths[i] = true;
                    ++i;
                }
            }
            if (Double.isNaN(zeds[0])) {
                throw new RuntimeException("Thingy is NaN!");
            }
            RotatedMeshMaker rmm = new RotatedMeshMaker(new PolygonDicer(zeds, rads, smooths), Math.PI * 2);
            n.setMesh(rmm.makeMesh());
            this.updatePositioner(oo, n);
        });
        this.linkPosListener(n, v);
        return n;
    }

    private void setLook(Shape3D s, OpticsColour c, boolean selected) {
        OpticsColour c2 = c;
        if (selected) {
            c2 = SELECTED_COLOUR;
            s.setDrawMode(DrawMode.LINE);
        } else {
            s.setDrawMode(DrawMode.FILL);
        }
        PhongMaterial fxm = new PhongMaterial(c2.getFxColor());
        s.setMaterial(fxm);
    }

    private void setLook(Shape3D s, OpticsObject v) {
        OpticalMaterial m = v.getMaterial();
        OpticsColour c = m.getColour();
        this.setLook(s, c, v.isSelected());
    }

    private void updatePositioner(OpticsObject oo, Node n) {
        if (oo == null) {
            throw new NullPointerException();
        }
        ObjectPositioner p = oo.getPositioner();
        if (p != null) {
            ObservableList<Transform> ts = n.getTransforms();
            ts.clear();
            ts.addAll((Transform[])new Transform[]{p.getTransform()});
        }
    }

    private void linkPosListener(final Node n, OpticsObject oo) {
        n.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> this.setSelectedNode(oo, e.isShiftDown()));
        oo.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                OpticsObject oo;
                if (e.getPropertyKey() == PropertyKey.POSITIONER && (oo = e.getOpticsObjectSource()) != null) {
                    Platform.runLater(() -> Shape3DFactory.this.updatePositioner(oo, n));
                }
            }
        });
    }

    private void setSelectedNode(OpticsObject oo, boolean append) {
        boolean s = oo.isSelected();
        if (!append) {
            OpticsProject p = PropertyManager.getInstance().getProject(oo);
            p.getOpticsObject().setSelected(false);
        }
        oo.setSelected(!s);
        Jocular.getApp().setSelectedObject(oo);
    }

    private void linkListenerAndUpdate(OpticsObject oo, final NodeUpdater su) {
        oo.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                Platform.runLater(() -> su.update(e.getOpticsObjectSource()));
            }
        });
        Platform.runLater(() -> su.update(oo));
    }

    private double getValue(OpticsObject oo, PropertyKey key) {
        UnitedValue uv;
        double result = Double.NaN;
        Property<?> p = oo.getProperty(key);
        if (p != null && oo != null && (uv = (UnitedValue)p.getValue()) != null) {
            result = uv.getBaseUnitValue();
        }
        if (Double.isNaN(result)) {
            throw new NullPointerException();
        }
        return result;
    }

    public static MeshView makeArrow(double len, double rad) {
        MeshView result = new MeshView();
        double[] rads = new double[]{0.0, rad, rad, rad * 2.0, 0.0};
        double[] zeds = new double[]{0.0, 0.0, len * 0.75, len * 0.75, len};
        boolean[] smooths = new boolean[5];
        RotatedMeshMaker rmm = new RotatedMeshMaker(new PolygonDicer(zeds, rads, smooths), Math.PI * 2);
        result.setMesh(rmm.makeMesh());
        return result;
    }

    public static Node makeAxis(double len) {
        double rad = len / 20.0;
        MeshView arrowX = Shape3DFactory.makeArrow(len, rad);
        MeshView arrowY = Shape3DFactory.makeArrow(len, rad);
        MeshView arrowZ = Shape3DFactory.makeArrow(len, rad);
        Group result = new Group();
        PhongMaterial mx = new PhongMaterial(Color.RED);
        PhongMaterial my = new PhongMaterial(Color.GREEN);
        PhongMaterial mz = new PhongMaterial(Color.BLUE);
        PhongMaterial ms = new PhongMaterial(Color.INDIGO);
        arrowX.setMaterial(mx);
        arrowY.setMaterial(my);
        arrowZ.setMaterial(mz);
        arrowX.getTransforms().add(new Rotate(90.0, Rotate.Y_AXIS));
        arrowY.getTransforms().add(new Rotate(-90.0, Rotate.X_AXIS));
        Sphere s = new Sphere(rad * 2.0);
        s.setMaterial(ms);
        result.getChildren().clear();
        result.getChildren().add(arrowX);
        result.getChildren().add(arrowY);
        result.getChildren().add(arrowZ);
        result.getChildren().add(s);
        result.getChildren().add(Shape3DFactory.makeLine(new Vector3D(0.0, 0.0, 0.0), new Vector3D(0.02, 0.0, 0.0), OpticsColour.BLUE));
        return result;
    }

    public static Node makeTrajectory(Collection<PhotonTrajectory> pts, OutputPanel.PhotonRenderColour prc) {
        Group result = new Group();
        for (PhotonTrajectory pt : pts) {
            Group trajectory = new Group();
            int n = pt.getNumberOfPhotons();
            Vector3D p0 = null;
            int i = 0;
            while (i < n) {
                Vector3D p1 = pt.getPhoton(i).getOrigin();
                if (p0 != null) {
                    OpticsColour c = OpticsColour.getColour(pt, i, prc);
                    trajectory.getChildren().add(Shape3DFactory.makeLine(p0, p1, c));
                }
                p0 = p1;
                ++i;
            }
            trajectory.addEventHandler(MouseEvent.MOUSE_CLICKED, e -> System.out.println("Shape3DFactory.makeTrajectory:" + pt.toString()));
            result.getChildren().add(trajectory);
        }
        return result;
    }

    public static Node makeLine(Vector3D p0, Vector3D p1, OpticsColour c) {
        double len = p1.distanceTo(p0);
        Vector3D dir = p1.subtract(p0);
        Vector3D xRot = dir.calcRotation(Vector3D.X_AXIS).neg();
        double xRotMag = xRot.abs();
        Vector3D xRotNorm = Vector3D.X_AXIS;
        if (xRotMag != 0.0) {
            xRotNorm = xRot.scale(1.0 / xRotMag);
        }
        Color fc = c.getFxColor();
        Cylinder n = new Cylinder();
        n.setMaterial(new PhongMaterial(fc));
        n.setDrawMode(DrawMode.FILL);
        n.setRadius(1.0E-4);
        n.setHeight(len);
        n.getTransforms().clear();
        n.getTransforms().addAll((Transform[])new Transform[]{new Translate(p0.x, p0.y, p0.z), new Rotate(Math.toDegrees(xRotMag), new Point3D(xRotNorm.x, xRotNorm.y, xRotNorm.z)), new Rotate(90.0, Rotate.Y_AXIS), new Rotate(90.0, Rotate.X_AXIS), new Translate(0.0, len / 2.0, 0.0)});
        return n;
    }
}

