/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panelfx;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.shape.TriangleMesh;
import net.sourceforge.jocular.math.PolygonDicer;

public class RotatedMeshMaker {
    private static final int ROTATE_STEP_NUM = 60;
    private final PolygonDicer m_dicer;
    private final double m_angle;
    private final int m_numSteps;
    private final boolean m_completelyRound;

    public RotatedMeshMaker(PolygonDicer dicer, double angle) {
        this.m_dicer = dicer;
        this.m_angle = angle;
        this.m_completelyRound = angle >= Math.PI * 2;
        int s = (int)Math.round(60.0 * this.m_angle / Math.PI);
        if (s < 2) {
            s = 2;
        }
        this.m_numSteps = s;
    }

    protected TriangleMesh makeMesh() {
        int i;
        int n = this.m_dicer.getPointCount();
        float[] points = new float[this.m_numSteps * n * 3];
        ArrayList<Integer> faces = new ArrayList<Integer>();
        ArrayList<Integer> smoothing = new ArrayList<Integer>();
        TriangleMesh result = new TriangleMesh();
        result.getTexCoords().addAll(0.0f, 0.0f);
        double da = this.m_angle / (double)(this.m_numSteps - 1);
        boolean fn = false;
        for (int i2 = 0; i2 < n; ++i2) {
            for (int j = 0; j < this.m_numSteps; ++j) {
                int k = i2 * this.m_numSteps + j;
                int k3 = k * 3;
                double a = (double)j * da;
                double r = this.m_dicer.getYs()[i2];
                double z = this.m_dicer.getXs()[i2];
                double x = r * Math.cos(a);
                double y = r * Math.sin(a);
                points[k3 + 0] = (float)x;
                points[k3 + 1] = (float)y;
                points[k3 + 2] = (float)z;
            }
        }
        int smooth = 4;
        int stepOffest = this.m_completelyRound ? 0 : -1;
        for (int i3 = 0; i3 < n; ++i3) {
            if (!this.m_dicer.getSmooths()[i3]) {
                smooth <<= 1;
            }
            boolean ccw = this.m_dicer.isCcw();
            for (int j = 0; j < this.m_numSteps + stepOffest; ++j) {
                float r0 = (float)this.m_dicer.getYs()[i3 % n];
                float r1 = (float)this.m_dicer.getYs()[(i3 + 1) % n];
                int p0 = this.getIndex(i3, j);
                int p1 = this.getIndex(i3 + 1, j);
                int p2 = this.getIndex(i3 + 1, j + 1);
                int p3 = this.getIndex(i3, j + 1);
                if (ccw) {
                    int temp = p0;
                    p0 = p1;
                    p1 = temp;
                    temp = p2;
                    p2 = p3;
                    p3 = temp;
                }
                if ((double)r0 != 0.0) {
                    faces.add(p0);
                    faces.add(0);
                    faces.add(p1);
                    faces.add(0);
                    faces.add(p2);
                    faces.add(0);
                    smoothing.add(smooth);
                }
                if ((double)r1 == 0.0) continue;
                faces.add(p0);
                faces.add(0);
                faces.add(p2);
                faces.add(0);
                faces.add(p3);
                faces.add(0);
                smoothing.add(smooth);
            }
        }
        if (!this.m_completelyRound) {
            List<int[]> triangs = this.m_dicer.getTriangles();
            for (int[] is : triangs) {
                faces.add(is[0] * this.m_numSteps);
                faces.add(0);
                faces.add(is[1] * this.m_numSteps);
                faces.add(0);
                faces.add(is[2] * this.m_numSteps);
                faces.add(0);
                smoothing.add(1);
                faces.add((is[0] + 1) * this.m_numSteps - 1);
                faces.add(0);
                faces.add((is[2] + 1) * this.m_numSteps - 1);
                faces.add(0);
                faces.add((is[1] + 1) * this.m_numSteps - 1);
                faces.add(0);
                smoothing.add(2);
            }
        }
        int[] fs = new int[faces.size()];
        int[] ss = new int[smoothing.size()];
        for (i = 0; i < faces.size(); ++i) {
            fs[i] = (Integer)faces.get(i);
        }
        for (i = 0; i < smoothing.size(); ++i) {
            ss[i] = (Integer)smoothing.get(i);
        }
        result.getPoints().addAll(points);
        result.getFaces().addAll(fs);
        result.getFaceSmoothingGroups().addAll(ss);
        return result;
    }

    private int getIndex3(int i, int j, int k) {
        int n = this.m_dicer.getPointCount();
        return (i % n * this.m_numSteps + j % this.m_numSteps) * 3 + k;
    }

    private int getIndex(int i, int j) {
        int n = this.m_dicer.getPointCount();
        return i % n * this.m_numSteps + j % this.m_numSteps;
    }
}

