/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panelfx;

import java.awt.Component;
import java.awt.Rectangle;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;
import javafx.application.Platform;
import javafx.embed.swing.JFXPanel;
import javafx.geometry.Bounds;
import javafx.scene.AmbientLight;
import javafx.scene.Camera;
import javafx.scene.Group;
import javafx.scene.LightBase;
import javafx.scene.Node;
import javafx.scene.ParallelCamera;
import javafx.scene.PerspectiveCamera;
import javafx.scene.PointLight;
import javafx.scene.Scene;
import javafx.scene.SceneAntialiasing;
import javafx.scene.input.MouseEvent;
import javafx.scene.paint.Color;
import javafx.scene.transform.Rotate;
import javafx.scene.transform.Scale;
import javafx.scene.transform.Transform;
import javafx.scene.transform.Translate;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel3d;
import net.sourceforge.jocular.gui.panelfx.Shape3DFactory;
import net.sourceforge.jocular.imager.Imager;
import net.sourceforge.jocular.objects.OpticsObject;
import net.sourceforge.jocular.photons.PhotonTrajectory;
import net.sourceforge.jocular.photons.WranglerEvent;
import net.sourceforge.jocular.photons.WranglerListener;
import net.sourceforge.jocular.project.OpticsProject;
import net.sourceforge.jocular.properties.PropertyKey;
import net.sourceforge.jocular.properties.PropertyUpdatedEvent;
import net.sourceforge.jocular.properties.PropertyUpdatedListener;
import net.sourceforge.jocular.settings.Settings;

public class OpticsObjectPanelFx
implements OutputPanel3d {
    private JFXPanel panel = new JFXPanel();
    private Node m_topProjectNode = null;
    private Node m_axes = Shape3DFactory.makeAxis(50.0);
    private final Group m_root = new Group();
    private final Group m_photons = new Group();
    private final Scene m_scene = new Scene(this.m_root, 1000.0, 1000.0, true, SceneAntialiasing.BALANCED);
    private final Camera m_perspectiveCamera = new PerspectiveCamera(true);
    private final Camera m_parallelCamera = new ParallelCamera();
    private final Collection<PhotonTrajectory> m_photonTrajectories = new CopyOnWriteArrayList<PhotonTrajectory>();
    private double m_panX = 500.0;
    private double m_panY = 300.0;
    private double m_rotateX = 0.0;
    private double m_rotateY = 0.0;
    private double m_rotateZ = 0.0;
    private double m_scale = 10000.0;
    private double m_x = 0.0;
    private double m_y = 0.0;

    public OpticsObjectPanelFx() {
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                OpticsObjectPanelFx.this.m_parallelCamera.setNearClip(-10000.0);
                OpticsObjectPanelFx.this.m_parallelCamera.setFarClip(1.0E7);
                OpticsObjectPanelFx.this.m_perspectiveCamera.setTranslateZ(-2000.0);
                OpticsObjectPanelFx.this.m_perspectiveCamera.setNearClip(-10000.0);
                OpticsObjectPanelFx.this.m_perspectiveCamera.setFarClip(100000.0);
                LightBase light = new AmbientLight(new Color(0.5, 0.5, 0.5, 1.0));
                light.setTranslateZ(-2000.0);
                OpticsObjectPanelFx.this.m_root.getChildren().add(light);
                light = new PointLight();
                light.setTranslateZ(-2000.0);
                light.setTranslateX(2000.0);
                light.setTranslateY(2000.0);
                OpticsObjectPanelFx.this.m_root.getChildren().add(light);
                OpticsObjectPanelFx.this.m_root.getChildren().add(OpticsObjectPanelFx.this.m_axes);
                OpticsObjectPanelFx.this.m_root.getChildren().add(OpticsObjectPanelFx.this.m_photons);
                OpticsObjectPanelFx.this.m_scene.setFill(Color.ALICEBLUE);
                OpticsObjectPanelFx.this.m_scene.setCamera(OpticsObjectPanelFx.this.m_parallelCamera);
                OpticsObjectPanelFx.this.m_scene.addEventHandler(MouseEvent.MOUSE_DRAGGED, e -> OpticsObjectPanelFx.this.mouseDragged((MouseEvent)e));
                OpticsObjectPanelFx.this.m_scene.addEventHandler(MouseEvent.MOUSE_RELEASED, e -> OpticsObjectPanelFx.this.mouseReleased((MouseEvent)e));
                OpticsObjectPanelFx.this.m_scene.addEventHandler(MouseEvent.MOUSE_PRESSED, e -> OpticsObjectPanelFx.this.mousePressed((MouseEvent)e));
                OpticsObjectPanelFx.this.panel.setScene(OpticsObjectPanelFx.this.m_scene);
                OpticsObjectPanelFx.this.orient();
            }
        });
        Settings.SETTINGS.addPropertyUpdatedListener(new PropertyUpdatedListener(){

            @Override
            public void propertyUpdated(PropertyUpdatedEvent e) {
                if (e.getPropertyKey() == PropertyKey.PHOTON_COLOUR_SCHEME) {
                    OpticsObjectPanelFx.this.updateTrajectories();
                }
            }
        });
    }

    protected void mousePressed(MouseEvent e) {
        this.m_x = e.getSceneX();
        this.m_y = e.getSceneY();
    }

    private void orient() {
        Node n = this.m_topProjectNode;
        if (n != null) {
            n.getTransforms().clear();
            n.getTransforms().addAll((Transform[])new Transform[]{new Translate(this.m_panX, this.m_panY, 10.0), new Scale(this.m_scale, this.m_scale, this.m_scale), new Rotate(this.m_rotateX, Rotate.X_AXIS), new Rotate(this.m_rotateY, Rotate.Y_AXIS), new Rotate(this.m_rotateZ, Rotate.Z_AXIS), new Translate(0.0, 0.0, 0.0)});
        }
        this.m_photons.getTransforms().clear();
        this.m_photons.getTransforms().addAll((Transform[])new Transform[]{new Translate(this.m_panX, this.m_panY, 10.0), new Scale(this.m_scale, this.m_scale, this.m_scale), new Rotate(this.m_rotateX, Rotate.X_AXIS), new Rotate(this.m_rotateY, Rotate.Y_AXIS), new Rotate(this.m_rotateZ, Rotate.Z_AXIS), new Translate(0.0, 0.0, 0.0)});
        double h = this.m_scene.getHeight();
        this.m_axes.getTransforms().clear();
        this.m_axes.getTransforms().addAll((Transform[])new Transform[]{new Translate(50.0, h - 50.0, 0.0), new Rotate(this.m_rotateX, Rotate.X_AXIS), new Rotate(this.m_rotateY, Rotate.Y_AXIS), new Rotate(this.m_rotateZ, Rotate.Z_AXIS)});
    }

    protected void mouseReleased(MouseEvent e) {
        System.out.println("OpticsObjectPanelFx.mouseReleased");
    }

    protected void mouseDragged(MouseEvent e) {
        double dx = e.getSceneX() - this.m_x;
        double dy = e.getSceneY() - this.m_y;
        this.m_x = e.getSceneX();
        this.m_y = e.getSceneY();
        if (e.isMiddleButtonDown()) {
            this.m_rotateX += dy / 500.0 * 180.0;
            this.m_rotateY += dx / 500.0 * 180.0;
            this.orient();
        } else {
            this.m_panX += dx;
            this.m_panY += dy;
            this.orient();
        }
    }

    @Override
    public Component getComponent() {
        return this.panel;
    }

    @Override
    public void updatePanel() {
    }

    @Override
    public void zoomIn() {
        this.m_scale *= 1.41;
        this.orient();
    }

    @Override
    public void zoomOut() {
        this.m_scale *= 0.707;
        this.orient();
    }

    @Override
    public void zoomExtents() {
        Bounds b = this.m_topProjectNode.getBoundsInLocal();
        b = this.m_topProjectNode.getBoundsInParent();
        Rectangle r = this.panel.getBounds();
        System.out.println("OpticsObjectPanelFx.zoomExtents");
    }

    @Override
    public void resetPanel() {
    }

    @Override
    public void setProject(final OpticsProject project) {
        project.getWrangler().addWranglerListener(new WranglerListener(){

            @Override
            public void wranglingUpdate(WranglerEvent e) {
                Collection<OpticsObject> oos = project.getOpticsObject().getFlattenedObjectsOfType(Imager.class, false);
                for (OpticsObject oo : oos) {
                    oo.firePropertyUpdated(PropertyKey.IMAGE);
                }
                OpticsObjectPanelFx.this.m_photonTrajectories.clear();
                OpticsObjectPanelFx.this.m_photonTrajectories.addAll(e.getWrangler().getTrajectories());
                OpticsObjectPanelFx.this.updateTrajectories();
            }
        });
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                OpticsObjectPanelFx.this.m_root.getChildren().remove(OpticsObjectPanelFx.this.m_topProjectNode);
                OpticsObjectPanelFx.this.m_topProjectNode = new Shape3DFactory().create(project.getOpticsObject());
                OpticsObjectPanelFx.this.m_root.getChildren().add(OpticsObjectPanelFx.this.m_topProjectNode);
            }
        });
    }

    protected void updateTrajectories() {
        Platform.runLater(() -> {
            OutputPanel.PhotonRenderColour prc = Settings.SETTINGS.getPhotonColourScheme();
            this.m_photons.getChildren().clear();
            this.m_photons.getChildren().add(Shape3DFactory.makeTrajectory(this.m_photonTrajectories, prc));
        });
    }

    @Override
    public void setClipPLane(OutputPanel3d.ViewPlane plane) {
    }

    @Override
    public void setViewPlane(OutputPanel3d.ViewPlane plane) {
        Platform.runLater(() -> {
            switch (plane) {
                case NONE: {
                    break;
                }
                case XY_PLANE: {
                    this.m_rotateX = 180.0;
                    this.m_rotateY = 0.0;
                    this.m_rotateZ = 0.0;
                    break;
                }
                case ZX_PLANE: {
                    this.m_rotateX = 0.0;
                    this.m_rotateY = 90.0;
                    this.m_rotateZ = -90.0;
                    break;
                }
                case ZY_PLANE: {
                    this.m_rotateX = 180.0;
                    this.m_rotateY = 90.0;
                    this.m_rotateZ = 0.0;
                }
            }
            this.orient();
        });
    }

    @Override
    public void updateEverything() {
        this.orient();
        this.updateTrajectories();
    }

    @Override
    public void test() {
    }
}

