/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jocular.gui.panel;

import java.awt.Component;
import net.sourceforge.jocular.graphs.GraphPanel;
import net.sourceforge.jocular.gui.panel.OutputPanel;
import net.sourceforge.jocular.objects.SpectroPhotometer;

public class SpectroPhotometerPanel
implements OutputPanel {
    private SpectroPhotometer m_spectroPhotometer;
    private GraphPanel m_graph = null;
    private String series1Key = "Series 1";

    public SpectroPhotometerPanel(SpectroPhotometer sp) {
        this.m_spectroPhotometer = sp;
        this.m_graph = new GraphPanel();
        this.m_graph.setGraphType(GraphPanel.GraphType.BAR);
        this.updatePanel();
    }

    @Override
    public Component getComponent() {
        return this.m_graph;
    }

    @Override
    public void updatePanel() {
        double[] xs = this.m_spectroPhotometer.getBinCentres();
        double[] ys = this.m_spectroPhotometer.getBinValues();
        this.m_graph.updateGraph(this.series1Key, xs, ys);
        this.m_graph.autoScale(true, false, true, false);
        this.m_graph.repaint();
    }

    @Override
    public void zoomIn() {
    }

    @Override
    public void zoomOut() {
    }

    @Override
    public void zoomExtents() {
    }

    @Override
    public void resetPanel() {
        this.m_graph.zeroOffset();
    }
}

